<?php
use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\SRO_VT_ACCOUNT\TbUser;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\SRO_VT_PROXY\_Players;
use App\Models\SRO_VT_SHARD\AccountJID;
use App\Models\SRO_VT_ACCOUNT\SkSilk;
use App\Models\Z_A_BOTS_SYSTEMS\EventBasicsInfo;
use App\Models\Z_Website\User;

new class extends Component {
    public $user;
    public $userRole;
    public $hasAccess = false;
    public $stats = [];
    public $recentActivities = [];
    public $teamMembers = [];

    public function mount()
    {
        $this->user = Auth::user();

        // Check if user has required role level
        if ($this->user && $this->user->hasRoleLevel(3)) {
            $this->hasAccess = true;
            $this->userRole = $this->user->getRoleName();
            $this->loadDashboardData();
        }
    }

    // Helper function to format numbers nicely
    public function formatNumber($number)
    {
        if ($number >= 1000000000) {
            return round($number / 1000000000, 1) . 'B';
        } elseif ($number >= 1000000) {
            return round($number / 1000000, 1) . 'M';
        } elseif ($number >= 1000) {
            return round($number / 1000, 1) . 'K';
        }
        return number_format($number);
    }

    // Helper function to format gold amounts
    public function formatGold($amount)
    {
        if ($amount >= 1000000000) {
            return number_format($amount / 1000000000, 2) . 'B Gold';
        } elseif ($amount >= 1000000) {
            return number_format($amount / 1000000, 2) . 'M Gold';
        } elseif ($amount >= 1000) {
            return number_format($amount / 1000, 1) . 'K Gold';
        }
        return number_format($amount) . ' Gold';
    }

    // Helper function to get percentage change
    public function getPercentageChange($current, $previous)
    {
        if ($previous == 0) {
            return 0;
        }
        return round((($current - $previous) / $previous) * 100, 1);
    }

    public function loadDashboardData()
    {
        //Count TBUser
        $this->stats['total_players'] = TbUser::count();
        //Count all Chars from Char not online
        $this->stats['total_chars'] = Char::count();
        //Count all Players from _Players online
        $this->stats['total_players'] = _Players::where('cur_status', 1)->count();
        //Count online players per person distinct Serial
        $this->stats['online_players'] = _Players::where('cur_status', 1)->distinct('Serial')->count('Serial');
        //Sum Game Gold from Char RemainGold + AccountJID Gold
        $this->stats['total_gold'] = Char::sum('RemainGold') + AccountJID::sum('Gold');
        //Sum 4TDonate from SkSilk silk_gift
        $this->stats['total_4tdonate'] = SkSilk::sum('silk_gift');
        //Sum Silk from SkSilk silk_own
        $this->stats['total_silk'] = SkSilk::sum('silk_own');
        //Total balance from User
        $this->stats['total_balance'] = User::sum('balance');
        //gift_balance
        $this->stats['total_gift_balance'] = User::sum('gift_balance');

        // Additional calculated stats for better display
        $this->stats['total_accounts'] = TBUser::count();
        $this->stats['total_registrations_today'] = TBUser::whereDate('regtime', today())->count();
        $this->stats['server_uptime'] = '99.9%';

        // Active events from EventBasicsInfo where Active = 1 and has active timers
        $this->stats['active_events'] = EventBasicsInfo::where('Active', 1)
            ->whereHas('activeTimers')
            ->count();

        $this->stats['pending_reports'] = 12;
        $this->stats['daily_registrations'] = $this->stats['total_registrations_today'];
    }

    public function refreshStats()
    {
        $this->loadDashboardData();
        $this->dispatch('stats-refreshed');
    }
}; ?>



<div x-data="{
    loaded: false,
    currentTime: new Date().toLocaleTimeString(),
    animationDelay: 0,

    init() {
        // Initialize animations
        setTimeout(() => { this.loaded = true; }, 100);

        // Update time every second
        setInterval(() => {
            this.currentTime = new Date().toLocaleTimeString();
        }, 1000);
    },

    getAnimationDelay() {
        this.animationDelay += 100;
        return this.animationDelay;
    }
}" x-cloak class="team-dashboard-container">

    @if (!$hasAccess)
        <!-- Access Denied -->
        <div class="team-access-denied" x-show="loaded" x-transition:enter="team-fade-in"
            x-transition:enter-start="team-fade-out" x-transition:enter-end="team-fade-in">
            <div class="team-access-denied-content">
                <div class="team-access-denied-icon">
                    <svg width="64" height="64" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                        stroke-width="2">
                        <circle cx="12" cy="12" r="10" />
                        <line x1="4.93" y1="4.93" x2="19.07" y2="19.07" />
                    </svg>
                </div>
                <h2 data-translate="team.access.denied.title">Access Denied</h2>
                <p data-translate="team.access.denied.message">You don't have sufficient privileges to access this page.
                </p>
                <p data-translate="team.access.denied.requirement">Minimum required level: 2</p>
            </div>
        </div>
    @else
        <!-- Team Dashboard -->
        <div class="team-dashboard-wrapper" x-show="loaded" x-transition:enter="team-slide-up"
            x-transition:enter-start="team-slide-down" x-transition:enter-end="team-slide-up">

            <!-- Dashboard Header -->
            <div class="team-dashboard-header" x-show="loaded" x-transition:enter="team-fade-in"
                x-transition:enter-start="team-fade-out" x-transition:enter-end="team-fade-in"
                x-transition:enter.delay.200ms>
                <div class="team-header-content">
                    <div class="team-header-info">
                        <h1 data-translate="team.dashboard.title">Team Management Dashboard</h1>
                        <p data-translate="team.dashboard.subtitle">Monitor and manage server operations efficiently</p>
                        <div class="team-header-meta">
                            <span class="team-role-badge team-role-{{ strtolower($userRole) }}">
                                <svg width="14" height="14" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" style="margin-right: 6px;">
                                    <path d="M9 12l2 2 4-4"/>
                                    <circle cx="12" cy="12" r="9"/>
                                </svg>
                                {{ $userRole ?? 'Team Member' }}
                            </span>
                            <span class="team-time-display" x-text="currentTime">
                            </span>
                        </div>
                    </div>
                    <div class="team-header-actions">
                        <button wire:click="refreshStats" class="team-refresh-btn team-btn-glow" x-data="{ refreshing: false }"
                            @click="refreshing = true; setTimeout(() => refreshing = false, 1000)"
                            :class="{ 'team-btn-loading': refreshing }">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                                stroke-width="2" :class="{ 'team-spin': refreshing }">
                                <polyline points="23 4 23 10 17 10" />
                                <path d="M20.49 15a9 9 0 1 1-2.12-9.36L23 10" />
                            </svg>
                            <span data-translate="team.actions.refresh">Refresh Data</span>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Stats Grid -->
            <div class="team-stats-grid">
                <!-- Total Players -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.300ms>
                    <div class="team-stat-icon team-stat-players">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2" />
                            <circle cx="9" cy="7" r="4" />
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87" />
                            <path d="M16 3.13a4 4 0 0 1 0 7.75" />
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3 data-translate="team.stats.total_players">Total Accounts</h3>
                        <p class="team-stat-number large-number" data-value="{{ $stats['total_accounts'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['total_accounts']) }}
                        </p>
                        <span class="team-stat-change team-stat-positive">
                            +{{ $stats['total_registrations_today'] }} today
                        </span>
                    </div>
                </div>

                <!-- Online Players -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.400ms>
                    <div class="team-stat-icon team-stat-online">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <circle cx="12" cy="12" r="3" />
                            <path d="M12 1v6m0 6v6m11-7h-6m-6 0H1" />
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3 data-translate="team.stats.online_players">Online Players</h3>
                        <p class="team-stat-number" data-value="{{ $stats['online_players'] }}" data-animate="true">
                            {{ $this->formatNumber($stats['online_players']) }}
                        </p>
                        <span class="team-stat-change team-stat-neutral">Live count</span>
                    </div>
                </div>

                <!-- Total Characters -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.500ms>
                    <div class="team-stat-icon team-stat-uptime">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <path d="M16 4h2a2 2 0 0 1 2 2v14a2 2 0 0 1-2 2H6a2 2 0 0 1-2-2V6a2 2 0 0 1 2-2h2" />
                            <rect x="8" y="2" width="8" height="4" rx="1" ry="1" />
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3>Total Characters</h3>
                        <p class="team-stat-number large-number" data-value="{{ $stats['total_chars'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['total_chars']) }}
                        </p>
                        <span class="team-stat-change team-stat-positive">Created</span>
                    </div>
                </div>

                <!-- Total Gold -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.600ms>
                    <div class="team-stat-icon team-stat-events"
                        style="background: linear-gradient(135deg, #f59e0b, #d97706);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <circle cx="12" cy="12" r="10" />
                            <path d="M12 6v6l4 2" />
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3>Total Gold</h3>
                        <p class="team-stat-number gold-number" data-value="{{ $stats['total_gold'] }}"
                            data-animate="true">
                            {{ $this->formatGold($stats['total_gold']) }}
                        </p>
                        <span class="team-stat-change team-stat-positive">Economy</span>
                    </div>
                </div>

                <!-- Total Silk -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.700ms>
                    <div class="team-stat-icon" style="background: linear-gradient(135deg, #8b5cf6, #7c3aed);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <path d="M12 2L2 7l10 5 10-5-10-5z" />
                            <path d="M2 17l10 5 10-5" />
                            <path d="M2 12l10 5 10-5" />
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3>Total Silk</h3>
                        <p class="team-stat-number silk-number" data-value="{{ $stats['total_silk'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['total_silk']) }}
                        </p>
                        <span class="team-stat-change team-stat-neutral">Premium Currency</span>
                    </div>
                </div>

                <!-- 4T Donate -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.800ms>
                    <div class="team-stat-icon" style="background: linear-gradient(135deg, #ef4444, #dc2626);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <path
                                d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z" />
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3>4T Donate</h3>
                        <p class="team-stat-number donate-number" data-value="{{ $stats['total_4tdonate'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['total_4tdonate']) }}
                        </p>
                        <span class="team-stat-change team-stat-positive">Donations</span>
                    </div>
                </div>

                <!-- Total Balance -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.900ms>
                    <div class="team-stat-icon" style="background: linear-gradient(135deg, #10b981, #059669);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <rect x="1" y="3" width="15" height="13" rx="2" ry="2"/>
                            <path d="M16 8h4a2 2 0 0 1 2 2v6a2 2 0 0 1-2 2H6"/>
                            <circle cx="5.5" cy="11.5" r="2.5"/>
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3>Website Balance</h3>
                        <p class="team-stat-number" style="color: #10b981;" data-value="{{ $stats['total_balance'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['total_balance']) }}
                        </p>
                        <span class="team-stat-change team-stat-positive">Website Credits</span>
                    </div>
                </div>

                <!-- Gift Balance -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.1000ms>
                    <div class="team-stat-icon" style="background: linear-gradient(135deg, #f97316, #ea580c);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <polyline points="20,12 20,22 4,22 4,12"/>
                            <rect x="2" y="7" width="20" height="5"/>
                            <line x1="12" y1="22" x2="12" y2="7"/>
                            <path d="M12 7H7.5a2.5 2.5 0 0 1 0-5C11 2 12 7 12 7z"/>
                            <path d="M12 7h4.5a2.5 2.5 0 0 0 0-5C13 2 12 7 12 7z"/>
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3>Gift Balance</h3>
                        <p class="team-stat-number" style="color: #f97316;" data-value="{{ $stats['total_gift_balance'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['total_gift_balance']) }}
                        </p>
                        <span class="team-stat-change team-stat-neutral">Bonus Credits</span>
                    </div>
                </div>

                <!-- Active Events -->
                <div class="team-stat-card" x-show="loaded" x-transition:enter="team-scale-in"
                    x-transition:enter-start="team-scale-out" x-transition:enter-end="team-scale-in"
                    x-transition:enter.delay.1100ms>
                    <div class="team-stat-icon" style="background: linear-gradient(135deg, #6366f1, #4f46e5);">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor"
                            stroke-width="2">
                            <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                            <line x1="16" y1="2" x2="16" y2="6"/>
                            <line x1="8" y1="2" x2="8" y2="6"/>
                            <line x1="3" y1="10" x2="21" y2="10"/>
                            <circle cx="8" cy="14" r="1"/>
                            <circle cx="12" cy="14" r="1"/>
                            <circle cx="16" cy="14" r="1"/>
                            <circle cx="8" cy="18" r="1"/>
                            <circle cx="12" cy="18" r="1"/>
                        </svg>
                    </div>
                    <div class="team-stat-content">
                        <h3 data-translate="team.stats.active_events">Active Events</h3>
                        <p class="team-stat-number" style="color: #6366f1;" data-value="{{ $stats['active_events'] }}"
                            data-animate="true">
                            {{ $this->formatNumber($stats['active_events']) }}
                        </p>
                        <span class="team-stat-change team-stat-positive">Running Now</span>
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>
