@if($isVisible)
<div class="fixed bottom-4 right-4 z-50 max-w-md">
    <div class="bg-white dark:bg-gray-800 rounded-lg shadow-lg border border-gray-200 dark:border-gray-700">
        <!-- Header -->
        <div class="flex items-center justify-between p-4 border-b border-gray-200 dark:border-gray-700">
            <div class="flex items-center space-x-2">
                <div class="w-3 h-3 rounded-full {{ $healthData['overall_status'] === 'healthy' ? 'bg-green-500' : ($healthData['overall_status'] === 'issues_detected' ? 'bg-yellow-500' : 'bg-red-500') }}"></div>
                <h3 class="text-sm font-semibold text-gray-900 dark:text-white">
                    حالة النظام
                </h3>
            </div>
            <div class="flex items-center space-x-2">
                <button wire:click="refresh" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                    <i class="fas fa-sync-alt text-sm"></i>
                </button>
                <button wire:click="hide" class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300">
                    <i class="fas fa-times text-sm"></i>
                </button>
            </div>
        </div>

        <!-- Content -->
        <div class="p-4">
            @if($healthData['overall_status'] === 'error')
                <div class="text-red-600 dark:text-red-400">
                    <i class="fas fa-exclamation-triangle mr-2"></i>
                    {{ $healthData['error_message'] ?? 'خطأ في فحص النظام' }}
                </div>
            @else
                <!-- Database Connections -->
                @if(isset($healthData['database_connections']))
                <div class="mb-3">
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">قواعد البيانات</span>
                        <span class="text-xs {{ $healthData['database_connections']['status'] === 'ok' ? 'text-green-600' : 'text-red-600' }}">
                            {{ $healthData['database_connections']['status'] === 'ok' ? 'متصلة' : 'مشكلة' }}
                        </span>
                    </div>
                    @foreach($healthData['database_connections']['connections'] as $name => $connection)
                    <div class="flex items-center justify-between text-xs text-gray-600 dark:text-gray-400">
                        <span>{{ ucfirst($name) }}</span>
                        <span class="{{ $connection['status'] === 'ok' ? 'text-green-600' : 'text-red-600' }}">
                            <i class="fas {{ $connection['status'] === 'ok' ? 'fa-check' : 'fa-times' }}"></i>
                        </span>
                    </div>
                    @endforeach
                </div>
                @endif

                <!-- Livewire Errors -->
                @if(isset($healthData['livewire_errors']))
                <div class="mb-3">
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Livewire</span>
                        <span class="text-xs {{ $healthData['livewire_errors']['status'] === 'ok' ? 'text-green-600' : ($healthData['livewire_errors']['status'] === 'warning' ? 'text-yellow-600' : 'text-red-600') }}">
                            @if($healthData['livewire_errors']['status'] === 'ok')
                                طبيعي
                            @elseif($healthData['livewire_errors']['status'] === 'warning')
                                تحذير
                            @else
                                خطأ
                            @endif
                        </span>
                    </div>
                    @if(isset($healthData['livewire_errors']['recent_errors']))
                    <div class="text-xs text-gray-600 dark:text-gray-400">
                        الأخطاء الحديثة: {{ $healthData['livewire_errors']['recent_errors'] }}
                    </div>
                    @endif
                </div>
                @endif

                <!-- Cache Health -->
                @if(isset($healthData['cache_health']))
                <div class="mb-3">
                    <div class="flex items-center justify-between mb-2">
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Cache</span>
                        <span class="text-xs {{ $healthData['cache_health']['status'] === 'ok' ? 'text-green-600' : 'text-red-600' }}">
                            {{ $healthData['cache_health']['status'] === 'ok' ? 'يعمل' : 'معطل' }}
                        </span>
                    </div>
                    <div class="text-xs text-gray-600 dark:text-gray-400">
                        Driver: {{ $healthData['cache_health']['driver'] ?? 'Unknown' }}
                    </div>
                </div>
                @endif

                <!-- Actions -->
                @if($healthData['overall_status'] !== 'healthy')
                <div class="mt-4 pt-3 border-t border-gray-200 dark:border-gray-700">
                    <button wire:click="fixIssues" class="w-full bg-blue-600 hover:bg-blue-700 text-white text-xs font-medium py-2 px-3 rounded transition-colors">
                        <i class="fas fa-wrench mr-1"></i>
                        محاولة الإصلاح
                    </button>
                </div>
                @endif
            @endif

            <!-- Last Update -->
            @if($lastUpdate)
            <div class="mt-2 pt-2 border-t border-gray-200 dark:border-gray-700">
                <div class="text-xs text-gray-500 dark:text-gray-400 text-center">
                    آخر تحديث: {{ $lastUpdate }}
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endif
