<div>
    <!-- Modal Overlay -->
    @if($isOpen)
        <div class="fixed inset-0 z-50 overflow-y-auto player-modal-overlay"
             wire:click="closeModal"
             x-data
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0">

            <div class="flex items-center justify-center min-h-screen pt-4 px-4 pb-20 text-center sm:block sm:p-0">
                <!-- Modal Content -->
                <div class="player-modal-content inline-block align-bottom bg-slate-800 rounded-lg text-left overflow-hidden shadow-xl transform transition-all sm:my-8 sm:align-middle sm:max-w-2xl sm:w-full"
                     wire:click.stop
                     x-transition:enter="transition ease-out duration-300"
                     x-transition:enter-start="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95"
                     x-transition:enter-end="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave="transition ease-in duration-200"
                     x-transition:leave-start="opacity-100 translate-y-0 sm:scale-100"
                     x-transition:leave-end="opacity-0 translate-y-4 sm:translate-y-0 sm:scale-95">

                    <!-- Modal Header -->
                    <div class="bg-gradient-to-r from-purple-600 to-blue-600 px-6 py-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-4">
                                @if($playerData)
                                    <!-- Player Avatar -->
                                    <div class="w-16 h-16 rounded-full overflow-hidden border-4 border-white/20">
                                        <img src="{{ $playerData['avatar'] ?? '/assets/images/avatars/default.gif' }}"
                                             alt="{{ $playerData['charName'] ?? 'Player' }}"
                                             class="w-full h-full object-cover">
                                    </div>

                                    <!-- Player Info -->
                                    <div>
                                        <h3 class="text-xl font-bold text-white">
                                            {{ $playerData['charName'] ?? 'Unknown Player' }}
                                        </h3>
                                        @if($playerData['rank'] ?? null)
                                            <p class="text-purple-200">Rank #{{ $playerData['rank'] }}</p>
                                        @endif
                                        @if($playerData['points'] ?? null)
                                            <p class="text-blue-200">{{ number_format($playerData['points']) }} Points</p>
                                        @endif
                                    </div>
                                @endif
                            </div>

                            <!-- Close Button with RTL/LTR support -->
                            <x-modal-close-button action="closeModal" position="relative" class="ml-4 rtl:ml-0 rtl:mr-4" />
                        </div>
                    </div>

                    <!-- Modal Body -->
                    <div class="px-6 py-6">
                        @if($loading)
                            <!-- Loading State -->
                            <div class="flex items-center justify-center py-12">
                                <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-purple-600"></div>
                                <span class="ml-3 text-white">Loading equipment...</span>
                            </div>
                        @elseif($playerData)
                            <!-- Player Stats (if available) -->
                            @if(isset($playerData['kills']) || isset($playerData['deaths']))
                                <div class="mb-6 bg-slate-700/50 rounded-lg p-4">
                                    <h4 class="text-lg font-semibold text-white mb-3">Player Stats</h4>
                                    <div class="grid grid-cols-2 gap-4 text-sm">
                                        @if(isset($playerData['kills']))
                                            <div>
                                                <span class="text-slate-400">Kills:</span>
                                                <span class="text-green-400 ml-2 font-semibold">{{ number_format($playerData['kills']) }}</span>
                                            </div>
                                        @endif
                                        @if(isset($playerData['deaths']))
                                            <div>
                                                <span class="text-slate-400">Deaths:</span>
                                                <span class="text-red-400 ml-2 font-semibold">{{ number_format($playerData['deaths']) }}</span>
                                            </div>
                                        @endif
                                        @if(isset($playerData['kills']) && isset($playerData['deaths']) && $playerData['deaths'] > 0)
                                            <div class="col-span-2">
                                                <span class="text-slate-400">K/D Ratio:</span>
                                                <span class="text-yellow-400 ml-2 font-semibold">
                                                    {{ number_format($playerData['kills'] / $playerData['deaths'], 2) }}
                                                </span>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            @endif

                            <!-- Equipment Section -->
                            <div class="mb-6">
                                <h4 class="text-lg font-semibold text-white mb-4 flex items-center">
                                    <i class="fas fa-shield-alt text-purple-400 mr-2"></i>
                                    Equipment
                                </h4>

                                <!-- Inventory Component -->
                                <div class="flex justify-center">
                                    <x-silkroad-inventory
                                        :char-id="$playerData['charName'] ?? null"
                                        :items="$equipment"
                                    />
                                </div>
                            </div>

                            <!-- Additional Actions -->
                            <div class="flex justify-center space-x-4 pt-4 border-t border-slate-600">
                                @if($playerData['is_owned'] ?? false)
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-sm font-medium bg-green-100 text-green-800">
                                        <i class="fas fa-user-check mr-1"></i>
                                        Your Character
                                    </span>
                                @endif

                                <button wire:click="closeModal"
                                        class="px-6 py-2 bg-slate-600 hover:bg-slate-700 text-white rounded-lg transition-colors duration-200 flex items-center space-x-2 group">
                                    <x-icons.arrow-left class="transition-transform duration-200 group-hover:-translate-x-1" />
                                    <span>Close</span>
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @endif
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Handle escape key
    document.addEventListener('keydown', function(e) {
        if (e.key === 'Escape') {
            Livewire.dispatch('player-modal-close');
        }
    });
});
</script>
@endpush
