<?php

use Livewire\Volt\Component;
use App\Models\Z_A_BOTS_SYSTEMS\EventBasicsInfo;
use Livewire\Attributes\On;

new class extends Component {
    public $activeEvents = [];
    public $selectedEventId = null;

    public function mount()
    {
        $this->loadActiveEvents();
        // Select first event by default
        if (!empty($this->activeEvents)) {
            $this->selectedEventId = $this->activeEvents[0]['id'];
            $this->dispatch('event-selected-from-tabs', $this->selectedEventId);
        }
    }

    public function loadActiveEvents()
    {
        try {
            // تحميل الإيفنتس النشطة فقط ضمن النطاق الزمني الحالي
            // باستخدام العلاقة activeTimers التي تطبق شرط BETWEEN Start_Time AND End_Time
            $this->activeEvents = EventBasicsInfo::where('Active', true)
                ->whereHas('rules', function ($query) {
                    $query->where('Reset', true);
                })
                ->whereHas('activeTimers')
                ->with(['activeTimers'])
                ->get()
                ->map(function ($event) {
                    return [
                        'id' => $event->ID,
                        'name' => $event->EventName,
                        'timer' => $event->activeTimers->first(),
                    ];
                })
                ->toArray();
        } catch (\Exception $e) {
            $this->activeEvents = [];
            // Silently handle error
        }
    }

    public function selectEvent($eventId)
    {
        // Prevent unnecessary updates if same event is selected
        if ($this->selectedEventId == $eventId) {
            return;
        }

        $this->selectedEventId = $eventId;

        // Only dispatch to parent component to avoid duplication
        $this->dispatch('event-selected-from-tabs', $eventId);
    }

    #[On('refresh-events')]
    public function refreshActiveEvents()
    {
        $this->loadActiveEvents();
        $this->dispatch('events-updated');
    }
};
?>
<div>
@if (empty($activeEvents))
    <!-- No Active Events -->
    <div class="no-events">
        <div class="no-events-icon">
            <i class="fas fa-trophy"></i>
        </div>
        <h2 class="no-events-title" data-translate="rankings.noActiveEvents" wire:ignore>No Active Events</h2>
        <p class="no-events-description" data-translate="rankings.noActiveEventsDesc" wire:ignore>There are currently no
            active events. Check back later!</p>
    </div>
@else
    <!-- Event Tabs -->
    <div class="mb-8">
        <div class="event-tabs">
            @foreach ($activeEvents as $event)
                <button wire:click="selectEvent({{ $event['id'] }})"
                    class="event-tab {{ $selectedEventId == $event['id'] ? 'active' : '' }}">
                    <i class="fas fa-star mr-2"></i>
                    {{ $event['name'] }}
                </button>
            @endforeach
        </div>
    </div>
@endif
</div>
