<?php

use Livewire\Volt\Component;
use Livewire\Attributes\On;

new class extends Component {
    public $topPlayers = [];
    public $otherPlayers = [];

    #[On('players-loaded')]
    public function updatePlayers($topPlayers, $otherPlayers)
    {
        $this->topPlayers = $topPlayers;
        $this->otherPlayers = $otherPlayers;
    }

    #[On('refresh-events')]
    public function refreshStatistics()
    {
        // Statistics will be automatically updated when players data is refreshed
        $this->dispatch('statistics-refreshed');
    }
};
?>
<div>

    <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
        <!-- Total Players -->
        <div class="text-center">
            <div
                class="bg-gradient-to-br from-green-500/20 to-green-900/40 rounded-xl p-4 border border-green-500/30 stats-card">
                <div class="text-3xl font-bold text-green-400 mb-2">
                    {{ count($topPlayers) + count($otherPlayers) }}</div>
                <div class="text-green-200 text-sm" data-translate="rankings.totalPlayers" wire:ignore>Total
                    Players</div>
            </div>
        </div>

        <!-- Total Points -->
        <div class="text-center">
            <div
                class="bg-gradient-to-br from-yellow-500/20 to-yellow-900/40 rounded-xl p-4 border border-yellow-500/30 stats-card">
                <div class="text-3xl font-bold text-yellow-400 mb-2">
                    {{ number_format(collect(array_merge($topPlayers, $otherPlayers))->sum('points')) }}
                </div>
                <div class="text-yellow-200 text-sm" data-translate="rankings.totalPoints" wire:ignore>
                    Total Points</div>
            </div>
        </div>

        <!-- Competition Level -->
        <div class="text-center">
            <div
                class="bg-gradient-to-br from-purple-500/20 to-purple-900/40 rounded-xl p-4 border border-purple-500/30 stats-card">
                <div class="text-3xl font-bold text-purple-400 mb-2">
                    @if (count($topPlayers) + count($otherPlayers) > 20)
                        <i class="fas fa-fire"></i> HIGH
                    @elseif(count($topPlayers) + count($otherPlayers) > 10)
                        <i class="fas fa-bolt"></i> MED
                    @else
                        <i class="fas fa-leaf"></i> LOW
                    @endif
                </div>
                <div class="text-purple-200 text-sm" data-translate="rankings.competitionLevel" wire:ignore>
                    Competition</div>
            </div>
        </div>
    </div>

</div>
