# Player Modal Component & Job Badges System

تم فصل مودال الشخصية إلى مكون منفصل وإضافة نظام Job Badges ملون لتمييز المهن.

## هيكل الملفات

### المكونات الرئيسية:
- `event-rank-modular.blade.php` - الصفحة الرئيسية للترتيبات
- `player-modal.blade.php` - مكون المودال المنفصل
- `top-players-container.blade.php` - مكون أفضل 3 لاعبين
- `rankings-table.blade.php` - جدول باقي اللاعبين

### ملفات الدعم:
- `player-modal.css` - تصميم المودال
- `job-badges.css` - تصميم شارات المهن
- `player-modal.js` - معالجة الأحداث والتفاعل

## نظام Job Badges

### 🎨 الألوان والأيقونات:

| المهنة | اللون | الأيقونة | الوصف |
|-------|-------|---------|-------|
| **Trader** | 🟢 Green | `fa-coins` | التاجر - أخضر |
| **Thief** | 🟣 Violet | `fa-mask` | اللص - بنفسجي |
| **Hunter** | 🔵 Blue | `fa-crosshairs` | الصياد - أزرق |
| **No Job** | ⚪ Gray | `fa-question-circle` | بدون مهنة - رمادي |

### 🎯 المميزات:
- **تأثيرات بصرية**: hover effects مع إضاءة ملونة
- **أيقونات مميزة**: لكل مهنة أيقونة مناسبة
- **تصميم متجاوب**: يتكيف مع جميع الشاشات
- **انتقالات سلسة**: animations ناعمة

### 📱 أحجام مختلفة:
```css
.job-badge-sm    /* صغير - للجداول */
.job-badge-md    /* متوسط - للكروت */
.job-badge-lg    /* كبير - للمودال */
```

## كيفية العمل

### 1. تفعيل المودال:
```javascript
Livewire.dispatch('player-modal-open', [playerData]);
```

### 2. إغلاق المودال:
```javascript
Livewire.dispatch('player-modal-close');
```

### 3. بيانات اللاعب المرسلة:
```javascript
{
    charName: "اسم الشخصية",
    rank: 1,
    points: 1000,
    kills: 50,
    deaths: 10,
    avatar: "/path/to/avatar.gif",
    is_owned: true,
    refObjID: 1907,
    job_type: 1  // 0=No Job, 1=Trader, 2=Thief, 3=Hunter
}
```

## استخدام Job Badges

### في PHP:
```php
// الحصول على كلاسات CSS
$badgeClasses = $this->getJobBadgeClasses($jobType);
$icon = $this->getJobIcon($jobType);

// عرض Badge
<div class="job-badge-with-icon {{ $badgeClasses }}">
    <i class="{{ $icon }}"></i>
    {{ $this->getJobTypeName($jobType) }}
</div>
```

### في CSS:
```css
/* badge مخصص */
.custom-job-badge {
    @apply job-badge job-badge-md;
}

/* ألوان مخصصة */
.custom-trader {
    @apply job-trader;
}
```

## المميزات الحالية

### 🎮 عرض معلومات اللاعب:
- **معلومات أساسية**: اسم، ترتيب، نقاط
- **إحصائيات مفصلة**: قتل، موت، نسبة K/D
- **معلومات الشخصية**: مهنة، عرق، جنس
- **مؤشرات بصرية**: للملكية والترتيب

### ✨ تأثيرات بصرية:
- **تصميم متجاوب وجميل**
- **انتقالات سلسة**
- **إضاءة ملونة للمهن**
- **أيقونات معبرة**

## التطوير المستقبلي

يمكن بسهولة إضافة:
- **مهن جديدة** مع ألوان وأيقونات مختلفة
- **رتب فرعية** لكل مهنة
- **شارات إنجازات** خاصة
- **نظام نقاط الخبرة** لكل مهنة
- **مهارات خاصة** بكل مهنة

## استخدام المكون

```blade
<!-- في أي ملف Blade -->
<livewire:frontend.event-rankings.player-modal />
```

المودال سيستمع تلقائياً لأحداث فتح وإغلاق المودال ويعرض المعلومات مع Job Badges الملونة! 🎮✨
