<?php

use Livewire\Volt\Component;
use App\Models\Z_A_BOTS_SYSTEMS\EventBasicsInfo;

new class extends Component {
    public $selectedEventId = null;
    public $topPlayers = [];
    public $otherPlayers = [];

    // Listen for player data updates
    protected $listeners = [
        'top-players-loaded' => 'updateTopPlayers',
        'other-players-loaded' => 'updateOtherPlayers',
        'event-selected' => 'updateSelectedEvent',
        'event-selected-from-tabs' => 'updateSelectedEvent',
    ];

    public function mount()
    {
        // Initialize with first active event if available
        $this->initializeSelectedEvent();

        // Load initial data if event is selected
        if ($this->selectedEventId) {
            $this->dispatch('event-selected', $this->selectedEventId);
        }
    }

    private function initializeSelectedEvent()
    {
        try {
            // البحث عن أول إيفنت نشط ضمن النطاق الزمني الحالي
            // يتم التحقق من:
            // 1. Active = true (الإيفنت مفعل)
            // 2. rules.Reset = true (القواعد مفعلة)
            // 3. GETDATE() BETWEEN Start_Time AND End_Time (الوقت الحالي ضمن نطاق الإيفنت)
            $firstActiveEvent = \App\Models\Z_A_BOTS_SYSTEMS\EventBasicsInfo::where('Active', true)
                ->whereHas('rules', function ($query) {
                    $query->where('Reset', true);
                })
                ->whereHas('activeTimers')
                ->first();

            if ($firstActiveEvent) {
                $this->selectedEventId = $firstActiveEvent->ID;
            }
        } catch (\Exception $e) {
            // Silently handle initialization error
        }
    }

    public function updateSelectedEvent($eventId)
    {
        // Prevent unnecessary updates if same event is already selected
        if ($this->selectedEventId == $eventId) {
            return;
        }

        $this->selectedEventId = $eventId;

        // Dispatch the event to all child components
        $this->dispatch('event-selected', $eventId);
    }

    public function updateTopPlayers($topPlayers)
    {
        $this->topPlayers = $topPlayers;
        $this->dispatch('players-loaded', $this->topPlayers, $this->otherPlayers);
    }

    public function updateOtherPlayers($otherPlayers)
    {
        $this->otherPlayers = $otherPlayers;
        $this->dispatch('players-loaded', $this->topPlayers, $this->otherPlayers);
    }

    // Centralized refresh method to avoid multiple polling
    public function refreshData()
    {
        // Initialize selected event if not set
        if (!$this->selectedEventId) {
            $this->initializeSelectedEvent();
        }

        if ($this->selectedEventId) {
            // Dispatch refresh to child components in a controlled manner
            $this->dispatch('event-selected', $this->selectedEventId);
        }

        // Refresh events
        $this->dispatch('refresh-events');
    }
};
?>

<div class="event-rankings" wire:poll.10s="refreshData">
    <div class="container mx-auto px-6 py-8">

        <!-- Page Header -->
        <livewire:frontend.event-rankings.event-header />

        <!-- Event Tabs -->
        <livewire:frontend.event-rankings.event-tabs wire:model="selectedEventId" />

        @if ($selectedEventId)
            <!-- Event Info and Timer -->
            <div class="event-info-grid">
                <!-- Event Rules -->
                <div class="event-info-item">
                    <livewire:frontend.event-rankings.event-info :selectedEventId="$selectedEventId" />
                </div>

                <!-- Event Timer -->
                <div class="event-info-item">
                    <livewire:frontend.event-rankings.event-timer :selectedEventId="$selectedEventId" />
                </div>
            </div>

            <!-- Voting System - Only for Event ID 21 -->
            @if (Auth::check() && $selectedEventId == 21)
                <livewire:frontend.event-rankings.voting-system :selectedEventId="$selectedEventId" />
            @else
                @if ($selectedEventId == 21)
                    <!-- Enhanced Login Required Section for Voting -->
                    <div class="mb-8">
                        <div class="relative overflow-hidden rounded-2xl bg-gradient-to-r from-purple-900/40 to-blue-900/40 backdrop-blur-lg border border-purple-500/30 p-8 shadow-2xl group hover:shadow-purple-500/20 transition-all duration-500">
                            <!-- Dynamic animated background waves -->
                            <div class="absolute inset-0 bg-gradient-to-r from-purple-600/10 via-blue-600/10 to-green-600/10 animate-pulse"></div>
                            <div class="absolute inset-0 opacity-20">
                                <div class="absolute inset-0 bg-gradient-to-r from-purple-500/30 via-pink-500/30 to-blue-500/30 animate-bounce" style="animation-duration: 3s;"></div>
                                <div class="absolute inset-0 bg-gradient-to-l from-blue-500/20 via-cyan-500/20 to-purple-500/20 animate-pulse" style="animation-delay: 1s; animation-duration: 4s;"></div>
                            </div>

                            <!-- Enhanced floating particles with different animations -->
                            <div class="absolute inset-0 overflow-hidden">
                                <div class="absolute w-3 h-3 bg-gradient-to-r from-purple-400 to-pink-400 rounded-full animate-bounce opacity-60 top-4 left-1/4" style="animation-delay: 0s; animation-duration: 2s;"></div>
                                <div class="absolute w-2 h-2 bg-gradient-to-r from-blue-400 to-cyan-400 rounded-full animate-ping opacity-50 top-8 right-1/4" style="animation-delay: 1s;"></div>
                                <div class="absolute w-2.5 h-2.5 bg-gradient-to-r from-green-400 to-emerald-400 rounded-full animate-bounce opacity-70 bottom-8 left-1/3" style="animation-delay: 2s; animation-duration: 1.5s;"></div>
                                <div class="absolute w-1.5 h-1.5 bg-gradient-to-r from-purple-500 to-violet-500 rounded-full animate-ping opacity-60 bottom-4 right-1/3" style="animation-delay: 0.5s;"></div>
                                <div class="absolute w-2 h-2 bg-gradient-to-r from-yellow-400 to-orange-400 rounded-full animate-pulse opacity-50 top-1/2 left-1/6" style="animation-delay: 2.5s;"></div>
                                <div class="absolute w-1 h-1 bg-gradient-to-r from-pink-400 to-rose-400 rounded-full animate-bounce opacity-40 top-1/3 right-1/6" style="animation-delay: 1.8s;"></div>
                            </div>

                            <!-- Main content with enhanced animations -->
                            <div class="relative z-10 text-center">
                                <!-- Enhanced animated icon -->
                                <div class="mb-8">
                                    <div class="w-24 h-24 mx-auto bg-gradient-to-br from-purple-500/30 to-blue-500/30 rounded-full flex items-center justify-center relative group-hover:scale-110 transition-transform duration-500">
                                        <div class="w-16 h-16 bg-gradient-to-br from-purple-400/20 to-blue-400/20 rounded-full flex items-center justify-center animate-pulse">
                                            <svg class="w-10 h-10 text-purple-400 animate-bounce" viewBox="0 0 24 24" fill="currentColor" style="animation-duration: 2s;">
                                                <path d="M12 1L15.09 8.26L22 9L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9L8.91 8.26L12 1Z"/>
                                            </svg>
                                        </div>
                                        <div class="absolute inset-0 rounded-full border-2 border-purple-400/30 animate-spin" style="animation-duration: 4s;"></div>
                                        <div class="absolute inset-2 rounded-full border-2 border-blue-400/20 animate-spin" style="animation-duration: 3s; animation-direction: reverse;"></div>
                                    </div>
                                </div>

                                <!-- Enhanced title with typing effect -->
                                <div class="mb-6">
                                    <h3 class="text-3xl md:text-4xl font-bold text-white mb-3 animate-pulse">
                                        <span class="bg-gradient-to-r from-purple-300 via-pink-300 to-blue-300 bg-clip-text text-transparent">
                                            � <span data-translate="voting.loginRequired" wire:ignore>Login Required!</span>
                                        </span>
                                    </h3>
                                    <div class="w-20 h-1.5 bg-gradient-to-r from-purple-400 via-pink-400 to-blue-400 mx-auto rounded-full animate-pulse"></div>
                                </div>

                                <!-- Enhanced call-to-action message -->
                                <div class="mb-8">
                                    <div class="bg-gradient-to-r from-purple-500/10 to-blue-500/10 rounded-xl p-6 border border-purple-400/20 mb-6">
                                        <h4 class="text-xl font-semibold text-white mb-3 animate-bounce" style="animation-duration: 3s;">
                                            <span class="text-yellow-400">✨</span>
                                            <span data-translate="voting.joinCommunity" wire:ignore>Join Our Gaming Community!</span>
                                            <span class="text-yellow-400">✨</span>
                                        </h4>
                                        <p class="text-lg text-gray-200 leading-relaxed">
                                            <span data-translate="voting.loginMessage" wire:ignore>
                                                Please login to your account to participate in voting and earn amazing rewards!
                                                Your support helps our server grow and brings you exclusive benefits daily.
                                            </span>
                                        </p>
                                    </div>

                                    <!-- Enhanced login button -->
                                    <div class="mb-6">
                                        <a href="/login" class="inline-block px-8 py-4 bg-gradient-to-r from-purple-600 via-pink-600 to-blue-600 text-white font-bold text-lg rounded-full hover:from-purple-500 hover:via-pink-500 hover:to-blue-500 transform hover:scale-105 transition-all duration-300 shadow-lg hover:shadow-purple-500/25 animate-pulse">
                                            <svg class="w-5 h-5 inline mr-2" fill="currentColor" viewBox="0 0 24 24">
                                                <path d="M10 17v-3H3v-4h7V7l5 5-5 5m0-15a2 2 0 0 1 2 2v3h-2V4H5v16h5v-3h2v3a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h5Z"/>
                                            </svg>
                                            <span data-translate="voting.loginNow" wire:ignore>Login Now</span>
                                        </a>
                                    </div>
                                </div>

                                <!-- Enhanced features grid -->
                                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                                    <div class="p-4 rounded-xl bg-gradient-to-br from-yellow-500/10 to-orange-500/10 border border-yellow-500/20 hover:border-yellow-400/40 transition-all duration-300 group">
                                        <div class="w-10 h-10 bg-gradient-to-br from-yellow-500/30 to-orange-500/30 rounded-xl mx-auto mb-3 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                                            <svg class="w-6 h-6 text-yellow-400 animate-pulse" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M12 2C13.1 2 14 2.9 14 4V8C14 9.1 13.1 10 12 10S10 9.1 10 8V4C10 2.9 10.9 2 12 2M18 8V6C18 4.9 17.1 4 16 4S14 4.9 14 6V8C14 9.1 14.9 10 16 10S18 9.1 18 8M10 6V8C10 9.1 9.1 10 8 10S6 9.1 6 8V6C6 4.9 6.9 4 8 4S10 4.9 10 6M22 12C22 17.5 17.5 22 12 22S2 17.5 2 12 6.5 2 12 2 22 6.5 22 12M12 20C16.4 20 20 16.4 20 12S16.4 4 12 4 4 7.6 4 12 7.6 20 12 20Z"/>
                                            </svg>
                                        </div>
                                        <h5 class="text-white font-semibold mb-2" data-translate="voting.earnPoints" wire:ignore>Earn Voting Points</h5>
                                        <p class="text-gray-300 text-sm" data-translate="voting.earnPointsDesc" wire:ignore>Get points for each vote</p>
                                    </div>

                                    <div class="p-4 rounded-xl bg-gradient-to-br from-green-500/10 to-emerald-500/10 border border-green-500/20 hover:border-green-400/40 transition-all duration-300 group">
                                        <div class="w-10 h-10 bg-gradient-to-br from-green-500/30 to-emerald-500/30 rounded-xl mx-auto mb-3 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                                            <svg class="w-6 h-6 text-green-400 animate-pulse" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M12 2C17.5 2 22 6.5 22 12S17.5 22 12 22 2 17.5 2 12 6.5 2 12 2M12 6C9.8 6 8 7.8 8 10S9.8 14 12 14 16 12.2 16 10 14.2 6 12 6M12 16C9.3 16 7 17.3 7 19V20H17V19C17 17.3 14.7 16 12 16Z"/>
                                            </svg>
                                        </div>
                                        <h5 class="text-white font-semibold mb-2" data-translate="voting.dailyRewards" wire:ignore>Daily Rewards</h5>
                                        <p class="text-gray-300 text-sm" data-translate="voting.dailyRewardsDesc" wire:ignore>Claim rewards every day</p>
                                    </div>

                                    <div class="p-4 rounded-xl bg-gradient-to-br from-purple-500/10 to-violet-500/10 border border-purple-500/20 hover:border-purple-400/40 transition-all duration-300 group">
                                        <div class="w-10 h-10 bg-gradient-to-br from-purple-500/30 to-violet-500/30 rounded-xl mx-auto mb-3 flex items-center justify-center group-hover:scale-110 transition-transform duration-300">
                                            <svg class="w-6 h-6 text-purple-400 animate-pulse" viewBox="0 0 24 24" fill="currentColor">
                                                <path d="M12 1L15.09 8.26L22 9L17 14.14L18.18 21.02L12 17.77L5.82 21.02L7 14.14L2 9L8.91 8.26L12 1Z"/>
                                            </svg>
                                        </div>
                                        <h5 class="text-white font-semibold mb-2" data-translate="voting.supportServer" wire:ignore>Support Server</h5>
                                        <p class="text-gray-300 text-sm" data-translate="voting.supportServerDesc" wire:ignore>Help us grow together</p>
                                    </div>
                                </div>

                                <!-- Additional animated elements -->
                                <div class="mt-6 text-center">
                                    <div class="inline-flex items-center text-gray-300 text-sm animate-bounce" style="animation-duration: 4s;">
                                        <span class="w-2 h-2 bg-green-400 rounded-full mr-2 animate-ping"></span>
                                        <span data-translate="voting.onlineNow" wire:ignore>Join thousands of players online now!</span>
                                        <span class="w-2 h-2 bg-green-400 rounded-full ml-2 animate-ping" style="animation-delay: 0.5s;"></span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif
            @endif
            @if (!empty($topPlayers) || !empty($otherPlayers))
                <!-- Event Statistics -->
                <div class="mb-8">
                    <div
                        class="bg-gradient-to-r from-blue-900/30 to-purple-900/30 backdrop-blur-lg border border-blue-500/30 rounded-2xl p-6 shadow-2xl">
                        <h3 class="text-2xl font-bold text-white mb-6 text-center">
                            <i class="fas fa-chart-bar text-blue-400 mr-3"></i>
                            <span data-translate="rankings.eventStatistics" wire:ignore>Event Statistics</span>
                        </h3>
                        <livewire:frontend.event-rankings.event-statistics :selectedEventId="$selectedEventId" />
                    </div>
                </div>
            @endif
            <!-- Rankings Section -->
            <!-- Top 3 Players Podium -->
            <livewire:frontend.event-rankings.top-players-container :selectedEventId="$selectedEventId" />

            <!-- Other Players Table -->
            <livewire:frontend.event-rankings.rankings-table :selectedEventId="$selectedEventId" />
        @endif

        <!-- Optimization Info -->
        <div class="optimization-info">
            <div class="optimization-badge">
                <span class="optimization-text">
                    ⚡ <span data-translate="rankings.optimizedForPerformance" wire:ignore>Optimized for
                        Performance</span>:
                    <span data-translate="rankings.rankingsUpdate" wire:ignore>Rankings</span> <strong>10s</strong> |
                    <span data-translate="rankings.eventsUpdate" wire:ignore>Events</span> <strong>30s</strong> |
                    <span data-translate="rankings.smartUpdate" wire:ignore>Smart Updates</span> 🎯
                </span>
            </div>
        </div>
    </div>

    <!-- Player Modal Component -->
    <livewire:frontend.event-rankings.player-modal />




</div>
