<?php
use Livewire\Volt\Component;
use App\Helpers\FastEventHelper;

new class extends Component {
    public $activeEvents = [];

    public function mount()
    {
        $this->loadActiveEvents();
    }

    public function loadActiveEvents()
    {
        $this->activeEvents = FastEventHelper::getActiveEvents();
    }
};
?>

<div class="container mx-auto px-4 py-8">
    <div class="text-center mb-8">
        <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-4">الأحداث السريعة النشطة</h2>
        <p class="text-gray-600 dark:text-gray-400">شارك في الأحداث واحصل على مكافآت رائعة!</p>
    </div>

    @if(count($activeEvents) > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            @foreach($activeEvents as $event)
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg overflow-hidden">
                    <div class="p-6">
                        @if($event->blade_name)
                            {!! App\Helpers\FastEventHelper::renderEvent($event->blade_name, $event->id) !!}
                        @else
                            <!-- Default event card -->
                            <div class="text-center">
                                <div class="mb-4">
                                    <i class="fas fa-star text-4xl text-yellow-500"></i>
                                </div>
                                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">
                                    {{ $event->event_name }}
                                </h3>
                                @if($event->expired_at)
                                    <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">
                                        ينتهي في: {{ $event->expired_at->diffForHumans() }}
                                    </p>
                                @endif
                                <button class="bg-blue-600 text-white px-4 py-2 rounded-lg hover:bg-blue-700 transition-colors">
                                    شارك الآن
                                </button>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    @else
        <div class="text-center py-12">
            <i class="fas fa-calendar-times text-gray-400 text-6xl mb-4"></i>
            <h3 class="text-xl font-semibold text-gray-600 dark:text-gray-400 mb-2">لا توجد أحداث نشطة حالياً</h3>
            <p class="text-gray-500 dark:text-gray-500">تابعنا للحصول على آخر الأحداث والمسابقات</p>
        </div>
    @endif
</div>
