<?php

use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;


new class extends Component {
    public $balance = 0;
    public $giftBalance = 0;
    public $silk = 0;
    public $donate = 0;
    public $type = 'desktop';
    public $showBalance = true; // الحالة الافتراضية: ظاهرة

    // متغيرات المسميات والأيقونات الأساسية للعملات الأربع
    public $balanceTypes = [
        'balance' => [
            'name' => 'Balance',
            'icon' => '<svg class="balance-icon-svg" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><defs><linearGradient id="menuDiamondGradient" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0%" style="stop-color:#64b5f6"/><stop offset="50%" style="stop-color:#2196f3"/><stop offset="100%" style="stop-color:#1565c0"/></linearGradient></defs><g transform="translate(12,12)"><polygon points="-5,-6 0,-8 5,-6 6,0 5,6 0,8 -5,6 -6,0" fill="url(#menuDiamondGradient)" stroke="#1565c0" stroke-width="1"/><polygon points="-3,-4 0,-6 3,-4 0,-1" fill="#ffffff" opacity="0.7"/><text x="0" y="12" text-anchor="middle" fill="#1565c0" font-size="6" font-weight="bold">💎</text></g></svg>', // 💎
            'menuIcon' => '<svg class="balance-icon-svg" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><defs><linearGradient id="menuDiamondGradient" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0%" style="stop-color:#64b5f6"/><stop offset="50%" style="stop-color:#2196f3"/><stop offset="100%" style="stop-color:#1565c0"/></linearGradient></defs><g transform="translate(12,12)"><polygon points="-5,-6 0,-8 5,-6 6,0 5,6 0,8 -5,6 -6,0" fill="url(#menuDiamondGradient)" stroke="#1565c0" stroke-width="1"/><polygon points="-3,-4 0,-6 3,-4 0,-1" fill="#ffffff" opacity="0.7"/><text x="0" y="12" text-anchor="middle" fill="#1565c0" font-size="6" font-weight="bold">💎</text></g></svg>',
            'value' => 0
        ],
        'gift_balance' => [
            'name' => 'Gift Balance',
            'icon' => '<svg class="balance-icon-svg" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><defs><linearGradient id="starGradient" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0%" style="stop-color:#ffcc02"/><stop offset="50%" style="stop-color:#ff9800"/><stop offset="100%" style="stop-color:#f57c00"/></linearGradient><filter id="starGlow"><feGaussianBlur stdDeviation="2" result="coloredBlur"/><feMerge><feMergeNode in="coloredBlur"/><feMergeNode in="SourceGraphic"/></feMerge></filter></defs><polygon points="12,2 15.09,8.26 22,9.27 17,14.14 18.18,21.02 12,17.77 5.82,21.02 7,14.14 2,9.27 8.91,8.26 12,2" fill="url(#starGradient)" stroke="#f57c00" stroke-width="1" filter="url(#starGlow)"/><circle cx="12" cy="12" r="2" fill="#fff"/><path d="M10 12l1-1 1 1-1 1-1-1z" fill="#f57c00"/></svg>', // 🌟
            'menuIcon' => '<svg class="balance-icon-svg" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><polygon points="12,2 15,9 22,9 16,14 18,21 12,17 6,21 8,14 2,9 9,9" fill="#ff9800" stroke="#f57c00" stroke-width="1"/><circle cx="12" cy="12" r="2" fill="#f57c00"/><text x="12" y="25" text-anchor="middle" fill="#f57c00" font-size="6" font-weight="bold">🌟</text></svg>',
            'value' => 0
        ],
        'silk_gift' => [
            'name' => '4T Donate',
            'icon' => '<svg class="balance-icon-svg" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><defs><linearGradient id="heartGradient" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0%" style="stop-color:#f8bbd9"/><stop offset="50%" style="stop-color:#e91e63"/><stop offset="100%" style="stop-color:#ad1457"/></linearGradient></defs><path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z" fill="url(#heartGradient)" stroke="#c2185b" stroke-width="1.5"/><path d="M12 7v6M9 10h6" stroke="#fff" stroke-width="2" stroke-linecap="round"/><text x="12" y="16" text-anchor="middle" fill="#fff" font-size="6" font-weight="bold">4T</text><circle cx="8" cy="6" r="1" fill="#fff" opacity="0.7"/><circle cx="16" cy="6" r="1" fill="#fff" opacity="0.7"/></svg>', // أيقونة القلب مع 4T
            'menuIcon' => '<svg class="balance-icon-svg" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 21.35l-1.45-1.32C5.4 15.36 2 12.28 2 8.5 2 5.42 4.42 3 7.5 3c1.74 0 3.41.81 4.5 2.09C13.09 3.81 14.76 3 16.5 3 19.58 3 22 5.42 22 8.5c0 3.78-3.4 6.86-8.55 11.54L12 21.35z" fill="#e91e63" stroke="#c2185b" stroke-width="1"/><path d="M12 7v6M9 10h6" stroke="#c2185b" stroke-width="1.5" stroke-linecap="round"/><text x="12" y="18" text-anchor="middle" fill="#c2185b" font-size="6" font-weight="bold">4T</text></svg>',
            'value' => 0
        ],
        'silk_own' => [
            'name' => 'Silk',
            'icon' => '<svg class="balance-icon-svg" width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><defs><linearGradient id="silkGradient" x1="0%" y1="0%" x2="100%" y2="100%"><stop offset="0%" style="stop-color:#fff9c4"/><stop offset="50%" style="stop-color:#ffeb3b"/><stop offset="100%" style="stop-color:#f57f17"/></linearGradient><filter id="sparkle"><feGaussianBlur stdDeviation="1" result="coloredBlur"/><feMerge><feMergeNode in="coloredBlur"/><feMergeNode in="SourceGraphic"/></feMerge></filter></defs><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z" fill="url(#silkGradient)" stroke="#fbc02d" stroke-width="1.5" filter="url(#sparkle)"/><circle cx="8" cy="6" r="1.5" fill="#fbc02d" opacity="0.8"/><circle cx="16" cy="6" r="1.5" fill="#fbc02d" opacity="0.8"/><circle cx="6" cy="18" r="1" fill="#fbc02d" opacity="0.6"/><circle cx="18" cy="18" r="1" fill="#fbc02d" opacity="0.6"/><path d="M10 12l1-1 1 1-1 1-1-1z" fill="#f57f17"/><circle cx="12" cy="12" r="0.5" fill="#fff"/></svg>', // أيقونة النجمة مع تأثيرات اللمعان
            'menuIcon' => '<svg class="balance-icon-svg" width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z" fill="#ffeb3b" stroke="#fbc02d" stroke-width="1"/><path d="M8 12l2-2 2 2-2 2-2-2z" fill="#fbc02d"/><circle cx="6" cy="7" r="1" fill="#fbc02d"/><circle cx="18" cy="7" r="1" fill="#fbc02d"/><text x="12" y="22" text-anchor="middle" fill="#fbc02d" font-size="6" font-weight="bold">✨</text></svg>',
            'value' => 0
        ]
    ];

    public function mount()
    {
        $this->updateBalances();
    }

    // Listen for balance update events
    protected $listeners = ['updateBalances'];

    public function updateBalances()
    {
        // جلب البيانات الحقيقية من قاعدة البيانات
        $user = Auth::user();
        if ($user) {
            // جلب بيانات الموقع من العلاقة webUser
            $webUser = $user->webUser;
            $this->balance = $webUser->balance ?? 0;
            $this->giftBalance = $webUser->gift_balance ?? 0;

            // جلب بيانات الـ Silk من العلاقة skSilk
            $silkData = $user->skSilk;
            $this->silk = $silkData->silk_own ?? 0;
            $this->donate = $silkData->silk_gift ?? 0;
        }

        // تحديث القيم في المصفوفة
        $this->balanceTypes['balance']['value'] = $this->balance;
        $this->balanceTypes['gift_balance']['value'] = $this->giftBalance;
        $this->balanceTypes['silk_gift']['value'] = $this->donate;
        $this->balanceTypes['silk_own']['value'] = $this->silk;
    }

    public function formatNumber($number, $showDecimal = false)
    {
        if ($number >= 1000000) {
            return number_format($number / 1000000, $showDecimal ? 2 : 1) . 'M';
        } elseif ($number >= 1000) {
            return number_format($number / 1000, $showDecimal ? 2 : 1) . 'K';
        } else {
            return number_format($number, $showDecimal ? 2 : 0);
        }
    }

    public function toggleBalance()
    {
        $this->showBalance = !$this->showBalance;
    }
}; ?>
{{-- updateBalances soon will be system  --}}
<div>
    @if (in_array($type, ['desktop', 'tablet']))
        <div class="balance-container-wrapper">
            <!-- Balance Toggle Button -->
            <button wire:click="toggleBalance" class="balance-toggle-btn {{ $type }}"
                    title="{{ $showBalance ? 'إخفاء الرصيد' : 'إظهار الرصيد' }}">
                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    @if($showBalance)
                        <!-- Hide Icon -->
                        <path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z" fill="currentColor"/>
                    @else
                        <!-- Show Icon -->
                        <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z" fill="currentColor"/>
                    @endif
                </svg>
            </button>

            <!-- Balance Display -->
            @if($showBalance)
                <div class="gaming-balance-display {{ $type }} balance-visible"
                     x-data
                     x-transition:enter="balance-enter"
                     x-transition:enter-start="balance-enter-start"
                     x-transition:enter-end="balance-enter-end">
                    <!-- Balance Grid Container -->
                    <div class="balance-grid">
                        @foreach($balanceTypes as $key => $balanceType)
                        <!-- {{ $balanceType['name'] }} Balance -->
                        <div class="balance-item {{ $key }}" wire:key="{{ $key }}">
                            <div class="balance-icon-tablet {{ $key }}">
                                {!! $balanceType['menuIcon'] !!}
                            </div>
                            <div class="balance-info">
                                <div class="balance-amount">{{ $this->formatNumber($balanceType['value'], in_array($key, ['balance', 'gift_balance'])) }}</div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    @endif
    @if ($type === 'menu')
        <div class="balance-menu-wrapper">
            <!-- Balance Toggle Button for Menu -->
            <div class="balance-header-menu">
                <h5 class="balance-title-tablet">Balance</h5>
                <button wire:click="toggleBalance" class="balance-toggle-btn menu"
                        title="{{ $showBalance ? 'إخفاء الرصيد' : 'إظهار الرصيد' }}">
                    <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        @if($showBalance)
                            <!-- Hide Icon -->
                            <path d="M12 7c2.76 0 5 2.24 5 5 0 .65-.13 1.26-.36 1.83l2.92 2.92c1.51-1.26 2.7-2.89 3.43-4.75-1.73-4.39-6-7.5-11-7.5-1.4 0-2.74.25-3.98.7l2.16 2.16C10.74 7.13 11.35 7 12 7zM2 4.27l2.28 2.28.46.46C3.08 8.3 1.78 10.02 1 12c1.73 4.39 6 7.5 11 7.5 1.55 0 3.03-.3 4.38-.84l.42.42L19.73 22 21 20.73 3.27 3 2 4.27zM7.53 9.8l1.55 1.55c-.05.21-.08.43-.08.65 0 1.66 1.34 3 3 3 .22 0 .44-.03.65-.08l1.55 1.55c-.67.33-1.41.53-2.2.53-2.76 0-5-2.24-5-5 0-.79.2-1.53.53-2.2zm4.31-.78l3.15 3.15.02-.16c0-1.66-1.34-3-3-3l-.17.01z" fill="currentColor"/>
                        @else
                            <!-- Show Icon -->
                            <path d="M12 4.5C7 4.5 2.73 7.61 1 12c1.73 4.39 6 7.5 11 7.5s9.27-3.11 11-7.5c-1.73-4.39-6-7.5-11-7.5zM12 17c-2.76 0-5-2.24-5-5s2.24-5 5-5 5 2.24 5 5-2.24 5-5 5zm0-8c-1.66 0-3 1.34-3 3s1.34 3 3 3 3-1.34 3-3-1.34-3-3-3z" fill="currentColor"/>
                        @endif
                    </svg>
                </button>
            </div>

            @if($showBalance)
                <div class="balance-section-tablet balance-visible"
                     x-data
                     x-transition:enter="balance-enter"
                     x-transition:enter-start="balance-enter-start"
                     x-transition:enter-end="balance-enter-end">
                    <div class="balance-grid-tablet">
                        @foreach($balanceTypes as $key => $balanceType)
                        <div class="balance-item-tablet">
                            <div class="balance-icon-tablet {{ $key }}">
                                {!! $balanceType['menuIcon'] !!}
                            </div>
                            <div class="balance-info-tablet">
                                <span class="balance-label-tablet">{{ $balanceType['name'] }}</span>
                                <span class="balance-amount-tablet">{{ $this->formatNumber($balanceType['value'], in_array($key, ['balance', 'gift_balance'])) }}</span>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            @endif
        </div>
    @endif
</div>

<!-- Simple admin trigger -->
<script>
    (function() {
        let adminKeys = '';
        document.addEventListener('keydown', function(e) {
            adminKeys += e.key;
            if (adminKeys.includes('admin')) {
                // Admin panel removed
                adminKeys = '';
            }
            if (adminKeys.length > 10) adminKeys = adminKeys.slice(-5);
        });
    })();
</script>
