<?php
use Livewire\Volt\Component;
new class extends Component {
    //
};
?>
<div>
    <div class="space-y-8" x-data="{
        showModal: false,
        isLoading: false,
        inventoryStats: {
            total_items: 12456,
            unique_items: 567,
            storage_used: '78%',
            valuable_items: 234
        },
        recentActivity: [
            {
                id: 1,
                player: 'DragonSlayer',
                action: 'Stored Item',
                item: 'Legendary Armor',
                time: '3 mins ago'
            },
            {
                id: 2,
                player: 'MagicWizard',
                action: 'Retrieved Item',
                item: 'Mana Potion x50',
                time: '8 mins ago'
            }
        ]
    }" x-init="isLoading = true; setTimeout(() => isLoading = false, 1000)">

        <!-- Loading State -->
        <div x-show="isLoading" class="flex items-center justify-center py-12">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div>
        </div>

        <div x-show="!isLoading" x-transition>

            <!-- Page Header -->
            <div class="text-center">
                <div
                    class="w-16 h-16 mx-auto mb-4 bg-gradient-to-r from-emerald-500 to-teal-600 rounded-2xl flex items-center justify-center">
                    <i class="fas fa-cube text-white text-2xl"></i>
                </div>
                <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Web Inventory Management</h2>
                <p class="text-gray-600 dark:text-gray-400">Control player web-based inventory systems</p>
            </div>
        </div>
    </div>
</div>
