<?php
use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\Z_Website\Quests\TaskUserVipStatus;
use App\Models\Z_Website\Quests\TaskUserProgress;
use App\Models\Z_Website\Quests\TaskUserDailyTask;
use App\Models\Z_Website\Quests\TaskDailyTask;
use App\Models\Z_Website\Quests\TaskRewardChain;
use App\Models\Z_Website\Quests\TasksUserReward;
use App\Models\Z_Website\Quests\TaskReward;
use App\Models\SRO_VT_SHARD\CharQuest;
use App\Models\SRO_VT_PROXY\_InstantCharReloadDelivery;
use Illuminate\Support\Facades\Log;

new class extends Component {
    // Main Info
    public $UserChar = [];
    public $hasChar = false;
    public $availableChars = [];
    // Progress Info
    public $ProgressInfo = [];
    public $currentDay = 0;
    public $totalCompletedDays = 0;
    //Task Info
    public $TaskStatus = 'no_task'; // no_task, in_progress, completed, reward_claimed
    public $UserTask = [];
    public $TaskDetails = [];
    //Main Reward Details
    public $RewardsChain = [];
    public $UserReward = [];
    //Game Quest Details
    public $GameQuests = [];

    /**
     * تحديد شخصية للمستخدم
     */
    public function selectCharacter($charid)
    {
        $user = Auth::user();
        if (!$user) {
            return;
        }

        // Create or update TaskUserVipStatus with selected character
        TaskUserVipStatus::updateOrCreate(['user_id' => $user->JID], ['CharID' => $charid, 'is_vip' => 0]);
        TaskUserProgress::updateOrCreate(['user_id' => $user->JID], ['start_date' => now()]);
        // Reload data to reflect the changes
        $this->loaddata();
    }

    /**
     * تهيئة البيانات عند تحميل الكومبوننت
     */
    public function mount()
    {
        $this->loaddata();
    }

    public function loaddata()
    {
        $user = Auth::user(); // المستخدم الحالي
        //User Char Info
        $this->UserChar = TaskUserVipStatus::usercharid($user->JID);
        $this->availableChars = TaskUserVipStatus::getAvailableChars($user->JID);
        $this->RewardsChain = TaskRewardChain::getAllRewards()->toArray();

        if ($this->UserChar) {
            $this->hasChar = true; // Set to true to indicate a character exists
            $this->ProgressInfo = TaskUserProgress::getUserProgress($user->JID);
            $this->UserReward = TasksUserReward::getUserReward($user->JID)->toArray();
            if ($this->ProgressInfo) {
                $this->currentDay = $this->calculateCurrentDay($this->ProgressInfo->start_date);
                $this->totalCompletedDays = $this->ProgressInfo->getTotalCompletedDays();
                $this->TaskStatus = $this->ProgressInfo->isDayCompleted($this->currentDay) ? 'completed' : 'in_progress';
            } else {
                $this->currentDay = 0;
                $this->totalCompletedDays = 0;
                $this->TaskStatus = 'no_task';
            }

            $this->UserTask = TaskUserDailyTask::usertask($user->JID);
            $this->TaskDetails = $this->UserTask ? $this->UserTask->task : null;

            // Only get GameQuests if we have both TaskDetails and a valid QuestID
            if ($this->TaskDetails && isset($this->TaskDetails->QuestID)) {
                // check cleanOldTasksAndQuests
                 TaskUserDailyTask::cleanOldTasksAndQuests($user->JID, $this->UserTask->task_id);
                // Check if UserTask was created today
                if ($this->UserTask && $this->UserTask->created_at && $this->UserTask->created_at->isToday()) {
                    $gameQuest = CharQuest::getCharQuest($this->UserChar->CharID, $this->TaskDetails->QuestID);
                    // Convert to array to avoid Livewire serialization issues with composite keys
                    $this->GameQuests = $gameQuest ? $gameQuest->toArray() : [];
                } else {
                    // Clean old quests if task is not from today
                    if ($this->UserTask) {
                        $this->cleanOldQuests($this->TaskDetails->QuestID, $this->UserChar->CharID, $this->UserTask->id);
                    }
                    $this->GameQuests = [];
                }
            } else {
                $this->GameQuests = [];
            }
        } else {
            $this->hasChar = false;
            $this->UserChar = [];
            $this->GameQuests = [];
        }
    }

    /**
     * تحديث البيانات
     */
    public function refreshData()
    {
        $this->loaddata();
    }

    /**
     * الحصول على مهمة جديدة لليوم الحالي
     */
    public function getNewTask()
    {
        $user = Auth::user();
        if (!$user || !$this->UserChar) {
            return;
        }

        // Check if user already has a task for today
        $existingTask = TaskUserDailyTask::where('user_id', $user->JID)->whereDate('created_at', today())->first();

        if (!$existingTask) {
            // Get a random task
            $randomTask = TaskDailyTask::inRandomOrder()->first();

            if ($randomTask) {
                TaskUserDailyTask::create([
                    'user_id' => $user->JID,
                    'task_id' => $randomTask->id,
                    'is_completed' => false,
                ]);

                // Insert into CharQuest only if QuestID exists and is valid
                if (isset($randomTask->QuestID) && !empty($randomTask->QuestID)) {
                    try {
                        // Check if quest already exists to avoid duplicate key errors
                        $existingQuest = CharQuest::getCharQuest($this->UserChar->CharID, $randomTask->QuestID);

                        if (!$existingQuest) {
                            CharQuest::create([
                                'CharID' => $this->UserChar->CharID,
                                'QuestID' => $randomTask->QuestID,
                                'Status' => 1,
                                'AchievementCount' => 0,
                                'StartTime' => now(),
                                'EndTime' => now()->addHours(24), // 24 hours task duration
                                'QuestData1' => 0,
                                'QuestData2' => 0,
                            ]);
                            // Trigger instant character reload
                            _InstantCharReloadDelivery::create([
                                'CharID' => $this->UserChar->CharID,
                            ]);
                        }
                    } catch (\Exception $e) {
                        // Log error but don't break the flow
                        Log::warning('Failed to create CharQuest', [
                            'CharID' => $this->UserChar->CharID,
                            'QuestID' => $randomTask->QuestID,
                            'error' => $e->getMessage(),
                        ]);
                    }
                }

                // Reload data to reflect changes
                $this->loaddata();
            }
        }
    }

    /**
     * تحديث حالة المهمة
     */
    public function updateTaskStatus()
    {
        $this->loaddata();
    }

    // by ProgressInfo calculate Current day from start_date style 2025-09-11 back with number of days integer
    public function calculateCurrentDay($startDate)
    {
        if ($startDate) {
            $startDate = \Carbon\Carbon::parse($startDate);
            $currentDate = \Carbon\Carbon::now();
            $daysDifference = $startDate->diffInDays($currentDate) + 1; // +1 to include the start day as day 1
            return (int) $daysDifference;
        }
        return 0; // Return 0 if no start_date provided
    }

    // Clean old quests
    public function cleanOldQuests($QuestID, $CharID, $TaskID)
    {
        $user = Auth::user();
        if (!$user || !$this->UserChar) {
            return;
        }

        try {
            // Delete TaskUserDailyTask entries that are not from today
            $deletedTasks = TaskUserDailyTask::where('user_id', $user->JID)->where('id', $TaskID)->whereDate('created_at', '<', today())->delete();

            // Delete CharQuest entries for old quests
            $deletedQuests = CharQuest::where('CharID', $CharID)->where('QuestID', $QuestID)->delete();
            // Trigger instant character reload
            _InstantCharReloadDelivery::create([
                'CharID' => $CharID,
            ]);

            Log::info('Cleaned old quests', [
                'user_id' => $user->JID,
                'CharID' => $CharID,
                'QuestID' => $QuestID,
                'TaskID' => $TaskID,
                'deletedTasks' => $deletedTasks,
                'deletedQuests' => $deletedQuests,
            ]);
        } catch (\Exception $e) {
            Log::error('Error cleaning old quests', [
                'user_id' => $user->JID,
                'CharID' => $CharID,
                'QuestID' => $QuestID,
                'TaskID' => $TaskID,
                'error' => $e->getMessage(),
            ]);
        }

        $this->loaddata();
    }

    // Complete Quest Day function
    public function completeTask()
    {
        $user = Auth::user();
        if (!$user || !$this->UserChar || !$this->UserTask) {
            Log::warning('CompleteTask failed: Missing required data', [
                'user' => !!$user,
                'UserChar' => !!$this->UserChar,
                'UserTask' => !!$this->UserTask,
            ]);
            return;
        }

        // Get QuestID and CharID from current data
        $questID = $this->TaskDetails->QuestID ?? null;
        $charID = $this->UserChar->CharID ?? null;

        if (!$questID || !$charID) {
            Log::warning('CompleteTask failed: Missing QuestID or CharID', [
                'questID' => $questID,
                'charID' => $charID,
            ]);
            return;
        }

        try {
            // Step 1: Mark task as completed first (before cleaning)
            if (!$this->UserTask) {
                Log::error('UserTask is null, cannot update task status', [
                    'user_id' => $user->JID,
                    'CharID' => $charID,
                    'QuestID' => $questID,
                ]);
                return;
            }

            $this->UserTask->update(['is_completed' => true]);

            // Step 2: Update TaskUserProgress to mark current day as completed
            if ($this->ProgressInfo && $this->currentDay > 0) {
                $this->ProgressInfo->markDayCompleted($this->currentDay);
                Log::info('Day marked as completed', [
                    'user_id' => $user->JID,
                    'current_day' => $this->currentDay,
                    'day_field' => 'day_' . $this->currentDay,
                    'questID' => $questID,
                    'charID' => $charID,
                ]);
            }

            // Step 3: Clean old quests (this deletes the task)
            if ($questID && $charID) {
                $this->cleandayquest($questID, $charID, $this->UserTask->id);
            }

            Log::info('Quest day completed successfully', [
                'user_id' => $user->JID,
                'CharID' => $charID,
                'QuestID' => $questID,
                'current_day' => $this->currentDay,
                'task_id' => $this->UserTask->id ?? 'deleted',
            ]);

            // Step 4: Reload data to reflect changes
            $this->loaddata();
        } catch (\Exception $e) {
            Log::error('Error completing quest day', [
                'user_id' => $user->JID,
                'CharID' => $charID,
                'QuestID' => $questID,
                'current_day' => $this->currentDay,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);
        }
    }

    // Clean day Quest
    public function cleandayquest($QuestID, $CharID, $TaskID)
    {
        $user = Auth::user();
        if (!$user || !$this->UserChar) {
            return;
        }

        try {
            // Delete TaskUserDailyTask entries that are not from today
            $deletedTasks = TaskUserDailyTask::where('user_id', $user->JID)->where('id', $TaskID)->delete();

            // Delete CharQuest entries for old quests
            $deletedQuests = CharQuest::where('CharID', $CharID)->where('QuestID', $QuestID)->delete();
            // Trigger instant character reload
            _InstantCharReloadDelivery::create([
                'CharID' => $CharID,
            ]);

            Log::info('Cleaned old quests', [
                'user_id' => $user->JID,
                'CharID' => $CharID,
                'QuestID' => $QuestID,
                'TaskID' => $TaskID,
                'deletedTasks' => $deletedTasks,
                'deletedQuests' => $deletedQuests,
            ]);
        } catch (\Exception $e) {
            Log::error('Error cleaning old quests', [
                'user_id' => $user->JID,
                'CharID' => $CharID,
                'QuestID' => $QuestID,
                'TaskID' => $TaskID,
                'error' => $e->getMessage(),
            ]);
        }

        $this->loaddata();
    }

    /**
     * ترقية المستخدم إلى VIP
     */
    public function upgradeToVip()
    {
        $user = Auth::user();
        if (!$user || !$this->UserChar) {
            Log::warning('VIP upgrade failed: Missing user or character', [
                'user' => !!$user,
                'UserChar' => !!$this->UserChar,
            ]);
            return;
        }

        // Check if user has enough balance
        if ($user->webUser->balance < 500) {
            Log::warning('VIP upgrade failed: Insufficient balance', [
                'user_id' => $user->JID,
                'current_balance' => $user->webUser->balance,
                'required_balance' => 500,
            ]);
            return;
        }

        try {
            // Deduct balance
            $user->webUser->decrement('balance', 500);

            // Update VIP status in TaskUserVipStatus
            TaskUserVipStatus::where('user_id', $user->JID)->update(['is_vip' => 1]);

            Log::info('VIP upgrade successful', [
                'user_id' => $user->JID,
                'CharID' => $this->UserChar->CharID,
                'new_balance' => $user->webUser->balance,
                'upgraded_at' => now(),
            ]);

            // Reload data to reflect changes
            $this->loaddata();

            // Update header balance by dispatching event to balance-head component
            $this->dispatch('updateBalances');
        } catch (\Exception $e) {
            Log::error('VIP upgrade error', [
                'user_id' => $user->JID,
                'CharID' => $this->UserChar->CharID ?? null,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            throw $e;
        }
    }

    /**
     * استلام مكافأة عادية
     */
    public function claimNormalReward($rewardChainId)
    {
        $user = Auth::user();
        if (!$user || !$this->UserChar) {
            Log::warning('Claim Normal Reward failed: Missing user or character');
            throw new \Exception('Missing user or character data');
        }

        try {
            $rewardChain = TaskRewardChain::find($rewardChainId);
            if (!$rewardChain) {
                Log::warning('Reward chain not found', ['id' => $rewardChainId]);
                throw new \Exception('Reward chain not found');
            }

            // Check if user has completed required days
            if ($this->totalCompletedDays < $rewardChain->days_required) {
                Log::warning('User has not completed required days', [
                    'completed_days' => $this->totalCompletedDays,
                    'required_days' => $rewardChain->days_required,
                ]);
                throw new \Exception('لم تكمل العدد المطلوب من الأيام بعد');
            }

            // Check if normal_reward exists
            if (!$rewardChain->normal_reward) {
                Log::error('Normal reward ID is null or empty', [
                    'reward_chain_id' => $rewardChainId,
                    'normal_reward' => $rewardChain->normal_reward
                ]);
                throw new \Exception('لا توجد مكافأة عادية لهذا اليوم');
            }

            // Check if reward already claimed
            $existingReward = TasksUserReward::where('user_id', $user->JID)->where('reward_id', $rewardChain->normal_reward)->where('reward_type', 'Normal')->first();

            if ($existingReward && $existingReward->is_claimed) {
                Log::warning('Normal reward already claimed', [
                    'user_id' => $user->JID,
                    'reward_id' => $rewardChain->normal_reward,
                ]);
                throw new \Exception('لقد استلمت هذه المكافأة من قبل');
            }



            // Create or update reward record
            TasksUserReward::updateOrCreate(
                [
                    'user_id' => $user->JID,
                    'reward_id' => $rewardChain->normal_reward,
                    'reward_type' => 'Normal',
                ],
                [
                    'is_claimed' => 1,
                ],
            );
            //Task Send Reward
            TaskReward::sendReward($rewardChain->normal_reward);


            $this->dispatch('updateBalances');

            Log::info('Normal reward claimed successfully', [
                'user_id' => $user->JID,
                'reward_id' => $rewardChain->normal_reward,
                'reward_chain_id' => $rewardChainId,
            ]);

            // Reload data
            $this->loaddata();

            // Return success
            return true;
        } catch (\Exception $e) {
            Log::error('Error claiming normal reward', [
                'user_id' => $user->JID ?? 'N/A',
                'reward_chain_id' => $rewardChainId,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            // Re-throw the exception so JavaScript can catch it
            throw $e;
        }
    }

    /**
     * استلام مكافأة VIP
     */
    public function claimVipReward($rewardChainId)
    {
      $user = Auth::user();
        if (!$user || !$this->UserChar) {
            Log::warning('Claim VIP Reward failed: Missing user or character');
            throw new \Exception('Missing user or character data');
        }
        //check user if VIP
        $Checkvip = TaskUserVipStatus::where('user_id', $user->JID)->first();
        if (!$Checkvip || !$Checkvip->is_vip) {
            Log::warning('User is not VIP', ['user_id' => $user->JID]);
            throw new \Exception('يجب أن تكون عضو VIP لاستلام هذه المكافأة');
        }

        try {
            $rewardChain = TaskRewardChain::find($rewardChainId);
            if (!$rewardChain) {
                Log::warning('Reward chain not found', ['id' => $rewardChainId]);
                throw new \Exception('Reward chain not found');
            }

            // Check if user has completed required days
            if ($this->totalCompletedDays < $rewardChain->days_required) {
                Log::warning('User has not completed required days', [
                    'completed_days' => $this->totalCompletedDays,
                    'required_days' => $rewardChain->days_required,
                ]);
                throw new \Exception('لم تكمل العدد المطلوب من الأيام بعد');
            }

            // Check if vip_reward exists
            if (!$rewardChain->vip_reward) {
                Log::error('VIP reward ID is null or empty', [
                    'reward_chain_id' => $rewardChainId,
                    'vip_reward' => $rewardChain->vip_reward
                ]);
                throw new \Exception('لا توجد مكافأة عادية لهذا اليوم');
            }

            // Check if reward already claimed
            $existingReward = TasksUserReward::where('user_id', $user->JID)->where('reward_id', $rewardChain->vip_reward)->where('reward_type', 'VIP')->first();

            if ($existingReward && $existingReward->is_claimed) {
                Log::warning('VIP reward already claimed', [
                    'user_id' => $user->JID,
                    'reward_id' => $rewardChain->vip_reward,
                ]);
                throw new \Exception('لقد استلمت هذه المكافأة من قبل');
            }

            // Create or update reward record
            TasksUserReward::updateOrCreate(
                [
                    'user_id' => $user->JID,
                    'reward_id' => $rewardChain->vip_reward,
                    'reward_type' => 'VIP',
                ],
                [
                    'is_claimed' => 1,
                ],
            );

            //Task Send VIP Reward
            TaskReward::sendReward($rewardChain->vip_reward);

            $this->dispatch('updateBalances');

            Log::info('VIP reward claimed successfully', [
                'user_id' => $user->JID,
                'reward_id' => $rewardChain->vip_reward,
                'reward_chain_id' => $rewardChainId,
            ]);

            // Reload data
            $this->loaddata();

            // Return success
            return true;
        } catch (\Exception $e) {
            Log::error('Error claiming VIP reward', [
                'user_id' => $user->JID ?? 'N/A',
                'reward_chain_id' => $rewardChainId,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString(),
            ]);

            // Re-throw the exception so JavaScript can catch it
            throw $e;
        }
    }

    /**
     * إعادة تشغيل الرحلة - بدء رحلة جديدة
     */
    public function restartJourney()
    {
        $user = Auth::user();
        if (!$user) {
            Log::warning('RestartJourney failed: No authenticated user');
            throw new \Exception('المستخدم غير مصادق عليه');
        }

        try {
            // Reset user progress - create new start date
            $progressRecord = TaskUserProgress::where('user_id', $user->JID)->first();
            if ($progressRecord) {
                // Reset all day completion fields
                for ($day = 1; $day <= 31; $day++) {
                    $progressRecord->{"day_$day"} = 0;
                }
                // Set new start date
                $progressRecord->start_date = now();
                $progressRecord->save();
            } else {
                // Create new progress record
                TaskUserProgress::create([
                    'user_id' => $user->JID,
                    'start_date' => now()
                ]);
            }

            // Clear any existing daily tasks
            TaskUserDailyTask::where('user_id', $user->JID)->delete();

            // Clear character quests if user has character
            if ($this->UserChar && $this->UserChar->CharID) {
                CharQuest::where('CharID', $this->UserChar->CharID)->delete();

                // Trigger character reload
                _InstantCharReloadDelivery::create([
                    'CharID' => $this->UserChar->CharID,
                ]);
            }

            //Reset Vip status
            TaskUserVipStatus::where('user_id', $user->JID)->update(['is_vip' => 0]);

            //delete Rewards for user
            TasksUserReward::where('user_id', $user->JID)->delete();

            // Reset claimed rewards (optional - comment out if you want to keep previous rewards)
            // TasksUserReward::where('user_id', $user->JID)->delete();

            Log::info('Journey restarted successfully', [
                'user_id' => $user->JID,
                'new_start_date' => now()->toDateTimeString(),
                'character_id' => $this->UserChar->CharID ?? 'none'
            ]);

            // Reload all data to reflect changes
            $this->loaddata();

            return true;

        } catch (\Exception $e) {
            Log::error('Error restarting journey', [
                'user_id' => $user->JID,
                'error' => $e->getMessage(),
                'trace' => $e->getTraceAsString()
            ]);

            throw new \Exception('حدث خطأ أثناء إعادة تشغيل الرحلة: ' . $e->getMessage());
        }
    }

};
?>
<div>




    <div class="quest-container" x-data="{
        CurrentNewPage: 'welcome',
        showGetQuestModal: false,
        showVipModal: false,
        showInsufficientBalanceModal: false,
        selectedCharacter: null,
        isCompleting: false,
        isCompleted: false,
        isUpgrading: false,
        currentBalance: {{ Auth::user()->webUser->balance ?? 0 }},
        vipCost: 500,

        selectCharacter(characterId) {
            this.selectedCharacter = characterId;
        },

        confirmSelection() {
            if (this.selectedCharacter) {
                $wire.call('selectCharacter', this.selectedCharacter);
                this.CurrentNewPage = 'welcome';
                this.selectedCharacter = null;
            }
        },

        showCharacterSelection() {
            this.CurrentNewPage = 'selectChar';
        },

        backToWelcome() {
            this.CurrentNewPage = 'welcome';
            this.selectedCharacter = null;
        },

        openGetQuestModal() {
            this.showGetQuestModal = true;
        },

        closeGetQuestModal() {
            this.showGetQuestModal = false;
        },

        getNewQuest() {
            $wire.call('getNewTask');
            this.closeGetQuestModal();
        },

        async completeTask() {
            this.isCompleting = true;

            try {
                // Get QuestID and CharID from current task data if available
                const questId = {{ $TaskDetails->QuestID ?? 'null' }};
                const charId = {{ $UserChar->CharID ?? 'null' }};

                // Call the backend function with the IDs for better logging
                await $wire.call('completeTask');
                this.isCompleted = true;

                // Reset states after animation
                setTimeout(() => {
                    this.isCompleting = false;
                    this.isCompleted = false;
                }, 2000);

            } catch (error) {
                console.error('Error completing task:', error);
                this.isCompleting = false;
            }
        },

        openVipModal() {
            this.showVipModal = true;
        },

        closeVipModal() {
            this.showVipModal = false;
        },

        checkBalance() {
            return this.currentBalance >= this.vipCost;
        },

        async upgradeToVip() {
            if (!this.checkBalance()) {
                this.showVipModal = false;
                this.showInsufficientBalanceModal = true;
                return;
            }

            this.isUpgrading = true;

            try {
                // Call backend VIP upgrade function
                await $wire.call('upgradeToVip');

                // Show success animation
                this.showSuccessAnimation();

                // Update balance immediately in UI
                this.currentBalance -= this.vipCost;

                // Dispatch event to update header balance
                window.Livewire.dispatch('updateBalances');

                // Close modal after success
                setTimeout(() => {
                    this.showVipModal = false;
                    this.isUpgrading = false;
                }, 2000);

            } catch (error) {
                console.error('VIP upgrade error:', error);
                this.isUpgrading = false;
                // Show error message
            }
        },

        showSuccessAnimation() {
            // Add success animation logic here if needed
            console.log('VIP upgrade successful!');
        },

        closeInsufficientBalanceModal() {
            this.showInsufficientBalanceModal = false;
        }
    }">

@if ($hasChar && $ProgressInfo)
    @php
        $startDate = \Carbon\Carbon::parse($ProgressInfo->start_date);
        $endDate = $startDate->copy()->addDays(31);
    @endphp
@endif
        @if (!$hasChar)
            <!-- Welcome/Character Selection State Pages -->
            <div class="w-full max-w-4xl mx-auto">
                <!-- Welcome Card -->
                <div x-show="CurrentNewPage === 'welcome'"
                     x-transition:enter="transition duration-500 ease-out"
                     x-transition:enter-start="opacity-0 transform scale-95"
                     x-transition:enter-end="opacity-100 transform scale-100"
                     x-transition:leave="transition duration-300 ease-in"
                     x-transition:leave-start="opacity-100 transform scale-100"
                     x-transition:leave-end="opacity-0 transform scale-95"
                     class="bg-gradient-to-br from-purple-900 via-gray-900 to-purple-700 rounded-2xl shadow-2xl p-8 text-center border-4 border-purple-400">

                    <div class="text-6xl md:text-7xl mb-6 animate-bounce">🏆</div>

                    <h1 class="text-3xl md:text-4xl font-extrabold text-purple-300 mb-4"
                        wire:ignore  data-translate="page.quests.no_character_title">
                        Welcome to the Quest System!
                    </h1>

                    <p class="text-lg md:text-xl text-gray-200 mb-8 leading-relaxed max-w-2xl mx-auto"
                       wire:ignore  data-translate="page.quests.no_character_description">
                        Embark on an epic adventure and earn amazing rewards every day!
                        Complete quests, claim rewards, and become the ultimate champion.
                        Your journey to greatness starts here!
                    </p>

                    <button class="w-full md:w-auto bg-gradient-to-r from-green-400 to-purple-500 text-white font-bold text-lg py-4 px-8 rounded-xl shadow-lg hover:scale-105 transition flex items-center justify-center gap-3 mx-auto"
                            x-on:click="showCharacterSelection()">
                        <span class="text-2xl">🎮</span>
                        <span wire:ignore  data-translate="page.quests.epic_rewards_await">Choose Your Character & Start Adventure!</span>
                    </button>
                </div>

                <!-- Character Selection Page -->
                <div x-show="CurrentNewPage === 'selectChar'"
                     x-transition:enter="transition duration-500 ease-out"
                     x-transition:enter-start="opacity-0 transform translate-x-4"
                     x-transition:enter-end="opacity-100 transform translate-x-0"
                     x-transition:leave="transition duration-300 ease-in"
                     x-transition:leave-start="opacity-100 transform translate-x-0"
                     x-transition:leave-end="opacity-0 transform translate-x-4"
                     class="bg-gradient-to-br from-blue-900 via-gray-900 to-blue-700 rounded-2xl shadow-2xl p-8 border-4 border-blue-400">

                    <!-- Header -->
                    <div class="text-center mb-8">
                        <button x-on:click="backToWelcome()"
                                class="absolute top-4 left-4 bg-gray-700 hover:bg-gray-600 text-white rounded-full w-10 h-10 flex items-center justify-center transition">
                            ←
                        </button>

                        <div class="text-5xl mb-4">⚔️</div>
                        <h2 class="text-3xl font-extrabold text-blue-300 mb-2" wire:ignore data-translate="page.quests.character_selection.title">Choose Your Character</h2>
                        <p class="text-lg text-gray-300" wire:ignore data-translate="page.quests.character_selection.description">Select the character you want to use for quests</p>
                    </div>

                    <!-- Characters Grid -->
                    <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-4 mb-8">
                        @if ($availableChars && count($availableChars) > 0)
                            @foreach ($availableChars as $character)
                                <div class="character-card bg-gray-800 rounded-xl p-4 border-2 cursor-pointer transition-all duration-300 hover:scale-105"
                                     x-on:click="selectCharacter('{{ $character->CharID }}')"
                                     x-bind:class="selectedCharacter === '{{ $character->CharID }}' ? 'border-blue-400 bg-blue-900' : 'border-gray-600 hover:border-blue-500'">

                                    <div class="character-avatar text-center mb-3">
                                        @php
                                            $avatarUrl = Char::getCharAvatarGifByCharname($character->CharName16);
                                        @endphp
                                        @if ($avatarUrl)
                                            <img src="{{ $avatarUrl }}" alt="{{ $character->CharName16 }}"
                                                 class="w-16 h-16 mx-auto rounded-lg object-cover border-2 border-gray-600">
                                        @else
                                            <div class="w-16 h-16 mx-auto bg-gray-700 rounded-lg flex items-center justify-center text-3xl">👤</div>
                                        @endif
                                    </div>

                                    <div class="text-center">
                                        <div class="font-bold text-white mb-1">{{ $character->CharName16 }}</div>
                                        <div class="text-sm text-gray-400">Level {{ $character->CurLevel ?? 'Unknown' }}</div>
                                    </div>
                                </div>
                            @endforeach
                        @else
                            <div class="col-span-full text-center py-12 bg-gray-800 rounded-xl">
                                <div class="text-4xl mb-4">😔</div>
                                <h3 class="text-xl font-bold text-gray-300 mb-2" wire:ignore data-translate="page.quests.character_selection.no_characters">No Characters Available</h3>
                                <p class="text-gray-400">Please create a character in the game first, then come back to start your quest journey!</p>
                            </div>
                        @endif
                    </div>

                    <!-- Actions -->
                    <div class="flex flex-col sm:flex-row gap-4 justify-center">
                        <button class="bg-gradient-to-r from-green-400 to-blue-500 text-white font-bold py-3 px-6 rounded-xl shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                x-bind:disabled="!selectedCharacter"
                                x-bind:class="{ 'opacity-50 cursor-not-allowed': !selectedCharacter }"
                                x-on:click="confirmSelection()">
                            <span>✅</span>
                            <span wire:ignore data-translate="common.confirm">Confirm Selection</span>
                        </button>

                        <button class="bg-gradient-to-r from-gray-600 to-gray-700 text-white font-bold py-3 px-6 rounded-xl shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                x-on:click="backToWelcome()">
                            <span>❌</span>
                            <span wire:ignore data-translate="common.cancel">Cancel</span>
                        </button>
                    </div>
                </div>
            </div>
            {{-- عايزين نقول لو الوقت الخاص بالانتهاء عدي علي وقتنا الحاضر --}}
        @elseIF ($endDate < now())
            <!-- Journey Complete Celebration -->
            <div class="journey-complete-container"
                 x-data="{
                    showFireworks: true,
                    showCelebration: true,
                    celebrationPhase: 'welcome', // welcome, achievements, celebration, new_journey
                    totalRewardsClaimed: {{ $UserReward ? count(array_filter($UserReward, function($reward) { return $reward['is_claimed']; })) : 0 }},
                    totalDaysCompleted: {{ $totalCompletedDays ?? 0 }},
                    isVipUser: {{ $UserChar && $UserChar->isVip ? 'true' : 'false' }},

                    init() {
                        this.startCelebrationSequence();
                        this.createFireworks();
                        setTimeout(() => this.celebrationPhase = 'achievements', 2000);
                        setTimeout(() => this.celebrationPhase = 'celebration', 5000);
                        setTimeout(() => this.celebrationPhase = 'new_journey', 8000);
                    },

                    createFireworks() {
                        for (let i = 0; i < 20; i++) {
                            setTimeout(() => {
                                this.addFirework();
                            }, i * 200);
                        }
                    },

                    addFirework() {
                        const container = document.querySelector('.fireworks-container');
                        if (!container) return;

                        const firework = document.createElement('div');
                        firework.className = 'firework firework-' + (Math.floor(Math.random() * 4) + 1);
                        firework.style.top = Math.random() * 80 + '%';
                        firework.style.left = Math.random() * 80 + '%';
                        container.appendChild(firework);

                        setTimeout(() => firework.remove(), 2000);
                    },

                    addConfetti() {
                        const container = document.querySelector('.fireworks-container');
                        if (!container) return;

                        for (let i = 0; i < 10; i++) {
                            const confetti = document.createElement('div');
                            confetti.className = 'confetti';
                            confetti.style.left = Math.random() * 100 + '%';
                            confetti.style.animationDelay = Math.random() * 2 + 's';
                            container.appendChild(confetti);

                            setTimeout(() => confetti.remove(), 3000);
                        }
                    },

                    startCelebrationSequence() {
                        setTimeout(() => this.addConfetti(), 1000);
                        setTimeout(() => this.addConfetti(), 3000);
                        setTimeout(() => this.addConfetti(), 5000);
                    },

                    restartJourney() {
                        // إعادة تعيين الرحلة
                        $wire.call('restartJourney').then(() => {
                            location.reload();
                        });
                    },

                    goToDashboard() {
                        window.location.href = '/dashboard';
                    }
                 }"
                 x-transition:enter="transition duration-1000 ease-out"
                 x-transition:enter-start="opacity-0 transform scale-50"
                 x-transition:enter-end="opacity-100 transform scale-100">

                <!-- Fireworks Background -->
                <div class="fireworks-container" x-show="showFireworks"></div>

                <!-- Welcome Phase -->
                <div x-show="celebrationPhase === 'welcome'"
                     x-transition:enter="transition duration-1000 ease-out"
                     x-transition:enter-start="opacity-0 transform translateY(50px)"
                     x-transition:enter-end="opacity-100 transform translateY(0)">

                    <h1 class="celebration-title" wire:ignore  data-translate="page.quests.journey_complete.title">
                        🎊 Journey Complete! 🎊
                    </h1>

                    <h2 class="celebration-subtitle" wire:ignore  data-translate="page.quests.journey_complete.subtitle">
                        Epic Quest Adventure Finished!
                    </h2>

                    <p class="celebration-message" wire:ignore  data-translate="page.quests.journey_complete.welcome_message">
                        Congratulations, legendary hero! You have successfully completed your 31-day quest journey.
                        Your dedication, courage, and perseverance have led you to this incredible achievement!
                    </p>
                </div>

                <!-- Achievements Phase -->
                <div x-show="celebrationPhase === 'achievements'"
                     x-transition:enter="transition duration-800 ease-out"
                     x-transition:enter-start="opacity-0 transform scale-90"
                     x-transition:enter-end="opacity-100 transform scale-100">

                    <h2 class="celebration-subtitle" wire:ignore  data-translate="page.quests.journey_complete.achievements.title">
                        🏆 Your Epic Achievements 🏆
                    </h2>

                    <div class="achievements-grid">
                        <div class="achievement-card">
                            <div class="achievement-icon">📅</div>
                            <span class="achievement-number" x-text="totalDaysCompleted">{{ $totalCompletedDays ?? 0 }}</span>
                            <span class="achievement-label" wire:ignore  data-translate="page.quests.journey_complete.achievements.days_completed">
                                Days Completed
                            </span>
                        </div>

                        <div class="achievement-card">
                            <div class="achievement-icon">🎁</div>
                            <span class="achievement-number" x-text="totalRewardsClaimed">{{ $UserReward ? count(array_filter($UserReward, function($reward) { return $reward['is_claimed']; })) : 0 }}</span>
                            <span class="achievement-label" wire:ignore  data-translate="page.quests.journey_complete.achievements.rewards_claimed">
                                Rewards Claimed
                            </span>
                        </div>

                        <div class="achievement-card">
                            <div class="achievement-icon" x-text="isVipUser ? '👑' : '⭐'"></div>
                            <span class="achievement-number">{{ $UserChar && $UserChar->isVip ? '👑' : '1' }}</span>
                            <span class="achievement-label" x-text="isVipUser ? 'VIP Champion' : 'Hero Status'"
                                  wire:ignore  data-translate="{{ $UserChar && $UserChar->isVip ? 'page.quests.journey_complete.achievements.vip_champion' : 'page.quests.journey_complete.achievements.hero_status' }}">
                                {{ $UserChar && $UserChar->isVip ? 'VIP Champion' : 'Hero Status' }}
                            </span>
                        </div>
                    </div>
                </div>

                <!-- Celebration Phase -->
                <div x-show="celebrationPhase === 'celebration'"
                     x-transition:enter="transition duration-1000 ease-out"
                     x-transition:enter-start="opacity-0 transform rotateY(180deg)"
                     x-transition:enter-end="opacity-100 transform rotateY(0deg)">

                    <div class="legendary-message" wire:ignore  data-translate="page.quests.journey_complete.celebration.legendary_message">
                        🌟 You are now a LEGENDARY QUEST MASTER! 🌟<br>
                        Your name will be remembered in the halls of heroes!
                    </div>

                    <p class="celebration-message" wire:ignore  data-translate="page.quests.journey_complete.celebration.final_message">
                        Through 31 days of challenges, battles, and victories, you have proven yourself worthy of greatness.
                        Your journey may be complete, but your legend lives on forever!
                    </p>

                    <!-- Fireworks Text -->
                    <div class="text-center my-6">
                        <span class="text-6xl animate-pulse">🎆🎇✨🎊🎉✨🎇🎆</span>
                    </div>
                </div>

                <!-- New Journey Phase -->
                <div x-show="celebrationPhase === 'new_journey'"
                     x-transition:enter="transition duration-800 ease-out"
                     x-transition:enter-start="opacity-0 transform translateY(-50px)"
                     x-transition:enter-end="opacity-100 transform translateY(0)">

                    <div class="new-journey-section">
                        <h3 class="new-journey-title" wire:ignore  data-translate="page.quests.journey_complete.new_journey.title">
                            🚀 Ready for Another Adventure? 🚀
                        </h3>

                        <p class="new-journey-description" wire:ignore  data-translate="page.quests.journey_complete.new_journey.description">
                            The world needs heroes like you! Start a new 31-day quest journey and continue your path to becoming
                            the ultimate champion. New challenges, new rewards, and new legends await!
                        </p>

                        <div class="journey-action-buttons">
                            <button class="journey-btn journey-btn-primary"
                                    x-on:click="restartJourney()"
                                    wire:ignore  data-translate="page.quests.journey_complete.new_journey.start_new">
                                🌟 Start New Journey 🌟
                            </button>

                            <button class="journey-btn journey-btn-secondary"
                                    x-on:click="goToDashboard()"
                                    wire:ignore  data-translate="page.quests.journey_complete.new_journey.back_to_dashboard">
                                🏠 Back to Dashboard
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        @else
            <div class="quest-dashboard">
                <div class="quest-header">
                    <h1 class="quest-title">Quest Progress for {{ $UserChar->CharName16 }}</h1>

                    <!-- Quest Main Info Container -->
                    @if ($ProgressInfo && $ProgressInfo->start_date)
                        <div class="quest-main-container">
                            <!-- Left Side: Duration, Progress Bar, Stats -->
                            <div class="quest-left-section">
                                <!-- Quest Progress Bar with Duration -->
                                @php
                                    $currentDate = \Carbon\Carbon::now();
                                    $totalDays = $startDate->diffInDays($endDate);
                                    $daysPassed = $startDate->diffInDays($currentDate);
                                    $progressPercentage = min(100, max(0, ($daysPassed / $totalDays) * 100));
                                    $daysRemaining = max(0, $endDate->diffInDays($currentDate));
                                @endphp

                                <div class="quest-progress-bar">
                                    <!-- Duration Info Header -->
                                    <div class="quest-duration">
                                        <div class="duration-card">
                                            <div class="duration-icon">🚀</div>
                                            <div class="duration-info">
                                                <span class="duration-label" wire:ignore data-translate="page.quests.status.started">Quest Started</span>
                                                <span class="duration-value">{{ $startDate->format('M d, Y') }}</span>
                                            </div>
                                        </div>

                                        <div class="duration-separator">
                                            <div class="separator-line"></div>
                                            <div class="separator-icon">⏱️</div>
                                            <div class="separator-line"></div>
                                        </div>

                                        <div class="duration-card">
                                            <div class="duration-icon">🏆</div>
                                            <div class="duration-info">
                                                <span class="duration-label">Quest Ends</span>
                                                <span class="duration-value">{{ $endDate->format('M d, Y') }}</span>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Progress Info -->
                                    <div class="progress-header">
                                        <div class="progress-info">
                                            <span class="progress-label">Quest Timeline Progress</span>
                                            <span
                                                class="progress-percentage">{{ round($progressPercentage, 1) }}%</span>
                                        </div>
                                        <div class="days-remaining">
                                            @if ($daysRemaining > 0)
                                                <span class="remaining-text">{{ $daysRemaining }} days remaining</span>
                                            @else
                                                <span class="remaining-text completed">Quest Completed!</span>
                                            @endif
                                        </div>
                                    </div>

                                    <!-- Progress Bar -->
                                    <div class="progress-track">
                                        <div class="progress-fill" style="width: {{ $progressPercentage }}%">
                                            <div class="progress-glow"></div>
                                        </div>
                                        <div class="progress-marker" style="left: {{ $progressPercentage }}%">
                                            <div class="marker-dot"></div>
                                            <div class="marker-label">Today</div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Quest Stats -->
                                <div class="quest-stats">
                                    <div class="stat-card">
                                        <div class="stat-icon">📊</div>
                                        <div class="stat-info">
                                            <span class="stat-label">Current Day</span>
                                            <span class="stat-value">{{ $currentDay }}/31</span>
                                        </div>
                                    </div>
                                    <div class="stat-card">
                                        <div class="stat-icon">✅</div>
                                        <div class="stat-info">
                                            <span class="stat-label">Completed Days</span>
                                            <span class="stat-value">{{ $totalCompletedDays }}</span>
                                        </div>
                                    </div>
                                    <div class="stat-card">
                                        <div class="stat-icon">🔥</div>
                                        <div class="stat-info">
                                            <span class="stat-label">Progress</span>
                                            <span
                                                class="stat-value">{{ $ProgressInfo ? round(($totalCompletedDays / 31) * 100, 1) : 0 }}%</span>
                                        </div>
                                    </div>
                                    {{-- Check User VIP and add VIP Button --}}
                                    @if ($UserChar && !$UserChar->isVip)
                                        <div class="stat-card vip-upgrade" x-on:click="showVipModal = true">
                                            <div class="vip-upgrade-content">
                                                <div class="vip-icon">👑</div>
                                                <div class="vip-text-container">
                                                    <span class="vip-title"
                                                        wire:ignore  data-translate="page.quests.vip.upgrade_title">Upgrade to
                                                        VIP</span>
                                                    <span class="vip-cost"
                                                        wire:ignore  data-translate="page.quests.vip.cost_diamonds">500 💎</span>
                                                    <span class="vip-balance-check"
                                                        wire:ignore  data-translate="page.quests.vip.duration">1 Month</span>
                                                </div>
                                            </div>
                                        </div>
                                    @endif
                                </div>
                            </div>

                            <!-- Right Side: Daily Progress Grid -->
                            <div class="quest-right-section">
                                <div class="progress-section">
                                    <h3 class="section-title">31-Day Challenge Progress</h3>
                                    <div class="progress-grid">
                                        @for ($day = 1; $day <= 31; $day++)
                                            @php
                                                $dayStatus = $ProgressInfo->isDayCompleted($day);
                                                $statusClass = $dayStatus
                                                    ? 'completed'
                                                    : ($day <= $currentDay
                                                        ? 'current'
                                                        : 'upcoming');
                                                $isToday = $day == $currentDay;
                                            @endphp

                                            <div class="day-box {{ $statusClass }} {{ $isToday ? 'today' : '' }}">
                                                <span class="day-number">{{ $day }}</span>
                                                <span class="day-status">
                                                    @if ($dayStatus)
                                                        ✓
                                                    @elseif($isToday)
                                                        🔄
                                                    @else
                                                        ○
                                                    @endif
                                                </span>
                                                @if ($isToday)
                                                    <span class="today-label">Today</span>
                                                @endif
                                            </div>
                                        @endfor
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <!-- No Progress Info - Show Stats Only -->
                        <div class="quest-stats">
                            <div class="stat-card">
                                <div class="stat-icon">📊</div>
                                <div class="stat-info">
                                    <span class="stat-label">Current Day</span>
                                    <span class="stat-value">{{ $currentDay }}/31</span>
                                </div>
                            </div>
                            <div class="stat-card">
                                <div class="stat-icon">✅</div>
                                <div class="stat-info">
                                    <span class="stat-label">Completed Days</span>
                                    <span class="stat-value">{{ $totalCompletedDays }}</span>
                                </div>
                            </div>
                            <div class="stat-card">
                                <div class="stat-icon">🔥</div>
                                <div class="stat-info">
                                    <span class="stat-label">Progress</span>
                                    <span class="stat-value">0%</span>
                                </div>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Daily Task Section -->
            @if ($hasChar)
                <div class="daily-task-section">
                    @if ($ProgressInfo && $ProgressInfo->isDayCompleted($currentDay))
                        <!-- Congratulations Card -->
                        <div class="w-full max-w-4xl mx-auto bg-gradient-to-br from-green-900 via-purple-900 to-green-700 rounded-2xl shadow-2xl p-8 mb-8 border-4 border-green-400"
                             x-transition:enter="transition duration-500 ease-out"
                             x-transition:enter-start="opacity-0 transform scale-95"
                             x-transition:enter-end="opacity-100 transform scale-100">

                            <!-- Success Animation -->
                            <div class="flex justify-center items-center mb-6">
                                <div class="relative">
                                    <div class="text-6xl md:text-7xl animate-bounce">🎉</div>
                                    <div class="absolute inset-0 animate-pulse">
                                        <div class="w-20 h-20 md:w-24 md:h-24 border-4 border-green-400 rounded-full animate-ping"></div>
                                        <div class="w-16 h-16 md:w-20 md:h-20 border-2 border-yellow-400 rounded-full animate-ping" style="animation-delay: 0.5s;"></div>
                                        <div class="w-12 h-12 md:w-16 md:h-16 border border-purple-400 rounded-full animate-ping" style="animation-delay: 1s;"></div>
                                    </div>
                                </div>
                            </div>

                            <div class="text-center text-white">
                                <h2 class="text-3xl md:text-4xl font-extrabold text-green-300 mb-4"
                                    wire:ignore  data-translate="page.quests.congratulations.daily_complete_title">
                                    Daily Quest Completed!
                                </h2>

                                <p class="text-lg md:text-xl text-gray-200 mb-8 leading-relaxed max-w-2xl mx-auto"
                                    wire:ignore  data-translate="page.quests.congratulations.daily_complete_message">
                                    Amazing work, hero! You've successfully completed today's quest and earned your
                                    rewards. Your dedication brings you one step closer to greatness!
                                </p>

                                <!-- Quest Summary -->
                                <div class="bg-black bg-opacity-30 rounded-xl p-6 mb-8">
                                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                        <div class="flex flex-col items-center p-4 bg-gradient-to-br from-purple-700 to-green-600 rounded-lg">
                                            <span class="text-3xl mb-2">🎯</span>
                                            <span class="text-sm text-gray-300 mb-1">Quest:</span>
                                            <span class="text-white font-bold text-center">{{ $TaskDetails->task_name ?? 'Daily Quest' }}</span>
                                        </div>
                                        <div class="flex flex-col items-center p-4 bg-gradient-to-br from-green-700 to-purple-600 rounded-lg">
                                            <span class="text-3xl mb-2">📊</span>
                                            <span class="text-sm text-gray-300 mb-1">Progress:</span>
                                            <span class="text-white font-bold">Day {{ $currentDay }}/31 Complete</span>
                                        </div>
                                        <div class="flex flex-col items-center p-4 bg-gradient-to-br from-purple-700 to-green-600 rounded-lg">
                                            <span class="text-3xl mb-2">🏆</span>
                                            <span class="text-sm text-gray-300 mb-1">Total Days:</span>
                                            <span class="text-white font-bold">{{ $totalCompletedDays }} Days</span>
                                        </div>
                                    </div>
                                </div>

                                <!-- Tomorrow Message -->
                                <div class="bg-gradient-to-r from-purple-800 to-green-800 rounded-xl p-6 mb-6">
                                    <h3 class="text-2xl font-bold text-yellow-300 mb-3"
                                        wire:ignore  data-translate="page.quests.congratulations.come_back_tomorrow">
                                        Come Back Tomorrow
                                    </h3>
                                    <p class="text-gray-200 text-lg leading-relaxed"
                                        wire:ignore  data-translate="page.quests.congratulations.tomorrow_message">
                                        A new adventure awaits you tomorrow with fresh quests and exciting rewards. See
                                        you tomorrow, champion!
                                    </p>
                                </div>

                                <!-- Streak Reminder -->
                                <div class="flex items-center justify-center space-x-3 bg-gradient-to-r from-orange-600 to-red-600 rounded-full py-3 px-6">
                                    <span class="text-2xl animate-pulse">🔥</span>
                                    <span class="text-white font-bold text-lg"
                                        wire:ignore  data-translate="page.quests.congratulations.keep_streak">Keep Your Streak Going!</span>
                                </div>
                            </div>
                        </div>
                    @elseif ($UserTask)
                        <!-- Task Available -->
                        <div class="task-card active">

                            <div class="w-full flex justify-center items-center my-4">
                                @if ($TaskDetails && $TaskDetails->task_image)
                                    <div class="relative w-full max-w-lg md:max-w-xl lg:max-w-2xl">
                                        <img src="{{ $TaskDetails->task_image }}"
                                            alt="{{ $TaskDetails->task_name ?? 'Task Image' }}"
                                            class="w-full h-auto rounded-2xl shadow-xl object-cover">
                                        <div class="absolute inset-0 pointer-events-none"></div>
                                        <div class="absolute -inset-2 rounded-2xl border-4 border-purple-400 shadow-lg"></div>
                                    </div>
                                @else
                                    <div class="task-icon-placeholder text-6xl md:text-7xl lg:text-8xl">🎯</div>
                                @endif
                            </div>


                            <div class="task-content">
                                <h3 class="task-title">{{ $TaskDetails->task_name ?? 'Unknown Task' }}</h3>
                            </div>

                            <div class="task-action">
                                <div
                                    class="task-status-badge {{ !empty($GameQuests) && isset($GameQuests['QuestData2']) && $GameQuests['QuestData2'] == 1 ? 'completed' : 'active' }}">
                                    @if (!empty($GameQuests) && isset($GameQuests['QuestData2']) && $GameQuests['QuestData2'] == 1)
                                        <span wire:ignore  data-translate="page.quests.task_modal.quest_completed">Quest
                                            Completed!</span>
                                    @else
                                        <span wire:ignore  data-translate="page.quests.task_modal.quest_in_progress">Quest in
                                            Progress</span>
                                    @endif
                                </div>
                                <div class="task-progress-ring">
                                    @if (!empty($GameQuests) && isset($GameQuests['QuestData2']) && $GameQuests['QuestData2'] == 1)
                                        <div class="progress-check">✅</div>
                                    @else
                                        <div class="progress-spinner"></div>
                                    @endif
                                </div>

                                <!-- Complete Quest Button -->
                                <button class="task-complete-btn" x-on:click="completeTask()"
                                    x-bind:class="{
                                        'completing': isCompleting,
                                        'completed': isCompleted
                                    }"
                                    x-bind:disabled="isCompleting ||
                                        {{ empty($GameQuests) || !isset($GameQuests['QuestData2']) || $GameQuests['QuestData2'] != 1 ? 'true' : 'false' }}"
                                    x-transition:enter="transition ease-out duration-300"
                                    x-transition:enter-start="opacity-0 transform scale-90"
                                    x-transition:enter-end="opacity-100 transform scale-100">

                                    <span class="complete-icon" x-show="!isCompleting && !isCompleted">🎯</span>
                                    <span class="complete-icon" x-show="isCompleting">⏳</span>
                                    <span class="complete-icon" x-show="isCompleted">✅</span>

                                    <span x-show="!isCompleting && !isCompleted"
                                        wire:ignore  data-translate="page.quests.task_modal.complete_quest_btn">
                                        Complete Quest Day
                                    </span>
                                    <span x-show="isCompleting"
                                        wire:ignore  data-translate="page.quests.task_modal.completing_quest">
                                        Completing Quest...
                                    </span>
                                    <span x-show="isCompleted"
                                        wire:ignore  data-translate="page.quests.task_modal.quest_completed">
                                        Quest Completed!
                                    </span>
                                </button>
                            </div>
                        </div>
                    @else
                        <!-- No Task Available Page -->
                        <div x-data="{ CurrentQuestPage: 'NoTask' }" class="w-full flex flex-col items-center justify-center py-12">
                            <div class="max-w-md w-full bg-gradient-to-br from-purple-900 via-gray-900 to-purple-700 rounded-2xl shadow-xl p-8 text-center">
                                <div class="mb-4 text-5xl">📋</div>
                                <h3 class="text-2xl font-bold text-purple-300 mb-2">No Quest Available</h3>
                                <p class="text-lg text-gray-300 mb-6">Start your daily adventure by getting a new quest
                                </p>
                                <button class="quest-btn-primary w-full py-3 rounded-lg bg-gradient-to-r from-green-400 to-purple-500 text-white font-bold text-lg shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                    x-on:click="CurrentQuestPage = 'GetQuestPage'; $wire.call('getNewTask')">
                                    <span>🚀</span>
                                    <span>Get My Quest!</span>
                                </button>
                            </div>
                            <template x-if="CurrentQuestPage === 'GetQuestPage'">
                                <div class="mt-8 max-w-md w-full bg-gradient-to-br from-green-900 via-purple-900 to-gray-800 rounded-2xl shadow-xl p-8 text-center animate__animated animate__fadeIn">
                                    <div class="mb-4 text-5xl">🎯</div>
                                    <h3 class="text-2xl font-bold text-green-300 mb-2">Your New Quest Is Ready!</h3>
                                    <p class="text-lg text-gray-300 mb-6">Check your quest details and start your adventure
                                        now.</p>
                                    <button class="quest-btn-secondary w-full py-3 rounded-lg bg-gradient-to-r from-purple-400 to-green-500 text-white font-bold text-lg shadow-lg hover:scale-105 transition flex items-center justify-center gap-2"
                                        x-on:click="CurrentQuestPage = 'NoTask'">
                                        <span>❌</span>
                                        <span>Close</span>
                                    </button>
                                </div>
                            </template>
                        </div>
                    @endif
                </div>
            @endif
        @endif

        <!-- Rewards Showcase Section -->
        <div class="quest-rewards-section w-full py-10 px-2 md:px-8 lg:px-16 bg-gradient-to-br from-purple-900 via-gray-900 to-purple-700 rounded-2xl shadow-xl mt-8 mb-8"
             x-data="{
            claimingReward: null,
            CurrentGiftPage: 'rewards',
            claimedRewardName: '',
            claimedRewardType: '',
            claimedRewardIcon: '',
            claimedRewardCount: '',
            totalCompletedDays: {{ $totalCompletedDays ?? 0 }},
            userRewards: @js($UserReward ?? []),
            async claimReward(type, rewardChainId, rewardName, rewardIcon, rewardCount) {
                console.log('Claiming reward:', { type, rewardChainId, rewardName });
                this.claimingReward = type + '_' + rewardChainId;
                try {
                    if (type === 'normal') {
                        console.log('Calling claimNormalReward with ID:', rewardChainId);
                        await $wire.call('claimNormalReward', rewardChainId);
                    } else if (type === 'vip') {
                        console.log('Calling claimVipReward with ID:', rewardChainId);
                        await $wire.call('claimVipReward', rewardChainId);
                    }
                    console.log('Reward claim successful for type:', type);

                    // Store reward details for success page
                    this.claimedRewardName = rewardName;
                    this.claimedRewardType = type;
                    this.claimedRewardIcon = rewardIcon;
                    this.claimedRewardCount = rewardCount;

                    // Show success page
                    this.CurrentGiftPage = 'success';

                    // Return to rewards page after 4 seconds
                    setTimeout(() => {
                        this.CurrentGiftPage = 'rewards';
                        this.claimingReward = null;
                    }, 4000);
                } catch (error) {
                    console.error('Error claiming reward:', error);
                    console.error('Error details:', {
                        type: type,
                        rewardChainId: rewardChainId,
                        rewardName: rewardName,
                        errorMessage: error.message,
                        errorStack: error.stack
                    });
                    alert('خطأ في استلام المكافأة: ' + (error.message || 'مشكلة غير محددة'));
                    this.claimingReward = null;
                }
            },
            isClaimable(requiredDays) {
                return this.totalCompletedDays >= requiredDays;
            },
            isRewardClaimed(rewardId, rewardType) {
                if (!this.userRewards || !Array.isArray(this.userRewards)) return false;
                return this.userRewards.some(reward =>
                    reward.reward_id == rewardId &&
                    reward.reward_type == rewardType &&
                    reward.is_claimed == 1
                );
            },
            getClaimButtonText(type, rewardChainId) {
                const claimId = type + '_' + rewardChainId;
                if (this.claimingReward === claimId) return '⏳ Claiming...';
                return '🎁 Claim ' + (type === 'normal' ? 'Normal' : 'VIP') + ' Reward';
            },
            isClaimingSpecific(type, rewardChainId) {
                return this.claimingReward === type + '_' + rewardChainId;
            }
        }">

            <!-- Rewards List Page -->
            <div x-show="CurrentGiftPage === 'rewards'"
                 x-transition:enter="transition ease-out duration-500"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-300"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-95">

                <div class="rewards-header text-center mb-8">
                    <h2 class="rewards-title text-4xl md:text-5xl font-extrabold bg-gradient-to-r from-purple-400 via-pink-400 to-purple-600 bg-clip-text text-transparent mb-2 drop-shadow-lg">
                        Epic Rewards Chain
                    </h2>
                    <p class="rewards-description text-lg md:text-xl text-gray-300 max-w-2xl mx-auto mb-2">
                        Complete daily quests to unlock incredible treasures and exclusive rewards
                    </p>
                </div>
            <div class="rewards-chain-grid grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 md:gap-8">
                @if ($RewardsChain && count($RewardsChain) > 0)
                    @foreach ($RewardsChain as $rewardChain)
                        @php
                            $isClaimable = $totalCompletedDays >= $rewardChain['days_required'];
                            $normalReward = $rewardChain['normal_reward'] ?? null;
                            $vipReward = $rewardChain['vip_reward'] ?? null;
                            $normalClaimed = false;
                            $vipClaimed = false;
                            if ($UserReward && is_array($UserReward) && $normalReward) {
                                foreach ($UserReward as $userReward) {
                                    if (isset($normalReward['id']) && $userReward['reward_id'] == $normalReward['id'] && $userReward['reward_type'] == 'Normal' && $userReward['is_claimed']) {
                                        $normalClaimed = true;
                                        break;
                                    }
                                }
                            }
                            if ($UserReward && is_array($UserReward) && $vipReward) {
                                foreach ($UserReward as $userReward) {
                                    if (isset($vipReward['id']) && $userReward['reward_id'] == $vipReward['id'] && $userReward['reward_type'] == 'VIP' && $userReward['is_claimed']) {
                                        $vipClaimed = true;
                                        break;
                                    }
                                }
                            }
                        @endphp
                        <div class="reward-chain-card relative rounded-xl shadow-lg border-2 transition-all duration-300 bg-gradient-to-br from-gray-900 via-purple-900 to-gray-800 p-4 flex flex-col justify-between
                            {{ $isClaimable ? 'border-purple-400' : 'border-gray-700' }}
                            {{ ($normalClaimed && $vipClaimed) ? 'opacity-70 border-green-400' : '' }}">
                            <div class="reward-card-header relative pb-2 mb-2 border-b border-gray-700">
                                <div class="reward-day-badge absolute top-0 right-0 bg-gradient-to-r from-purple-500 to-pink-400 text-white px-4 py-1 rounded-full font-bold shadow-md text-xs">
                                    Day {{ $rewardChain['days_required'] }}
                                </div>
                                <h3 class="reward-title text-xl font-bold text-purple-200 mb-1">
                                    Day {{ $rewardChain['days_required'] }} Reward
                                </h3>
                                <p class="reward-description text-gray-400 text-sm">
                                    {{ $rewardChain['reward_description'] }}
                                </p>
                            </div>
                            <div class="reward-card-body flex-1 flex flex-col gap-4">
                                <div class="rewards-split grid grid-cols-1 md:grid-cols-2 gap-4">
                                    <!-- Normal Reward -->
                                    @if ($normalReward && is_array($normalReward))
                                        <div class="reward-item normal relative rounded-lg border-2 p-4 flex flex-col items-center justify-center bg-gray-900
                                            {{ $normalClaimed ? 'border-green-400 opacity-80' : 'border-green-600' }}">
                                            @if ($normalClaimed)
                                                <div class="reward-claimed-overlay absolute inset-0 bg-green-700 bg-opacity-80 flex items-center justify-center text-white font-bold text-lg rounded-lg">
                                                    <span>✅ Claimed</span>
                                                </div>
                                            @endif
                                            <div class="reward-header mb-2">
                                                <span class="reward-type-badge normal bg-gradient-to-r from-green-400 to-green-600 text-white px-2 py-1 rounded text-xs font-semibold">
                                                    Standard Reward
                                                </span>
                                            </div>
                                            <div class="reward-content flex flex-col items-center gap-2">
                                                <div class="reward-icon w-16 h-16 rounded-lg overflow-hidden border-2 border-green-400 bg-gray-800 flex items-center justify-center">
                                                    <img src="{{ asset($normalReward['reward_icon']) }}" alt="{{ $normalReward['reward_name'] }}" class="w-full h-full object-cover" onerror="this.src='{{ asset('images/default-reward.svg') }}'">
                                                </div>
                                                <div class="reward-details text-center">
                                                    <h4 class="reward-name text-base font-bold text-white mb-1">{{ $normalReward['reward_name'] }}</h4>
                                                    <p class="reward-type-info text-green-300 text-xs mb-1">{{ ucfirst($normalReward['reward_type']) }}</p>
                                                    <span class="reward-count bg-green-700 text-white px-2 py-1 rounded-full text-xs font-semibold">x{{ $normalReward['reward_count'] }}</span>
                                                </div>
                                            </div>
                                            <div class="reward-action w-full mt-2 flex justify-center">
                                                @if ($normalClaimed)
                                                    <button class="reward-btn collected w-full py-2 rounded bg-gray-700 text-gray-300 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">✅</span>
                                                        <span>Claimed</span>
                                                    </button>
                                                @elseif ($isClaimable)
                                                    <button class="reward-btn collect w-full py-2 rounded bg-gradient-to-r from-green-400 to-green-600 text-white font-bold flex items-center justify-center gap-2 shadow-lg hover:scale-105 transition"
                                                        x-bind:class="{ 'opacity-60': claimingReward === 'normal_{{ $rewardChain['id'] }}' }"
                                                        x-on:click="claimReward('normal', {{ $rewardChain['id'] }}, '{{ addslashes($normalReward['reward_name']) }}', '{{ asset($normalReward['reward_icon']) }}', '{{ $normalReward['reward_count'] }}')"
                                                        :disabled="claimingReward === 'normal_{{ $rewardChain['id'] }}'">
                                                        <span class="reward-btn-icon">🎁</span>
                                                        <span>Collect Standard</span>
                                                    </button>
                                                @else
                                                    <button class="reward-btn locked w-full py-2 rounded bg-gray-800 text-gray-400 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">🔒</span>
                                                        <span>Locked</span>
                                                    </button>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                    <!-- VIP Reward -->
                                    @if ($vipReward && is_array($vipReward))
                                        <div class="reward-item vip relative rounded-lg border-2 p-4 flex flex-col items-center justify-center bg-gray-900
                                            {{ $vipClaimed ? 'border-yellow-400 opacity-80' : 'border-yellow-600' }}">
                                            @if (!$UserChar || !$UserChar->isVip)
                                                <div class="vip-required absolute top-2 left-2 bg-gradient-to-r from-yellow-400 to-yellow-600 text-white px-2 py-1 rounded text-xs font-semibold shadow">
                                                    VIP Required
                                                </div>
                                            @endif
                                            @if ($vipClaimed)
                                                <div class="reward-claimed-overlay absolute inset-0 bg-yellow-700 bg-opacity-80 flex items-center justify-center text-white font-bold text-lg rounded-lg">
                                                    <span>✅ Claimed</span>
                                                </div>
                                            @endif
                                            <div class="reward-header mb-2">
                                                <span class="reward-type-badge vip bg-gradient-to-r from-yellow-400 to-yellow-600 text-white px-2 py-1 rounded text-xs font-semibold">
                                                    VIP Premium Reward
                                                </span>
                                            </div>
                                            <div class="reward-content flex flex-col items-center gap-2">
                                                <div class="reward-icon w-16 h-16 rounded-lg overflow-hidden border-2 border-yellow-400 bg-gray-800 flex items-center justify-center">
                                                    <img src="{{ asset($vipReward['reward_icon']) }}" alt="{{ $vipReward['reward_name'] }}" class="w-full h-full object-cover" onerror="this.src='{{ asset('images/default-reward.svg') }}'">
                                                </div>
                                                <div class="reward-details text-center">
                                                    <h4 class="reward-name text-base font-bold text-white mb-1">{{ $vipReward['reward_name'] }}</h4>
                                                    <p class="reward-type-info text-yellow-300 text-xs mb-1">{{ ucfirst($vipReward['reward_type']) }}</p>
                                                    <span class="reward-count bg-yellow-700 text-white px-2 py-1 rounded-full text-xs font-semibold">x{{ $vipReward['reward_count'] }}</span>
                                                </div>
                                            </div>
                                            <div class="reward-action w-full mt-2 flex justify-center">
                                                @if ($vipClaimed)
                                                    <button class="reward-btn collected w-full py-2 rounded bg-gray-700 text-gray-300 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">✅</span>
                                                        <span>Claimed</span>
                                                    </button>
                                                @elseif ($isClaimable && ($UserChar && $UserChar->isVip))
                                                    <button class="reward-btn collect w-full py-2 rounded bg-gradient-to-r from-yellow-400 to-yellow-600 text-white font-bold flex items-center justify-center gap-2 shadow-lg hover:scale-105 transition"
                                                        x-bind:class="{ 'opacity-60': claimingReward === 'vip_{{ $rewardChain['id'] }}' }"
                                                        x-on:click="claimReward('vip', {{ $rewardChain['id'] }}, '{{ addslashes($vipReward['reward_name']) }}', '{{ asset($vipReward['reward_icon']) }}', '{{ $vipReward['reward_count'] }}')"
                                                        :disabled="claimingReward === 'vip_{{ $rewardChain['id'] }}'">
                                                        <span class="reward-btn-icon">👑</span>
                                                        <span>Collect VIP</span>
                                                    </button>
                                                @elseif (!$UserChar || !$UserChar->isVip)
                                                    <button class="reward-btn locked w-full py-2 rounded bg-gray-800 text-yellow-400 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">👑</span>
                                                        <span>Upgrade for VIP</span>
                                                    </button>
                                                @else
                                                    <button class="reward-btn locked w-full py-2 rounded bg-gray-800 text-gray-400 font-bold cursor-not-allowed flex items-center justify-center gap-2" disabled>
                                                        <span class="reward-btn-icon">🔒</span>
                                                        <span>Locked</span>
                                                    </button>
                                                @endif
                                            </div>
                                        </div>
                                    @endif
                                </div>
                                <!-- Progress Bar -->
                                @if ($isClaimable && !($normalClaimed && $vipClaimed))
                                    <div class="reward-progress w-full h-2 bg-purple-900 rounded-full mt-4">
                                        <div class="reward-progress-fill h-2 bg-gradient-to-r from-green-400 via-purple-400 to-yellow-400 rounded-full transition-all duration-500" style="width: 100%"></div>
                                    </div>
                                @elseif (!$isClaimable)
                                    <div class="reward-progress w-full h-2 bg-gray-800 rounded-full mt-4">
                                        <div class="reward-progress-fill h-2 bg-gradient-to-r from-gray-400 to-purple-400 rounded-full transition-all duration-500" style="width: {{ min(100, ($totalCompletedDays / $rewardChain['days_required']) * 100) }}%"></div>
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="no-rewards-message col-span-full text-center py-8">
                        <h3 class="text-2xl font-bold text-purple-300 mb-2">No Rewards Available</h3>
                        <p class="text-lg text-gray-400">Rewards will be available soon. Check back later!</p>
                    </div>
                @endif
            </div>
            </div>

            <!-- Success Page -->
            <div x-show="CurrentGiftPage === 'success'"
                 x-transition:enter="transition ease-out duration-600"
                 x-transition:enter-start="opacity-0 transform scale-90"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-400"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-90">

                <div class="success-page-container w-full max-w-2xl mx-auto bg-gradient-to-br from-green-900 via-purple-900 to-green-700 rounded-2xl shadow-2xl p-8 text-center border-4 border-green-400">

                    <!-- Success Animation -->
                    <div class="success-animation mb-6">
                        <div class="relative inline-block">
                            <div class="text-8xl animate-bounce">🎉</div>
                            <div class="absolute inset-0 animate-pulse">
                                <div class="w-24 h-24 border-4 border-green-400 rounded-full animate-ping"></div>
                                <div class="w-20 h-20 border-2 border-yellow-400 rounded-full animate-ping" style="animation-delay: 0.5s;"></div>
                                <div class="w-16 h-16 border border-purple-400 rounded-full animate-ping" style="animation-delay: 1s;"></div>
                            </div>
                        </div>
                    </div>

                    <!-- Success Title -->
                    <h2 class="text-4xl md:text-5xl font-extrabold text-green-300 mb-6">
                        🎁 Reward Claimed Successfully!
                    </h2>

                    <!-- Reward Display Card -->
                    <div class="reward-display-card bg-black bg-opacity-40 rounded-xl p-6 mb-6">
                        <div class="reward-icon-large mb-4">
                            <img x-bind:src="claimedRewardIcon" x-bind:alt="claimedRewardName"
                                 class="w-24 h-24 mx-auto rounded-lg border-4 border-yellow-400 shadow-lg"
                                 onerror="this.src='{{ asset('images/default-reward.svg') }}'">
                        </div>

                        <div class="reward-info">
                            <h3 class="text-2xl font-bold text-white mb-2" x-text="claimedRewardName">Reward Name</h3>
                            <div class="reward-type-badge inline-block px-4 py-2 rounded-full font-semibold text-sm mb-3"
                                 x-bind:class="{
                                    'bg-gradient-to-r from-green-400 to-green-600 text-white': claimedRewardType === 'normal',
                                    'bg-gradient-to-r from-yellow-400 to-yellow-600 text-white': claimedRewardType === 'vip'
                                 }">
                                <span x-show="claimedRewardType === 'normal'">✨ Standard Reward</span>
                                <span x-show="claimedRewardType === 'vip'">👑 VIP Premium Reward</span>
                            </div>

                            <div class="reward-count text-3xl font-bold text-yellow-300 mb-2">
                                x<span x-text="claimedRewardCount">1</span>
                            </div>

                            <p class="text-lg text-gray-200">
                                has been added to your inventory!
                            </p>
                        </div>
                    </div>

                    <!-- Success Message -->
                    <div class="success-message bg-gradient-to-r from-green-700 to-purple-700 rounded-xl p-6 mb-6">
                        <h4 class="text-xl font-bold text-yellow-300 mb-2">🏆 Amazing Work, Champion!</h4>
                        <p class="text-gray-200 text-lg leading-relaxed">
                            Your dedication to completing daily quests has been rewarded. Keep up the excellent work and continue your journey to greatness!
                        </p>
                    </div>

                    <!-- Auto Return Message -->
                    <div class="auto-return-message flex items-center justify-center space-x-3 bg-gradient-to-r from-blue-600 to-purple-600 rounded-full py-3 px-6 text-white">
                        <span class="text-2xl animate-spin">⏰</span>
                        <span class="font-semibold">Returning to rewards in a few seconds...</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Get Quest Modal -->
        <div class="character-modal-overlay" x-show="showGetQuestModal" x-cloak
            x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-200"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-on:click.outside="closeGetQuestModal()">

            <div class="get-quest-modal-content" x-on:click.stop
                x-transition:enter="transition ease-out duration-300 delay-100"
                x-transition:enter-start="opacity-0 transform scale-90"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-200"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-90">

                <!-- Close Button -->
                <button x-on:click="closeGetQuestModal()" class="modal-close-btn">
                    ×
                </button>

                <!-- Quest Illustration -->
                <div class="quest-illustration">
                    <div class="quest-scroll">📜</div>
                    <div class="quest-sparkles">✨</div>
                </div>

                <!-- Quest Content -->
                <div class="quest-content">
                    <h2 class="quest-title">Ready for Adventure?</h2>
                    <p class="quest-description">
                        Embark on an epic daily quest and earn amazing rewards!
                        Each quest is carefully designed to provide exciting challenges and valuable treasures.
                    </p>

                    <div class="quest-features">
                        <div class="quest-feature">
                            <div class="quest-feature-icon">🎯</div>
                            <div class="quest-feature-text">Daily Challenges</div>
                        </div>
                        <div class="quest-feature">
                            <div class="quest-feature-icon">💎</div>
                            <div class="quest-feature-text">Epic Rewards</div>
                        </div>
                        <div class="quest-feature">
                            <div class="quest-feature-icon">⏱️</div>
                            <div class="quest-feature-text">Timed Objectives</div>
                        </div>
                        <div class="quest-feature">
                            <div class="quest-feature-icon">🏆</div>
                            <div class="quest-feature-text">Progress Tracking</div>
                        </div>
                    </div>
                </div>

                <!-- Modal Actions -->
                <div class="get-quest-actions">
                    <button class="quest-btn_primary" x-on:click="getNewQuest()">
                        <span>🚀</span>
                        Get My Quest!
                    </button>

                    <button class="quest-btn_secondary" x-on:click="closeGetQuestModal()">
                        <span>❌</span>
                        Maybe Later
                    </button>
                </div>
            </div>
        </div>

        <!-- VIP Upgrade Modal -->
        <div class="vip-modal-overlay" x-show="showVipModal" x-cloak
            x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-on:click.outside="closeVipModal()">

            <div class="vip-modal-content" x-on:click.stop
                x-transition:enter="transition ease-out duration-600 delay-100"
                x-transition:enter-start="opacity-0 transform scale-80"
                x-transition:enter-end="opacity-100 transform scale-100"
                x-transition:leave="transition ease-in duration-300"
                x-transition:leave-start="opacity-100 transform scale-100"
                x-transition:leave-end="opacity-0 transform scale-80" x-bind:class="{ 'vip-upgrading': isUpgrading }">

                <!-- Modal Header -->
                <div class="vip-modal-header">
                    <button x-on:click="closeVipModal()" class="vip-modal-close">×</button>

                    <div class="vip-modal-icon">👑</div>
                    <h2 class="vip-modal-title" wire:ignore  data-translate="page.quests.vip.upgrade_title">Upgrade to VIP</h2>
                    <p class="vip-modal-subtitle" wire:ignore  data-translate="page.quests.vip.upgrade_subtitle">Unlock Premium
                        Benefits</p>
                    <p class="vip-modal-description" wire:ignore  data-translate="page.quests.vip.upgrade_description">Upgrade to
                        VIP for 500 💎 Balance for this month</p>
                </div>

                <!-- Modal Body -->
                <div class="vip-modal-body">
                    <!-- Pricing Card -->
                    <div class="vip-pricing-card">
                        <div class="vip-price" x-text="vipCost + ' 💎'"></div>
                        <div class="vip-duration" wire:ignore  data-translate="page.quests.vip.duration">1 Month</div>
                    </div>

                    <!-- Balance Info -->
                    <div class="vip-balance-info">
                        <div class="balance-item">
                            <div class="balance-label" wire:ignore  data-translate="page.quests.vip.current_balance">Current
                                Balance</div>
                            <div class="balance-value" x-text="currentBalance + ' 💎'"
                                x-bind:class="{ 'insufficient': !checkBalance() }"></div>
                        </div>
                        <div class="balance-item">
                            <div class="balance-label">Required</div>
                            <div class="balance-value" x-text="vipCost + ' 💎'"></div>
                        </div>
                    </div>

                    <!-- VIP Benefits -->
                    <div class="vip-benefits">
                        <h3 class="vip-benefits-title" wire:ignore  data-translate="page.quests.vip.benefits.title">VIP Benefits
                        </h3>
                        <div class="vip-benefits-grid">
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">🎁</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.exclusive_rewards">Exclusive VIP Rewards
                                </div>
                            </div>
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">⚡</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.double_rewards">Double Daily Rewards</div>
                            </div>
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">🛡️</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.priority_support">Priority Support</div>
                            </div>
                            <div class="vip-benefit">
                                <div class="vip-benefit-icon">🌟</div>
                                <div class="vip-benefit-text"
                                    wire:ignore  data-translate="page.quests.vip.benefits.special_events">Special VIP Events</div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Modal Actions -->
                <div class="vip-modal-actions">
                    <button class="vip-upgrade-btn" x-on:click="upgradeToVip()"
                        x-bind:disabled="!checkBalance() || isUpgrading"
                        x-bind:class="{ 'vip-upgrading': isUpgrading }">
                        <span x-show="!isUpgrading" wire:ignore  data-translate="page.quests.vip.upgrade_now">👑 Upgrade Now</span>
                        <span x-show="isUpgrading" wire:ignore  data-translate="page.quests.vip.upgrading">⏳ Upgrading...</span>
                    </button>

                    <button class="vip-cancel-btn" x-on:click="closeVipModal()">
                        <span wire:ignore  data-translate="page.quests.vip.insufficient_dialog.close">❌ Close</span>
                    </button>
                </div>
            </div>
        </div>

        <!-- Insufficient Balance Modal -->
        <div class="vip-modal-overlay" x-show="showInsufficientBalanceModal" x-cloak
            x-transition:enter="transition ease-out duration-500" x-transition:enter-start="opacity-0"
            x-transition:enter-end="opacity-100" x-transition:leave="transition ease-in duration-300"
            x-transition:leave-start="opacity-100" x-transition:leave-end="opacity-0"
            x-on:click.outside="closeInsufficientBalanceModal()">

            <div class="vip-modal-content insufficient-balance-modal" x-on:click.stop
                x-transition:enter="transition ease-out duration-600 delay-100"
                x-transition:enter-start="opacity-0 transform scale-80"
                x-transition:enter-end="opacity-100 transform scale-100">

                <div class="vip-modal-header">
                    <button x-on:click="closeInsufficientBalanceModal()" class="vip-modal-close">×</button>

                    <div class="insufficient-balance-icon">💸</div>
                    <h2 class="insufficient-title" wire:ignore  data-translate="page.quests.vip.insufficient_dialog.title">
                        Insufficient Balance</h2>
                </div>

                <div class="vip-modal-body">
                    <p class="insufficient-message" wire:ignore  data-translate="page.quests.vip.insufficient_dialog.message"
                        x-text="'You need 500 💎 Balance to upgrade to VIP. Your current balance is ' + currentBalance + ' 💎.'">
                        You need 500 💎 Balance to upgrade to VIP. Your current balance is 0 💎.
                    </p>
                </div>

                <div class="vip-modal-actions">
                    <button class="vip-upgrade-btn" x-on:click="closeInsufficientBalanceModal()">
                        <span wire:ignore  data-translate="page.quests.vip.insufficient_dialog.add_balance">💎 Add Balance</span>
                    </button>

                    <button class="vip-cancel-btn" x-on:click="closeInsufficientBalanceModal()">
                        <span wire:ignore  data-translate="page.quests.vip.insufficient_dialog.close">❌ Close</span>
                    </button>
                </div>
            </div>
        </div>

    </div>
</div>
