<?php
use Livewire\Volt\Component;
new class extends Component {

    public function mount()
    {
        $this->loadData();
    }

    //load data
    public function loadData()
    {

    }
};
?>
<div>
    <div class="space-y-8" x-data="{
        showModal: false,
        isLoading: false,
        marketStats: {
            active_listings: 567,
            trades_today: 89,
            total_volume: '2.3M Gold',
            trending_item: 'Rare Gems'
        },
        recentTrades: [
            {
                id: 1,
                seller: 'PlayerOne',
                buyer: 'PlayerTwo',
                item: 'Magic Sword +12',
                price: '50,000 Gold',
                time: '5 mins ago'
            },
            {
                id: 2,
                seller: 'TraderPro',
                buyer: 'NewPlayer',
                item: 'Shield of Light',
                price: '25,000 Gold',
                time: '12 mins ago'
            }
        ]
    }" x-init="isLoading = true; setTimeout(() => isLoading = false, 1000)">

        <!-- Loading State -->
        <div x-show="isLoading" class="flex items-center justify-center py-12">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div>
        </div>

        <div x-show="!isLoading" x-transition>

            <!-- Page Header -->
            <div class="text-center">
                <div
                    class="w-16 h-16 mx-auto mb-4 bg-gradient-to-r from-indigo-500 to-purple-600 rounded-2xl flex items-center justify-center">
                    <i class="fas fa-store text-white text-2xl"></i>
                </div>
                <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Players Shop Management</h2>
                <p class="text-gray-600 dark:text-gray-400">Monitor player-to-player trading activities</p>
            </div>
        </div>
    </div>
</div>
