<?php
use Livewire\Volt\Component;
new class extends Component {
    //
};
?>
<div>
    <div class="space-y-8" x-data="{
        showModal: false,
        isLoading: false,
        marketData: {
            total_value: '15.8M Gold',
            trending_up: 12,
            trending_down: 5,
            hot_category: 'Weapons'
        },
        priceAlerts: [
            {
                id: 1,
                item: 'Dragon Scale',
                change: '+15%',
                price: '5,000 Gold',
                trend: 'up'
            },
            {
                id: 2,
                item: 'Magic Ore',
                change: '-8%',
                price: '1,200 Gold',
                trend: 'down'
            }
        ]
    }" x-init="isLoading = true; setTimeout(() => isLoading = false, 1000)">

        <!-- Loading State -->
        <div x-show="isLoading" class="flex items-center justify-center py-12">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div>
        </div>

        <div x-show="!isLoading" x-transition>

            <!-- Page Header -->
            <div class="text-center">
                <div
                    class="w-16 h-16 mx-auto mb-4 bg-gradient-to-r from-violet-500 to-purple-600 rounded-2xl flex items-center justify-center">
                    <i class="fas fa-cubes text-white text-2xl"></i>
                </div>
                <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Market Inventory Management</h2>
                <p class="text-gray-600 dark:text-gray-400">Analyze marketplace inventory and economics</p>
            </div>
        </div>
    </div>
</div>
