<?php
use Livewire\Volt\Component;
new class extends Component {
    //
};
?>
<div>
    <div class="space-y-8" x-data="{
        showModal: false,
        isLoading: false,
        charStats: {
            total_characters: 8542,
            online_now: 1234,
            banned_chars: 45,
            premium_chars: 2156
        },
        recentActivity: [
            {
                id: 1,
                character: 'DragonSlayer',
                action: 'Login',
                time: '2 mins ago',
                status: 'online'
            },
            {
                id: 2,
                character: 'MagicWizard',
                action: 'Level Up',
                time: '5 mins ago',
                status: 'online'
            }
        ]
    }" x-init="isLoading = true; setTimeout(() => isLoading = false, 1000)">

        <!-- Loading State -->
        <div x-show="isLoading" class="flex items-center justify-center py-12">
            <div class="animate-spin rounded-full h-12 w-12 border-b-2 border-blue-600"></div>
        </div>

        <div x-show="!isLoading" x-transition>

            <!-- Page Header -->
            <div class="text-center">
                <div
                    class="w-16 h-16 mx-auto mb-4 bg-gradient-to-r from-purple-500 to-pink-600 rounded-2xl flex items-center justify-center">
                    <i class="fas fa-users text-white text-2xl"></i>
                </div>
                <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-2">Character List Management</h2>
                <p class="text-gray-600 dark:text-gray-400">View and manage all player characters</p>
            </div>
        </div>
    </div>
</div>
