<?php
use Livewire\Volt\Component;
use Illuminate\Support\Facades\Auth;
use App\Models\Z_A_BOTS_SYSTEMS\Event4TApp;
use App\Models\SRO_VT_SHARD\Char;
use App\Models\SRO_VT_PROXY\_Players;
use App\Models\SRO_VT_SHARD\_User;
use Carbon\Carbon;

new class extends Component {
    public $stats = 'none';
    public $userserial = null;
    public $charInfo = null;
    public $currentCharacterAvatar = null;
    public $isTimerStarted = false;
    public $timer = null;
    public $ChooseAnotherChar = [];
    public $refreshingChars = false;

    public function mount()
    {
        $this->loadUserData();
    }

    public function switchCharacter($charId)
    {
        try {
            // التحقق من صحة معرف الشخصية
            if (!$charId || !is_numeric($charId)) {
                session()->flash('error', 'trans:4tApp.errors.invalidCharacterID');
                return;
            }

            // التحقق من أن الشخصية تنتمي للمستخدم
            $selectedChar = Char::where('CharID', $charId)->first();
            $selectedUser = _User::where('CharID', $charId)->first();
            if (!$selectedChar) {
                session()->flash('error', 'trans:4tApp.errors.characterNotFound');
                return;
            }

            // التحقق من ملكية الشخصية للمستخدم
            if ($selectedUser->UserJID != Auth::user()->JID) {
                session()->flash('error', 'trans:4tApp.errors.noPermissionForCharacter');
                return;
            }

            // التحقق من أن المستخدم لديه serial في _Players
            $userSerial = _Players::getSerialByusername(Auth::user()->username);
            if (!$userSerial) {
                session()->flash('error', 'trans:4tApp.errors.enterGameFirst');
                return;
            }

            // إذا كان المستخدم يشارك بالفعل في الحدث، قم بتحديث الشخصية
            $existingEvent = Event4TApp::where('Hwid', $userSerial)->first();
            if ($existingEvent) {
                $existingEvent->update([
                    'CharID' => $charId,
                    'Charname' => $selectedChar->CharName16,
                    'Start' => now()->addHours(18), // إعادة تعيين وقت البدء إلى 18 ساعة من الآن
                ]);

                session()->flash('success', 'trans:4tApp.success.characterSwitched');
            } else {
                // إنشاء مشاركة جديدة في الحدث
                Event4TApp::create([
                    'Hwid' => $userSerial,
                    'CharID' => $charId,
                    'Charname' => $selectedChar->CharName16,
                    'Start' => now()->addHours(18), // بدء الحدث بعد 5 دقائق
                ]);

                session()->flash('success', 'trans:4tApp.success.characterSelected');
            }

            // إعادة تحميل البيانات
            $this->loadUserData();

        } catch (\Exception $e) {
            session()->flash('error', 'trans:4tApp.errors.characterSwitchFailed');
        }
    }

    public function refreshAvailableCharacters()
    {
        $this->refreshingChars = true;

        // إعادة تحديث قائمة الشخصيات المتاحة
        if ($this->charInfo) {
            $this->ChooseAnotherChar = Event4TApp::getAvailableAnotherChars(Auth::user()->JID, $this->charInfo->CharID);
        }

        $this->refreshingChars = false;
    }

    public function loadUserData()
    {
        $this->userserial = _Players::getSerialByusername(Auth::user()->username);
        // if usererserial is null, or not exists in _players table back states need enter game first
        if ($this->userserial === null) {
            $this->stats = 'need enter game first';
            return;
        }
        // Check if serial exists in Event4TApp back states serial exists
        if (Event4TApp::existsSerial($this->userserial)) {
            $this->charInfo = Event4TApp::where('Hwid', $this->userserial)->first();
            $this->currentCharacterAvatar = Char::getCharAvatarGifByCharname($this->charInfo->Charname);

            //check if charinfo start > now time style in database 2025-09-11 19:22:00
            if (Carbon::parse($this->charInfo->Start) > Carbon::now()) {
                $this->isTimerStarted = true;
                $this->timer = Carbon::parse($this->charInfo->Start)->diffForHumans();
            } else {
                $this->isTimerStarted = false;
                $this->timer = null;
            }

            //choose available char IDs for user to switch between them
            $this->ChooseAnotherChar = Event4TApp::getAvailableAnotherChars(Auth::user()->JID, $this->charInfo->CharID);
            //check if char belongs to user
            if (!Event4TApp::isCharBelongsToUser(Auth::user()->JID)) {
                //إحضار الشخصية الموجوده
                $this->stats = 'char does not belong to user';
                return;
            } else {
                $this->stats = 'char belong to user';
                return;
            }

            $this->stats = 'exists in Event4TApp';
            return;
        }elseif (!Event4TApp::existsSerial($this->userserial) && $this->userserial !== null) {
            // المستخدم يمكنه دخول الإيفنت - جلب الشخصيات المتاحة
            $this->ChooseAnotherChar = Event4TApp::getAvailableAnotherChars(Auth::user()->JID, 0);
            $this->stats = 'Can enter Event4TApp';
            return;
        } else {
            $this->stats = 'none';
            return;
        }
    }
};
?>
<div x-data="{
    loading: false,
    showCharacterSelector: false,
    animationLoaded: false,
    selectedCharacter: null,
    init() {
        this.animationLoaded = true;
    },
    refreshData() {
        this.loading = true;
        setTimeout(() => {
            $wire.loadUserData();
            this.loading = false;
        }, 1500);
    },
    openCharacterSelector() {
        if (!$wire.ChooseAnotherChar || $wire.ChooseAnotherChar.length === 0) {
            console.warn('No characters available for selection');
            // استخدام نظام الترجمة للـ alert
            const message = window.getTranslation ? window.getTranslation('4tApp.alerts.noCharactersAvailable') : 'No characters available for selection. Please make sure you have characters in the game.';
            alert(message);
            return;
        }


        $wire.refreshAvailableCharacters()
            .then(() => {
                this.showCharacterSelector = true;
                this.selectedCharacter = null;
            })
            .catch((error) => {
                console.error('Failed to refresh characters:', error);
                this.showCharacterSelector = true;
                this.selectedCharacter = null;
            });
    },
    selectCharacter(charId) {
        if (!charId) {
            console.error('Invalid character ID');
            return;
        }


        this.selectedCharacter = charId;
    },
    confirmCharacterSelection() {
        if (!this.selectedCharacter) {
            console.error('No character selected');
            const message = window.getTranslation ? window.getTranslation('4tApp.alerts.selectCharacterFirst') : 'Please select a character first.';
            alert(message);
            return;
        }


        this.loading = true;


        setTimeout(() => {
            this.showCharacterSelector = false;
        }, 300);


        $wire.switchCharacter(this.selectedCharacter)
            .then(() => {

                this.loading = false;


                this.selectedCharacter = null;
            })
            .catch((error) => {

                this.loading = false;
                this.showCharacterSelector = true;
                console.error('Failed to switch character:', error);

                // استخدام نظام الترجمة للـ alert
                const message = window.getTranslation ? window.getTranslation('4tApp.alerts.characterSwitchFailed') : 'Failed to switch character. Please try again or contact support.';
                alert(message);
            });
    }
}"
x-cloak
class="four-t-app-container"
:class="{ 'four-t-fade-in': animationLoaded }">

    <!-- Main Header -->
    <div class="four-t-app-header four-t-slide-up">
        <h1 class="four-t-app-title" data-translate="page.4t-app.title">
            4T Mobile Application Manager
        </h1>
        <p class="four-t-app-description" data-translate="page.4t-app.description">
            Advanced mobile application event management system for character participation and real-time monitoring
        </p>
    </div>

    <!-- Flash Messages -->
    @if (session()->has('success'))
        <div class="four-t-alert four-t-alert-success four-t-slide-up" style="animation-delay: 0.1s;">
            <div class="four-t-alert-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <div class="four-t-alert-content">
                <div class="four-t-alert-title" data-translate="common.success">Success!</div>
                <div class="four-t-alert-message"
                     x-data="{ message: '{{ session('success') }}' }"
                     x-text="message.startsWith('trans:') ? (window.getTranslation ? window.getTranslation(message.substring(6)) : message.substring(6)) : message">
                </div>
            </div>
            <button class="four-t-alert-close" onclick="this.parentElement.remove()">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif

    @if (session()->has('error'))
        <div class="four-t-alert four-t-alert-error four-t-slide-up" style="animation-delay: 0.1s;">
            <div class="four-t-alert-icon">
                <i class="fas fa-exclamation-triangle"></i>
            </div>
            <div class="four-t-alert-content">
                <div class="four-t-alert-title" data-translate="common.error">Error!</div>
                <div class="four-t-alert-message"
                     x-data="{ message: '{{ session('error') }}' }"
                     x-text="message.startsWith('trans:') ? (window.getTranslation ? window.getTranslation(message.substring(6)) : message.substring(6)) : message">
                </div>
            </div>
            <button class="four-t-alert-close" onclick="this.parentElement.remove()">
                <i class="fas fa-times"></i>
            </button>
        </div>
    @endif

    <!-- Loading State -->
    <div x-show="loading" class="four-t-loading">
        <div class="four-t-loading-spinner"></div>
        <div class="four-t-loading-text" data-translate="page.4t-app.loading">
            Loading application data...
        </div>
    </div>

    <!-- Main Content -->
    <div x-show="!loading">

        @if($stats === 'need enter game first')
            <!-- Need to Enter Game First - Enhanced Welcome Message -->
            <div class="four-t-welcome-container four-t-slide-up">
                <!-- Animated Background Elements -->
                <div class="four-t-welcome-bg-elements">
                    <div class="four-t-welcome-particle"></div>
                    <div class="four-t-welcome-particle"></div>
                    <div class="four-t-welcome-particle"></div>
                </div>

                <!-- Main Welcome Card -->
                <div class="four-t-welcome-card">
                    <!-- Animated Icon -->
                    <div class="four-t-welcome-icon-container">
                        <div class="four-t-welcome-icon-bg">
                            <i class="fas fa-gamepad four-t-welcome-icon"></i>
                        </div>
                        <div class="four-t-welcome-icon-rings">
                            <div class="four-t-welcome-ring ring-1"></div>
                            <div class="four-t-welcome-ring ring-2"></div>
                            <div class="four-t-welcome-ring ring-3"></div>
                        </div>
                    </div>

                    <!-- Welcome Content -->
                    <div class="four-t-welcome-content">
                        <div class="four-t-welcome-title-container">
                            <h1 class="four-t-welcome-title" data-translate="page.4t-app.status.needEnterGame.title">
                                Welcome to 4T Mobile App
                            </h1>
                            <div class="four-t-welcome-subtitle" data-translate="page.4t-app.status.needEnterGame.subtitle">
                                Your Gaming Adventure Awaits
                            </div>
                        </div>

                        <div class="four-t-welcome-description" data-translate="page.4t-app.status.needEnterGame.description">
                            <p>To unlock the full potential of the 4T Mobile Application, you'll need to enter the game first.</p>
                            <p>Once you're in-game, return here to manage your events and participate in exciting activities!</p>
                        </div>

                        <!-- Steps Guide -->
                        <div class="four-t-welcome-steps">
                            <div class="four-t-welcome-step">
                                <div class="four-t-step-number">1</div>
                                <div class="four-t-step-text" data-translate="page.4t-app.steps.enterGame">
                                    Launch and enter the game
                                </div>
                            </div>
                            <div class="four-t-welcome-step">
                                <div class="four-t-step-number">2</div>
                                <div class="four-t-step-text" data-translate="page.4t-app.steps.createCharacter">
                                    Create or select your character
                                </div>
                            </div>
                            <div class="four-t-welcome-step">
                                <div class="four-t-step-number">3</div>
                                <div class="four-t-step-text" data-translate="page.4t-app.steps.returnHere">
                                    Return here to start your 4T experience
                                </div>
                            </div>
                        </div>

                        <!-- Action Button -->
                        <div class="four-t-welcome-actions">
                            <button @click="refreshData()" class="four-t-welcome-btn">
                                <span class="four-t-btn-content">
                                    <i class="fas fa-sync-alt four-t-btn-icon"></i>
                                    <span class="four-t-btn-text" data-translate="page.4t-app.actions.checkStatus">
                                        Check Status Again
                                    </span>
                                </span>
                                <div class="four-t-btn-glow"></div>
                            </button>

                            <div class="four-t-welcome-tip">
                                <i class="fas fa-lightbulb"></i>
                                <span data-translate="page.4t-app.tips.refreshAfterGame">
                                    Tip: Refresh this page after entering the game
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        @elseif($stats === 'Can enter Event4TApp')
            <!-- Can Enter Event - Character Selection Interface -->
            <div class="four-t-event-entry-container four-t-slide-up">
                <!-- Animated Background Elements -->
                <div class="four-t-entry-bg-elements">
                    <div class="four-t-entry-particle"></div>
                    <div class="four-t-entry-particle"></div>
                    <div class="four-t-entry-particle"></div>
                    <div class="four-t-entry-particle"></div>
                </div>

                <!-- Main Entry Card -->
                <div class="four-t-event-entry-card">
                    <!-- Animated Header Icon -->
                    <div class="four-t-entry-icon-container">
                        <div class="four-t-entry-icon-bg">
                            <i class="fas fa-rocket four-t-entry-icon"></i>
                        </div>
                        <div class="four-t-entry-icon-rings">
                            <div class="four-t-entry-ring ring-1"></div>
                            <div class="four-t-entry-ring ring-2"></div>
                            <div class="four-t-entry-ring ring-3"></div>
                        </div>
                    </div>

                    <!-- Entry Content -->
                    <div class="four-t-entry-content">
                        <div class="four-t-entry-title-container">
                            <h1 class="four-t-entry-title" data-translate="page.4t-app.status.canEnterEvent.title">
                                Ready to Join 4T Event!
                            </h1>
                            <div class="four-t-entry-subtitle" data-translate="page.4t-app.status.canEnterEvent.subtitle">
                                Your Adventure Begins Now
                            </div>
                        </div>

                        <div class="four-t-entry-description" data-translate="page.4t-app.status.canEnterEvent.description">
                            <p>Great news! You're eligible to participate in the 4T Mobile Event.</p>
                            <p>Select one of your available characters below to start your exciting journey!</p>
                        </div>

                        <!-- Event Features -->
                        <div class="four-t-entry-features">
                            <div class="four-t-entry-feature">
                                <div class="four-t-feature-icon">
                                    <i class="fas fa-trophy"></i>
                                </div>
                                <div class="four-t-feature-text" data-translate="page.4t-app.features.rewards">
                                    Exclusive Rewards
                                </div>
                            </div>
                            <div class="four-t-entry-feature">
                                <div class="four-t-feature-icon">
                                    <i class="fas fa-users"></i>
                                </div>
                                <div class="four-t-feature-text" data-translate="page.4t-app.features.community">
                                    Join Community
                                </div>
                            </div>
                            <div class="four-t-entry-feature">
                                <div class="four-t-feature-icon">
                                    <i class="fas fa-mobile-alt"></i>
                                </div>
                                <div class="four-t-feature-text" data-translate="page.4t-app.features.mobileApp">
                                    Mobile Integration
                                </div>
                            </div>
                        </div>

                        <!-- Action Buttons -->
                        <div class="four-t-entry-actions">
                            <button @click="openCharacterSelector()" class="four-t-entry-btn-primary">
                                <span class="four-t-entry-btn-content">
                                    <i class="fas fa-user-plus four-t-entry-btn-icon"></i>
                                    <span class="four-t-entry-btn-text" data-translate="page.4t-app.actions.selectCharacter">
                                        Select Character & Join Event
                                    </span>
                                </span>
                                <div class="four-t-entry-btn-glow"></div>
                            </button>

                            <button @click="refreshData()" class="four-t-entry-btn-secondary">
                                <i class="fas fa-sync-alt"></i>
                                <span data-translate="page.4t-app.actions.refresh">Refresh Status</span>
                            </button>
                        </div>

                        <!-- Entry Tip -->
                        <div class="four-t-entry-tip">
                            <i class="fas fa-info-circle"></i>
                            <span data-translate="page.4t-app.tips.eventEntry">
                                Tip: Make sure your character is online and ready for the ultimate gaming experience!
                            </span>
                        </div>
                    </div>
                </div>
            </div>

        @elseif($stats === 'char does not belong to user')
            <!-- Character Access Denied with Enhanced Character Card -->
            <div class="four-t-character-showcase four-t-slide-up">

                <!-- Enhanced Character Card -->
                <div class="four-t-enhanced-character-card access-denied">
                    <!-- Card Header with Status -->
                    <div class="four-t-card-header">
                        <div class="four-t-status-indicator error">
                            <div class="four-t-status-pulse"></div>
                            <i class="fas fa-shield-alt"></i>
                        </div>
                        <div class="four-t-card-title">
                            <h2 data-translate="page.4t-app.status.charNotBelongToUser.title">Access Denied</h2>
                            <span class="four-t-card-subtitle">4T Event Participant</span>
                        </div>
                    </div>

                    <!-- Character Display Section -->
                    <div class="four-t-character-display">
                        <div class="four-t-character-frame locked">
                            <div class="four-t-character-avatar-container">
                                @if($currentCharacterAvatar)
                                    <img src="{{ $currentCharacterAvatar }}" alt="{{ $charInfo->Charname ?? 'Character' }}" class="four-t-character-avatar">
                                    <div class="four-t-avatar-lock-overlay">
                                        <i class="fas fa-lock"></i>
                                    </div>
                                @else
                                    <div class="four-t-character-placeholder locked">
                                        <i class="fas fa-user-slash"></i>
                                    </div>
                                @endif

                                <!-- Animated Border Rings -->
                                <div class="four-t-avatar-rings">
                                    <div class="four-t-ring ring-1 error"></div>
                                    <div class="four-t-ring ring-2 error"></div>
                                </div>
                            </div>

                            <div class="four-t-character-info">
                                <h3 class="four-t-character-name error-state">
                                    {{ $charInfo->Charname ?? 'Unknown Character' }}
                                </h3>
                                <div class="four-t-character-status error">
                                    <i class="fas fa-exclamation-triangle"></i>
                                    <span wire:ignore data-translate="page.4t-app.status.accessRestricted">Access Restricted</span>
                                </div>
                            </div>
                        </div>

                        <!-- Event Information -->
                        <div class="four-t-event-details error-state">
                            <div class="four-t-event-header">
                                <i class="fas fa-mobile-alt"></i>
                                <span>4T Mobile Event</span>
                            </div>
                            <div class="four-t-event-message" data-translate="page.4t-app.status.charNotBelongToUser.description">
                                The selected character does not belong to your account. Please verify your character selection or contact support.
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="four-t-card-actions">
                        <button @click="refreshData()" class="four-t-btn four-t-btn-primary pulse">
                            <i class="fas fa-sync-alt"></i>
                            <span data-translate="page.4t-app.actions.refreshData">Refresh Data</span>
                        </button>

                        @if(count($ChooseAnotherChar) > 0)
                            <button @click="openCharacterSelector()" class="four-t-btn four-t-btn-secondary">
                                <i class="fas fa-exchange-alt"></i>
                                <span data-translate="page.4t-app.switchCharacter">Switch Character</span>
                            </button>
                        @endif

                    </div>
                </div>

            </div>

        @elseif($stats === 'char belong to user' && $charInfo)
            <!-- Character Verified - Enhanced Character Card -->
            <div class="four-t-character-showcase four-t-slide-up">

                <!-- Enhanced Character Card with Timer State -->
                <div class="four-t-enhanced-character-card {{ $isTimerStarted ? 'waiting-state' : 'verified' }}">

                    <!-- Card Header with Status -->
                    <div class="four-t-card-header">
                        <div class="four-t-status-indicator {{ $isTimerStarted ? 'waiting' : 'success' }}">
                            <div class="four-t-status-pulse"></div>
                            <i class="fas {{ $isTimerStarted ? 'fa-hourglass-half' : 'fa-check-circle' }}"></i>
                        </div>
                        <div class="four-t-card-title">
                            <h2 data-translate="page.4t-app.{{ $isTimerStarted ? 'eventWaiting' : 'characterVerified' }}">
                                {{ $isTimerStarted ? 'Event Starting Soon' : 'Character Verified' }}
                            </h2>
                            <span class="four-t-card-subtitle">{{ $isTimerStarted ? '4T Event Countdown' : '4T Event Active' }}</span>
                        </div>
                    </div>

                    <!-- Timer/Event Status -->
                    @if($isTimerStarted && $timer)
                        <!-- Countdown Timer Section -->
                        <div class="four-t-countdown-container">
                            <!-- Animated Countdown Background -->
                            <div class="four-t-countdown-bg-elements">
                                <div class="four-t-countdown-particle"></div>
                                <div class="four-t-countdown-particle"></div>
                                <div class="four-t-countdown-particle"></div>
                            </div>

                            <!-- Main Countdown Display -->
                            <div class="four-t-countdown-display">
                                <div class="four-t-countdown-icon-container">
                                    <div class="four-t-countdown-icon-bg">
                                        <i class="fas fa-clock four-t-countdown-icon"></i>
                                    </div>
                                    <div class="four-t-countdown-rings">
                                        <div class="four-t-countdown-ring ring-1"></div>
                                        <div class="four-t-countdown-ring ring-2"></div>
                                        <div class="four-t-countdown-ring ring-3"></div>
                                    </div>
                                </div>

                                <div class="four-t-countdown-content">
                                    <div class="four-t-countdown-title" data-translate="page.4t-app.eventStartingSoon">
                                        Event Starting Soon!
                                    </div>

                                    <!-- Real Time Countdown -->
                                    <!-- Real Time Countdown -->
                                    <div class="four-t-countdown-timer"
                                         x-data="{
                                             endTime: new Date('{{ Carbon::parse($charInfo->Start)->toISOString() }}').getTime(),
                                             serverStartTime: new Date('{{ Carbon::now()->toISOString() }}').getTime(),
                                             clientStartTime: Date.now(),
                                             timeLeft: null,
                                             intervalId: null,
                                             updateTimer() {
                                                 // Calculate elapsed time since initialization
                                                 const elapsedTime = Date.now() - this.clientStartTime;

                                                 // Calculate current server time: Server Start Time + Elapsed Time
                                                 const currentServerTime = this.serverStartTime + elapsedTime;

                                                 // Calculate remaining time: End Time - Current Server Time
                                                 const distance = this.endTime - currentServerTime;

                                                 if (distance > 0) {
                                                     const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                                                     const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                                                     const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                                                     const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                                                     this.timeLeft = {
                                                         days: days.toString().padStart(2, '0'),
                                                         hours: hours.toString().padStart(2, '0'),
                                                         minutes: minutes.toString().padStart(2, '0'),
                                                         seconds: seconds.toString().padStart(2, '0')
                                                     };
                                                 } else {
                                                     // Timer ended, clear interval and refresh the page
                                                     if (this.intervalId) {
                                                         clearInterval(this.intervalId);
                                                         this.intervalId = null;
                                                     }
                                                     // Refresh the page to update the interface
                                                     setTimeout(() => {
                                                         window.location.reload();
                                                     }, 1000);
                                                 }
                                             },
                                             init() {
                                                 // Initialize timer immediately
                                                 this.updateTimer();
                                                 // Set interval and store ID for cleanup
                                                 this.intervalId = setInterval(() => this.updateTimer(), 1000);
                                             },
                                             destroy() {
                                                 // Clean up interval when component is destroyed
                                                 if (this.intervalId) {
                                                     clearInterval(this.intervalId);
                                                     this.intervalId = null;
                                                 }
                                             }
                                         }"
                                         x-init="init()"
                                         @destroy.window="destroy()">                                        <template x-if="timeLeft">
                                            <div class="four-t-time-units">
                                                <div class="four-t-time-unit" x-show="parseInt(timeLeft.days) > 0">
                                                    <div class="four-t-time-number" x-text="timeLeft.days"></div>
                                                    <div class="four-t-time-label" data-translate="page.4t-app.days">Days</div>
                                                </div>
                                                <div class="four-t-time-unit">
                                                    <div class="four-t-time-number" x-text="timeLeft.hours"></div>
                                                    <div class="four-t-time-label" data-translate="page.4t-app.hours">Hours</div>
                                                </div>
                                                <div class="four-t-time-unit">
                                                    <div class="four-t-time-number" x-text="timeLeft.minutes"></div>
                                                    <div class="four-t-time-label" data-translate="page.4t-app.minutes">Minutes</div>
                                                </div>
                                                <div class="four-t-time-unit">
                                                    <div class="four-t-time-number" x-text="timeLeft.seconds"></div>
                                                    <div class="four-t-time-label" data-translate="page.4t-app.seconds">Seconds</div>
                                                </div>
                                            </div>
                                        </template>
                                    </div>

                                    <div class="four-t-countdown-message" data-translate="page.4t-app.eventWillStart">
                                        Your event will start automatically at the scheduled time
                                    </div>
                                </div>
                            </div>
                        </div>
                    @else
                        <!-- Active Event Status -->
                        <div class="four-t-event-timer active">
                            <div class="four-t-timer-icon active">
                                <i class="fas fa-play-circle"></i>
                            </div>
                            <div class="four-t-timer-content">
                                <div class="four-t-timer-text" data-translate="page.4t-app.eventIsRunning">
                                    Event is currently running!
                                </div>
                                <div class="four-t-timer-description" data-translate="page.4t-app.useAppNow">
                                    You can now use the 4T mobile application in-game and on the website!
                                </div>
                            </div>
                        </div>
                    @endif

                    <!-- Character Display Section -->
                    <div class="four-t-character-display {{ $isTimerStarted ? 'waiting-mode' : '' }}">
                        <div class="four-t-character-frame {{ $isTimerStarted ? 'waiting' : 'verified' }}">
                            <div class="four-t-character-avatar-container">
                                @if($currentCharacterAvatar)
                                    <img src="{{ $currentCharacterAvatar }}" alt="{{ $charInfo->Charname }}" class="four-t-character-avatar {{ $isTimerStarted ? 'waiting' : '' }}">
                                @else
                                    <div class="four-t-character-placeholder {{ $isTimerStarted ? 'waiting' : 'verified' }}">
                                        <i class="fas fa-user"></i>
                                    </div>
                                @endif

                                <!-- Animated Border Rings -->
                                <div class="four-t-avatar-rings">
                                    <div class="four-t-ring ring-1 {{ $isTimerStarted ? 'waiting' : 'success' }}"></div>
                                    <div class="four-t-ring ring-2 {{ $isTimerStarted ? 'waiting' : 'success' }}"></div>
                                    <div class="four-t-ring ring-3 {{ $isTimerStarted ? 'waiting' : 'success' }}"></div>
                                </div>
                            </div>

                            <div class="four-t-character-info">
                                <h3 class="four-t-character-name {{ $isTimerStarted ? 'waiting-state' : 'verified-state' }}">
                                    {{ $charInfo->Charname }}
                                </h3>
                                <div class="four-t-character-status {{ $isTimerStarted ? 'waiting' : 'success' }}">
                                    <i class="fas {{ $isTimerStarted ? 'fa-hourglass-half' : 'fa-play-circle' }}"></i>
                                    <span data-translate="page.4t-app.{{ $isTimerStarted ? 'waitingForEvent' : 'participating' }}">
                                        {{ $isTimerStarted ? 'Waiting for Event' : 'Participating in Event' }}
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Action Buttons -->
                    <div class="four-t-card-actions">
                        <button @click="refreshData()" class="four-t-btn four-t-btn-primary">
                            <i class="fas fa-sync-alt"></i>
                            <span data-translate="page.4t-app.refresh">Refresh Data</span>
                        </button>

                        @if(count($ChooseAnotherChar) > 0)
                            <button @click="openCharacterSelector()" class="four-t-btn four-t-btn-secondary">
                                <i class="fas fa-exchange-alt"></i>
                                <span data-translate="page.4t-app.switchCharacter">Switch Character</span>
                            </button>
                        @endif
                    </div>
                </div>

                <!-- Event Statistics Card -->
                <div class="four-t-stats-card four-t-slide-up" style="animation-delay: 0.2s;">
                    <div class="four-t-stats-header">
                        <i class="fas fa-chart-line"></i>
                        <h3 data-translate="page.4t-app.eventStats">Event Statistics</h3>
                    </div>

                    <div class="four-t-stats-content">
                        <div class="four-t-stat-item">
                            <span class="four-t-stat-label" data-translate="page.4t-app.startDate">Event Start Date:</span>
                            <span class="four-t-stat-value">{{ Carbon::parse($charInfo->Start)->format('Y-m-d g:i A') }}</span>
                        </div>
                        <div class="four-t-stat-item">
                            <span class="four-t-stat-label" data-translate="page.4t-app.daysSinceStart">Days Since Event Start:</span>
                            <span class="four-t-stat-value">{{ (int) Carbon::parse($charInfo->Start)->diffInDays(Carbon::now()) }}</span>
                        </div>
                    </div>

                    <div class="four-t-stats-actions">
                        <a href="#" class="four-t-btn four-t-btn-secondary">
                            <i class="fas fa-chart-line"></i>
                            <span data-translate="page.4t-app.actions.viewDetails">View Event Details</span>
                        </a>
                    </div>
                </div>

            </div>

        @else
            <!-- Default State -->
            <div class="four-t-status-message four-t-slide-up">
                <div class="four-t-status-icon">
                    <i class="fas fa-mobile-alt" style="color: var(--color-game-purple-400);"></i>
                </div>
                <h2 class="four-t-status-title" data-translate="page.4t-app.noCharacter">
                    No Character Selected
                </h2>
                <p class="four-t-status-description" data-translate="page.4t-app.notParticipating">
                    You are not currently participating in the 4T event
                </p>
                <div class="four-t-action-buttons">
                    <button @click="refreshData()" class="four-t-btn four-t-btn-primary">
                        <i class="fas fa-sync-alt"></i>
                        <span data-translate="page.4t-app.actions.refreshData">Refresh Application Data</span>
                    </button>
                </div>
            </div>
        @endif

    </div>

    <!-- Character Selector Modal -->
    @if(count($ChooseAnotherChar) > 0)
        <div x-show="showCharacterSelector"
             x-transition:enter="transition ease-out duration-300"
             x-transition:enter-start="opacity-0"
             x-transition:enter-end="opacity-100"
             x-transition:leave="transition ease-in duration-200"
             x-transition:leave-start="opacity-100"
             x-transition:leave-end="opacity-0"
             class="fixed inset-0 z-50 flex items-center justify-content-center p-4"
             style="background: rgba(0, 0, 0, 0.85); backdrop-filter: blur(8px);">

            <div x-show="showCharacterSelector"
                 x-transition:enter="transition ease-out duration-300 transform"
                 x-transition:enter-start="opacity-0 scale-95"
                 x-transition:enter-end="opacity-100 scale-100"
                 x-transition:leave="transition ease-in duration-200 transform"
                 x-transition:leave-start="opacity-100 scale-100"
                 x-transition:leave-end="opacity-0 scale-95"
                 class="four-t-character-selector-modal max-w-4xl w-full max-h-[90vh] overflow-y-auto"
                 @click.away="showCharacterSelector = false">

                <!-- Modal Header -->
                <div class="four-t-modal-header">
                    <div class="four-t-modal-title">
                        <i class="fas fa-users"></i>
                        <h3 data-translate="page.4t-app.selectNewCharacter">Select New Character</h3>
                    </div>
                    <button @click="showCharacterSelector = false" class="four-t-modal-close">
                        <i class="fas fa-times"></i>
                    </button>
                </div>

                <!-- Modal Body -->
                <div class="four-t-modal-body">
                    <div class="four-t-modal-description">
                        <i class="fas fa-info-circle"></i>
                        <p data-translate="page.4t-app.selectCharacterDescription">
                            Choose a character to participate in the 4T event. The selected character must be online and available.
                        </p>
                    </div>

                    <!-- Characters Grid -->
                    <div class="four-t-characters-grid" x-show="!$wire.refreshingChars">
                        @foreach($ChooseAnotherChar as $char)
                            <div class="four-t-character-card-option"
                                 :class="{ 'selected': selectedCharacter === {{ $char['CharID'] ?? 0 }} }"
                                 @click="selectCharacter({{ $char['CharID'] ?? 0 }})">

                                <!-- Character Avatar -->
                                <div class="four-t-char-option-avatar">
                                    {{-- get avatar by Charname --}}
                                    @php
                                        // Assuming Char::getCharAvatarGifByCharname is a method to get avatar URL
                                        $avatarUrl = Char::getCharAvatarGifByCharname($char['Charname']) ?? null;
                                        $char['Avatar'] = $avatarUrl;
                                    @endphp
                                    @if(isset($char['Avatar']) && $char['Avatar'])
                                        <img src="{{ $char['Avatar'] }}" alt="{{ $char['Charname'] ?? 'Character' }}">
                                    @else
                                        <div class="four-t-char-placeholder">
                                            <i class="fas fa-user"></i>
                                        </div>
                                    @endif

                                    <!-- Selection Indicator -->
                                    <div class="four-t-selection-indicator">
                                        <i class="fas fa-check"></i>
                                    </div>
                                </div>

                                <!-- Character Info -->
                                <div class="four-t-char-option-info">
                                    <h4 class="four-t-char-option-name">
                                        {{ $char['Charname'] ?? 'Unknown Character' }}
                                    </h4>

                                    <!-- Character Status -->
                                    <div class="four-t-char-status available">
                                        <i class="fas fa-circle"></i>
                                        <span>Available</span>
                                    </div>
                                </div>

                                <!-- Hover Effect -->
                                <div class="four-t-card-hover-effect"></div>
                            </div>
                        @endforeach
                    </div>

                    <!-- Loading State for Characters Refresh -->
                    <div class="four-t-characters-loading" x-show="$wire.refreshingChars">
                        <div class="four-t-loading-spinner"></div>
                        <div class="four-t-loading-text">
                            <i class="fas fa-sync-alt fa-spin"></i>
                            <span data-translate="4tApp.loading.refreshingCharacters">Refreshing available characters...</span>
                        </div>
                    </div>
                </div>

                <!-- Modal Footer -->
                <div class="four-t-modal-footer">
                    <div class="four-t-modal-actions">
                        <button @click="showCharacterSelector = false" class="four-t-btn four-t-btn-secondary">
                            <i class="fas fa-times"></i>
                            <span data-translate="page.4t-app.cancel">Cancel</span>
                        </button>

                        <button x-show="selectedCharacter"
                                @click="confirmCharacterSelection()"
                                class="four-t-btn four-t-btn-primary">
                            <i class="fas fa-check"></i>
                            <span data-translate="page.4t-app.confirmSelection">Confirm Selection</span>
                        </button>
                    </div>

                    <div class="four-t-selection-info" x-show="selectedCharacter">
                        <i class="fas fa-info-circle"></i>
                        <span data-translate="4tApp.alerts.characterSelectionInfo">Character selected. Click "Confirm Selection" to proceed with event participation.</span>
                    </div>
                </div>
            </div>
        </div>
    @endif

{{-- Debug show server time --}}
<div>
    <strong>Server Time:</strong> {{ Carbon::now()->format('Y-m-d H:i:s') }}
</div>
</div>
