{{-- Anti-Flash Language Layout Template --}}
<!DOCTYPE html>
<html lang="{{ LanguageHelper::determineUserLanguage() }}"
      dir="{{ BladeTranslationHelper::getCurrentLanguageMeta()['dir'] }}"
      class="language-preload">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    {{-- Language meta tags --}}
    {!! LanguageHelper::generateLanguageMetaTags() !!}

    <title>{{ LanguageHelper::trans('meta.title') }} - {{ LanguageHelper::trans('meta.siteName') }}</title>

    {{-- Critical CSS to prevent flash - MUST be inline --}}
    {!! BladeTranslationHelper::generateCriticalCSS() !!}

    {{-- Preload critical translations --}}
    {!! LanguageHelper::generatePreloadScript(['meta', 'common', 'navigation', 'hero']) !!}

    {{-- Your app CSS files --}}
    @vite(['resources/css/app.css', 'resources/css/language-loading.css'])

    @stack('head-scripts')
</head>
<body>
    {{-- Navigation --}}
    <nav class="navbar">
        <div class="nav-brand">
            <h1 data-translate="meta.siteName">{{ LanguageHelper::trans('meta.siteName') }}</h1>
        </div>

        <div class="nav-menu">
            <a href="{{ route('home') }}" data-translate="navigation.home">{{ LanguageHelper::trans('navigation.home') }}</a>
            <a href="{{ route('about') }}" data-translate="navigation.about">{{ LanguageHelper::trans('navigation.about') }}</a>
            <a href="{{ route('contact') }}" data-translate="navigation.contact">{{ LanguageHelper::trans('navigation.contact') }}</a>

            {{-- Language switcher will be generated by JavaScript --}}
            <div class="language-switcher"></div>
        </div>
    </nav>

    {{-- Main content --}}
    <main>
        @yield('content')
    </main>

    {{-- Footer --}}
    <footer class="footer">
        <div class="footer-content">
            <p data-translate="meta.copyright">{{ LanguageHelper::trans('meta.copyright') }}</p>
            <div class="footer-links">
                <a href="{{ route('privacy') }}" data-translate="navigation.privacy">{{ LanguageHelper::trans('navigation.privacy') }}</a>
                <a href="{{ route('terms') }}" data-translate="navigation.terms">{{ LanguageHelper::trans('navigation.terms') }}</a>
            </div>
        </div>
    </footer>

    {{-- Load JavaScript after DOM is ready --}}
    @vite(['resources/js/app.js', 'resources/js/components/smart-translations.js'])

    {{-- Additional page scripts --}}
    @stack('scripts')

    {{-- Language system optimization --}}
    <script>
        // Additional optimization for this page
        document.addEventListener('DOMContentLoaded', function() {
            // Load page-specific language sections if needed
            if (window.loadPageSections) {
                window.loadPageSections(@json($pageLanguageSections ?? []));
            }

            // Page-specific language preservations
            @if(isset($preserveLanguageOn))
            @foreach($preserveLanguageOn as $event)
            document.addEventListener('{{ $event }}', function() {
                if (window.preserveLanguage) {
                    window.preserveLanguage();
                }
            });
            @endforeach
            @endif
        });
    </script>
</body>
</html>
