@extends('layouts.app')

@section('title', 'Character Inventory - ' . $character->CharName16)

@section('content')
<div class="min-h-screen bg-gradient-to-br from-slate-900 via-purple-900 to-slate-900">
    <div class="container mx-auto px-4 py-8">
        <!-- Character Header -->
        <div class="text-center mb-8">
            <h1 class="text-4xl font-bold text-white mb-2">
                {{ $character->CharName16 }}'s Equipment
            </h1>
            <p class="text-slate-300">Character ID: {{ $character->CharID }}</p>
            <p class="text-slate-400">Level {{ $character->CurLevel ?? 1 }} - Job {{ $character->JobType ?? 0 }}</p>
        </div>

        <!-- Inventory Component -->
        <div class="flex justify-center">
            <x-silkroad-inventory
                :char-id="$character->CharID"
                :items="$equipment"
            />
        </div>

        <!-- Additional Character Info -->
        <div class="mt-8 bg-slate-800/50 backdrop-blur-sm border border-slate-700 rounded-lg p-6 max-w-2xl mx-auto">
            <h3 class="text-xl font-semibold text-white mb-4">Character Information</h3>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                <div>
                    <span class="text-slate-400">Name:</span>
                    <span class="text-white ml-2">{{ $character->CharName16 }}</span>
                </div>
                <div>
                    <span class="text-slate-400">Level:</span>
                    <span class="text-white ml-2">{{ $character->CurLevel ?? 1 }}</span>
                </div>
                <div>
                    <span class="text-slate-400">Experience:</span>
                    <span class="text-white ml-2">{{ number_format($character->ExpOffset ?? 0) }}</span>
                </div>
                <div>
                    <span class="text-slate-400">Gold:</span>
                    <span class="text-yellow-400 ml-2">{{ number_format($character->RemainGold ?? 0) }}</span>
                </div>
                <div>
                    <span class="text-slate-400">HP:</span>
                    <span class="text-red-400 ml-2">{{ $character->HP ?? 0 }}</span>
                </div>
                <div>
                    <span class="text-slate-400">MP:</span>
                    <span class="text-blue-400 ml-2">{{ $character->MP ?? 0 }}</span>
                </div>
            </div>
        </div>

        <!-- Back Button -->
        <div class="text-center mt-8">
            <a href="{{ url()->previous() }}"
               class="inline-flex items-center px-6 py-3 bg-purple-600 hover:bg-purple-700 text-white font-medium rounded-lg transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Characters
            </a>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Optional: Add any custom JavaScript for inventory interactions
document.addEventListener('DOMContentLoaded', function() {
    // Add hover effects or click handlers for inventory items
    const inventorySlots = document.querySelectorAll('.inventory-slot');

    inventorySlots.forEach(slot => {
        slot.addEventListener('mouseenter', function() {
            const slotName = this.dataset.slotName;
            if (slotName) {
                console.log('Hovering over slot:', slotName);
            }
        });
    });
});
</script>
@endpush
@endsection
