{{-- Example page using anti-flash language system --}}
@extends('layouts.anti-flash')

@section('content')
{{-- Hero Section --}}
<section class="hero-section">
    <div class="hero-content">
        <h1 data-translate="hero.title">{{ LanguageHelper::trans('hero.title') }}</h1>
        <p data-translate="hero.subtitle">{{ LanguageHelper::trans('hero.subtitle') }}</p>
        <p data-translate="hero.description">{{ LanguageHelper::trans('hero.description') }}</p>

        <div class="hero-actions">
            <button class="btn btn-primary" data-translate="common.getStarted">
                {{ LanguageHelper::trans('common.getStarted') }}
            </button>
            <button class="btn btn-secondary" data-translate="common.learnMore">
                {{ LanguageHelper::trans('common.learnMore') }}
            </button>
        </div>
    </div>
</section>

{{-- Features Section --}}
<section class="features-section">
    <div class="container">
        <h2 data-translate="pages.home.features.title">{{ LanguageHelper::trans('pages.home.features.title') }}</h2>

        <div class="features-grid">
            @for($i = 1; $i <= 3; $i++)
            <div class="feature-card">
                <h3 data-translate="pages.home.features.feature{{ $i }}.title">
                    {{ LanguageHelper::trans("pages.home.features.feature{$i}.title") }}
                </h3>
                <p data-translate="pages.home.features.feature{{ $i }}.description">
                    {{ LanguageHelper::trans("pages.home.features.feature{$i}.description") }}
                </p>
            </div>
            @endfor
        </div>
    </div>
</section>

{{-- Statistics Section --}}
<section class="stats-section">
    <div class="container">
        <h2 data-translate="pages.home.stats.title">{{ LanguageHelper::trans('pages.home.stats.title') }}</h2>

        <div class="stats-grid">
            <div class="stat-item">
                <div class="stat-number">99.9%</div>
                <div class="stat-label" data-translate="pages.home.stats.uptime">
                    {{ LanguageHelper::trans('pages.home.stats.uptime') }}
                </div>
            </div>
            <div class="stat-item">
                <div class="stat-number">< 50ms</div>
                <div class="stat-label" data-translate="pages.home.stats.loadTime">
                    {{ LanguageHelper::trans('pages.home.stats.loadTime') }}
                </div>
            </div>
            <div class="stat-item">
                <div class="stat-number">7</div>
                <div class="stat-label" data-translate="pages.home.stats.languages">
                    {{ LanguageHelper::trans('pages.home.stats.languages') }}
                </div>
            </div>
        </div>
    </div>
</section>

{{-- Call to Action --}}
<section class="cta-section">
    <div class="container">
        <h2 data-translate="pages.home.cta.title">{{ LanguageHelper::trans('pages.home.cta.title') }}</h2>
        <p data-translate="pages.home.cta.description">{{ LanguageHelper::trans('pages.home.cta.description') }}</p>

        <div class="cta-actions">
            <a href="{{ route('register') }}" class="btn btn-primary" data-translate="common.signUp">
                {{ LanguageHelper::trans('common.signUp') }}
            </a>
            <a href="{{ route('demo') }}" class="btn btn-outline" data-translate="common.tryDemo">
                {{ LanguageHelper::trans('common.tryDemo') }}
            </a>
        </div>
    </div>
</section>
@endsection

@push('head-scripts')
<script>
    // Page-specific language configuration
    window.pageLanguageConfig = {
        sections: ['hero', 'pages', 'common'],
        preserveOn: ['form-submit', 'ajax-complete'],
        enableProgressiveLoading: true
    };
</script>
@endpush

@push('scripts')
<script>
    // Page-specific optimizations
    document.addEventListener('DOMContentLoaded', function() {
        // Progressive loading for non-critical content
        if (window.languageManager && window.languageManager.initialLoadComplete) {
            // Load additional sections for this page
            window.loadPageSections(['pages', 'hero']);
        }

        // Handle form submissions with language preservation
        document.querySelectorAll('form').forEach(form => {
            form.addEventListener('submit', function() {
                // Preserve language during form submission
                setTimeout(() => {
                    if (window.preserveLanguage) {
                        window.preserveLanguage();
                    }
                }, 100);
            });
        });
    });
</script>
@endpush

@php
    // Pass configuration to layout
    $pageLanguageSections = ['hero', 'pages', 'common'];
    $preserveLanguageOn = ['form-submit', 'livewire:load'];
@endphp
