<!-- Desktop Dashboard Alpine.js Animation Example -->
<!-- This is an example of how to use Alpine.js with the new desktop dashboard styles -->

<div x-data="desktopDashboard()" x-init="init()" class="desktop-dashboard-wrapper">

    <!-- Example of Alpine.js integration with desktop dashboard -->
    <div class="desktop-dashboard-container">

        <!-- Desktop Sidebar with Alpine.js -->
        <div class="desktop-dashboard-sidebar desktop-dashboard-sidebar-glow"
             x-show="sidebarVisible"
             x-transition:enter="desktop-slide-enter"
             x-transition:enter-active="desktop-slide-enter-active"
             x-transition:leave-active="desktop-slide-leave-active">

            <!-- Animated Header -->
            <div class="desktop-dashboard-header desktop-fade-in"
                 x-show="headerLoaded"
                 x-transition:enter="desktop-fade-enter"
                 x-transition:enter-active="desktop-fade-enter-active">
                <div class="desktop-dashboard-header-content">
                    <div class="desktop-dashboard-header-icon">
                        <i class="fas fa-tachometer-alt text-white text-2xl"></i>
                    </div>
                    <div class="desktop-dashboard-header-text">
                        <h1 data-translate="dashboard.title">Dashboard</h1>
                        <p data-translate="dashboard.subtitle">Control Panel & Management System</p>
                    </div>
                </div>
            </div>

            <!-- Animated Menu Items -->
            <nav class="desktop-dashboard-nav">
                <template x-for="(item, index) in menuItems" :key="index">
                    <button @click="selectMenuItem(item)"
                            class="desktop-dashboard-menu-item desktop-tooltip desktop-glow-effect"
                            :class="{ 'active': activeItem === item.key }"
                            x-show="item.visible"
                            x-transition:enter="desktop-scale-enter"
                            x-transition:enter-active="desktop-scale-enter-active"
                            :data-tooltip="item.subtitle"
                            x-transition.delay.100ms>
                        <div class="desktop-dashboard-menu-content">
                            <div class="desktop-dashboard-menu-icon"
                                 :class="{ 'active': activeItem === item.key }">
                                <i :class="item.icon"></i>
                            </div>
                            <div class="desktop-dashboard-menu-text">
                                <span class="desktop-dashboard-menu-title" x-text="item.title"></span>
                                <p class="desktop-dashboard-menu-subtitle" x-text="item.subtitle"></p>
                            </div>
                            <i class="fas fa-chevron-right desktop-dashboard-menu-arrow"
                               :class="{ 'active': activeItem === item.key }"></i>
                        </div>
                    </button>
                </template>
            </nav>
        </div>

        <!-- Desktop Content with Animation -->
        <div class="desktop-dashboard-content">

            <!-- Animated Top Bar -->
            <div class="desktop-dashboard-topbar"
                 x-show="topbarVisible"
                 x-transition:enter="desktop-fade-enter"
                 x-transition:enter-active="desktop-fade-enter-active">
                <div class="desktop-dashboard-topbar-content">
                    <div class="desktop-dashboard-topbar-left">
                        <h1 x-text="currentPageTitle" data-translate="page.current.title"></h1>
                        <p x-text="currentPageDescription" data-translate="page.current.description"></p>
                    </div>
                    <div class="desktop-dashboard-topbar-actions">
                        <!-- Animated Buttons -->
                        <button @click="showNotifications = !showNotifications"
                                class="desktop-dashboard-topbar-button desktop-tooltip"
                                data-tooltip="Notifications"
                                x-transition.hover>
                            <i class="fas fa-bell text-xl"></i>
                            <span x-show="newNotifications > 0"
                                  class="notification-badge"
                                  x-text="newNotifications"
                                  x-transition:enter="desktop-scale-enter"
                                  x-transition:enter-active="desktop-scale-enter-active"></span>
                        </button>

                        <button @click="showSettings = !showSettings"
                                class="desktop-dashboard-topbar-button desktop-tooltip"
                                data-tooltip="Settings"
                                x-transition.hover>
                            <i class="fas fa-cog text-xl"></i>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Main Content with Smooth Transitions -->
            <div class="desktop-dashboard-page">
                <div class="max-w-7xl mx-auto">
                    <div class="desktop-dashboard-main-card"
                         x-show="contentLoaded"
                         x-transition:enter="desktop-scale-enter"
                         x-transition:enter-active="desktop-scale-enter-active">

                        <!-- Dynamic Content Based on Active Item -->
                        <div x-show="activeItem === '4t-app'"
                             x-transition:enter="desktop-fade-enter"
                             x-transition:enter-active="desktop-fade-enter-active"
                             x-transition:leave-active="desktop-fade-leave-active">
                            <!-- 4T App Content -->
                            <h2 data-translate="page.4t-app.title">4T Mobile Application Manager</h2>
                            <p data-translate="page.4t-app.description">Advanced mobile application event management system</p>
                        </div>

                        <div x-show="activeItem === 'quests'"
                             x-transition:enter="desktop-fade-enter"
                             x-transition:enter-active="desktop-fade-enter-active"
                             x-transition:leave-active="desktop-fade-leave-active">
                            <!-- Quests Content -->
                            <h2 data-translate="page.quests.title">Quest Management System</h2>
                            <p data-translate="page.quests.description">Comprehensive quest and mission management</p>
                        </div>

                        <!-- Add more content sections as needed -->

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function desktopDashboard() {
    return {
        // State Management
        sidebarVisible: true,
        headerLoaded: false,
        topbarVisible: false,
        contentLoaded: false,
        activeItem: '4t-app',
        showNotifications: false,
        showSettings: false,
        newNotifications: 3,

        // Menu Items Data
        menuItems: [
            {
                key: '4t-app',
                title: '4T App',
                subtitle: 'Mobile Application',
                icon: 'fas fa-mobile-alt',
                visible: false
            },
            {
                key: 'quests',
                title: 'Quests',
                subtitle: 'Mission Management',
                icon: 'fas fa-tasks',
                visible: false
            },
            {
                key: 'char-list',
                title: 'Character List',
                subtitle: 'Characters Overview',
                icon: 'fas fa-users',
                visible: false
            }
            // Add more menu items...
        ],

        // Computed Properties
        get currentPageTitle() {
            const item = this.menuItems.find(item => item.key === this.activeItem);
            return item ? item.title + ' Management' : 'Dashboard';
        },

        get currentPageDescription() {
            const item = this.menuItems.find(item => item.key === this.activeItem);
            return item ? item.subtitle + ' System' : 'Management System';
        },

        // Initialization
        init() {
            // Staggered Animation Loading
            setTimeout(() => {
                this.headerLoaded = true;
            }, 200);

            setTimeout(() => {
                this.topbarVisible = true;
            }, 400);

            setTimeout(() => {
                this.contentLoaded = true;
            }, 600);

            // Show menu items with staggered animation
            this.menuItems.forEach((item, index) => {
                setTimeout(() => {
                    item.visible = true;
                }, 800 + (index * 150));
            });

            // Initialize language translation system
            this.initTranslations();
        },

        // Methods
        selectMenuItem(item) {
            if (this.activeItem !== item.key) {
                // Add loading animation
                this.contentLoaded = false;

                setTimeout(() => {
                    this.activeItem = item.key;
                    this.contentLoaded = true;

                    // Emit custom event for Livewire integration
                    this.$dispatch('page-changed', { page: item.key });
                }, 200);
            }
        },

        initTranslations() {
            // Initialize translation system integration
            if (window.languageSystem) {
                window.languageSystem.translatePage();
            }
        },

        // Animation Helpers
        animateElement(element, animation) {
            element.classList.add(animation);
            element.addEventListener('animationend', () => {
                element.classList.remove(animation);
            }, { once: true });
        }
    }
}
</script>

<style>
/* Additional Alpine.js specific animations */
.notification-badge {
    position: absolute;
    top: -8px;
    right: -8px;
    background: linear-gradient(135deg, #ff0054, #ff4081);
    color: white;
    border-radius: 50%;
    width: 20px;
    height: 20px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 0.75rem;
    font-weight: 600;
    box-shadow: 0 4px 12px rgba(255, 0, 84, 0.4);
    animation: badge-pulse 2s infinite;
}

@keyframes badge-pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

/* Hover transition for interactive elements */
[x-transition\.hover] {
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
}

[x-transition\.hover]:hover {
    transform: translateY(-2px);
}
</style>
