{{-- Weekly Competition Event Content --}}
<div class="weekly-competition-event">
    {{-- Event Header --}}
    <div class="event-header">
        <div class="event-icon">
            <i class="fas fa-trophy"></i>
        </div>
        <div class="event-info">
            <h3 class="event-title" data-translate="rewardsSystem.events.weeklyCompetition.title">Weekly Competition</h3>
            <p class="event-description" data-translate="rewardsSystem.events.weeklyCompetition.description">Participate in the competition and win valuable prizes!</p>
        </div>
        <div class="competition-status">
            <span class="status-badge active">LIVE</span>
            <div class="participants-count">
                <i class="fas fa-users"></i>
                <span>1,247 Participants</span>
            </div>
        </div>
    </div>

    {{-- Competition Timer --}}
    <div class="competition-timer">
        <h4 class="timer-title">Competition Ends In:</h4>
        <div class="timer-display">
            <div class="timer-unit">
                <span class="timer-number">2</span>
                <span class="timer-label">Days</span>
            </div>
            <div class="timer-separator">:</div>
            <div class="timer-unit">
                <span class="timer-number">14</span>
                <span class="timer-label">Hours</span>
            </div>
            <div class="timer-separator">:</div>
            <div class="timer-unit">
                <span class="timer-number">32</span>
                <span class="timer-label">Minutes</span>
            </div>
            <div class="timer-separator">:</div>
            <div class="timer-unit">
                <span class="timer-number">15</span>
                <span class="timer-label">Seconds</span>
            </div>
        </div>
    </div>

    {{-- Competition Prizes --}}
    <div class="prizes-section">
        <h4 class="prizes-title" data-translate="rewardsSystem.events.weeklyCompetition.competitionPrizes">Competition Prizes:</h4>

        <div class="prizes-grid">
            {{-- First Place --}}
            <div class="prize-card first-place">
                <div class="prize-rank">
                    <i class="fas fa-crown"></i>
                    <span data-translate="rewardsSystem.events.weeklyCompetition.firstPlace">🥇 First Place</span>
                </div>
                <div class="prize-rewards">
                    <div class="reward-item">
                        <i class="fas fa-gem"></i>
                        <span>5,000 Silk</span>
                    </div>
                    <div class="reward-item">
                        <i class="fas fa-star"></i>
                        <span>VIP Status (30 days)</span>
                    </div>
                    <div class="reward-item">
                        <i class="fas fa-medal"></i>
                        <span>Champion Title</span>
                    </div>
                </div>
            </div>

            {{-- Second Place --}}
            <div class="prize-card second-place">
                <div class="prize-rank">
                    <i class="fas fa-medal"></i>
                    <span data-translate="rewardsSystem.events.weeklyCompetition.secondPlace">🥈 Second Place</span>
                </div>
                <div class="prize-rewards">
                    <div class="reward-item">
                        <i class="fas fa-gem"></i>
                        <span>3,000 Silk</span>
                    </div>
                    <div class="reward-item">
                        <i class="fas fa-star"></i>
                        <span>VIP Status (15 days)</span>
                    </div>
                </div>
            </div>

            {{-- Third Place --}}
            <div class="prize-card third-place">
                <div class="prize-rank">
                    <i class="fas fa-award"></i>
                    <span data-translate="rewardsSystem.events.weeklyCompetition.thirdPlace">🥉 Third Place</span>
                </div>
                <div class="prize-rewards">
                    <div class="reward-item">
                        <i class="fas fa-gem"></i>
                        <span>1,500 Silk</span>
                    </div>
                    <div class="reward-item">
                        <i class="fas fa-star"></i>
                        <span>VIP Status (7 days)</span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    {{-- Leaderboard Preview --}}
    <div class="leaderboard-section">
        <h4 class="leaderboard-title">Current Leaderboard (Top 10)</h4>
        <div class="leaderboard-table">
            <div class="leaderboard-header">
                <span>Rank</span>
                <span>Player</span>
                <span>Points</span>
                <span>Last Activity</span>
            </div>
            <div class="leaderboard-body">
                <div class="leaderboard-row rank-1">
                    <span class="rank">1</span>
                    <span class="player">ShadowWarrior</span>
                    <span class="points">2,847</span>
                    <span class="activity">2 mins ago</span>
                </div>
                <div class="leaderboard-row rank-2">
                    <span class="rank">2</span>
                    <span class="player">DragonSlayer99</span>
                    <span class="points">2,756</span>
                    <span class="activity">5 mins ago</span>
                </div>
                <div class="leaderboard-row rank-3">
                    <span class="rank">3</span>
                    <span class="player">MysticMage</span>
                    <span class="points">2,634</span>
                    <span class="activity">8 mins ago</span>
                </div>
                <div class="leaderboard-row">
                    <span class="rank">4</span>
                    <span class="player">IronKnight</span>
                    <span class="points">2,512</span>
                    <span class="activity">12 mins ago</span>
                </div>
                <div class="leaderboard-row">
                    <span class="rank">5</span>
                    <span class="player">StormArcher</span>
                    <span class="points">2,398</span>
                    <span class="activity">15 mins ago</span>
                </div>
                <div class="leaderboard-row your-rank">
                    <span class="rank">23</span>
                    <span class="player">You</span>
                    <span class="points">1,756</span>
                    <span class="activity">Active</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Competition Rules --}}
    <div class="rules-section">
        <h4 class="rules-title">Competition Rules & Guidelines</h4>
        <div class="rules-content">
            <div class="rule-item">
                <i class="fas fa-check-circle"></i>
                <span>Earn points by completing daily quests and achievements</span>
            </div>
            <div class="rule-item">
                <i class="fas fa-check-circle"></i>
                <span>PvP battles grant bonus points based on opponent level</span>
            </div>
            <div class="rule-item">
                <i class="fas fa-check-circle"></i>
                <span>Guild activities provide additional point multipliers</span>
            </div>
            <div class="rule-item">
                <i class="fas fa-exclamation-triangle"></i>
                <span>Fair play only - cheating results in immediate disqualification</span>
            </div>
        </div>
    </div>

    {{-- Participation Button --}}
    <div class="participation-section">
        <button class="participate-btn" data-translate="rewardsSystem.events.weeklyCompetition.participateNow">
            <i class="fas fa-play"></i>
            <span>Participate in Competition</span>
        </button>
        <p class="participation-note">
            Join now and start earning points! Competition is live for all players level 20+
        </p>
    </div>
</div>

<style>
.weekly-competition-event {
    background: linear-gradient(135deg, rgba(255, 215, 0, 0.1), rgba(255, 69, 0, 0.05));
    border-radius: 16px;
    padding: 2rem;
    border: 1px solid rgba(255, 215, 0, 0.3);
}

.event-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid rgba(255, 215, 0, 0.2);
}

.event-icon {
    width: 4rem;
    height: 4rem;
    background: linear-gradient(135deg, #ffd700, #ff8c00);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    box-shadow: 0 0 20px rgba(255, 215, 0, 0.4);
}

.event-info {
    flex: 1;
}

.event-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    background: linear-gradient(45deg, #ffd700, #ff8c00);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.event-description {
    color: var(--color-text-secondary);
    font-size: 1rem;
}

.competition-status {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
}

.status-badge {
    background: linear-gradient(45deg, #10b981, #059669);
    color: white;
    padding: 0.375rem 0.75rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.875rem;
    box-shadow: 0 0 15px rgba(16, 185, 129, 0.4);
    animation: pulse 2s infinite;
}

.participants-count {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: var(--color-text-secondary);
    font-size: 0.875rem;
}

.competition-timer {
    text-align: center;
    margin-bottom: 2rem;
    background: rgba(22, 33, 62, 0.6);
    border-radius: 12px;
    padding: 1.5rem;
    border: 1px solid rgba(255, 215, 0, 0.2);
}

.timer-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: #ffd700;
}

.timer-display {
    display: flex;
    justify-content: center;
    align-items: center;
    gap: 0.5rem;
}

.timer-unit {
    display: flex;
    flex-direction: column;
    align-items: center;
    background: rgba(255, 215, 0, 0.1);
    border-radius: 8px;
    padding: 0.75rem;
    min-width: 4rem;
    border: 1px solid rgba(255, 215, 0, 0.3);
}

.timer-number {
    font-size: 1.5rem;
    font-weight: 700;
    color: #ffd700;
}

.timer-label {
    font-size: 0.75rem;
    color: var(--color-text-secondary);
    margin-top: 0.25rem;
}

.timer-separator {
    font-size: 1.5rem;
    font-weight: 700;
    color: #ffd700;
}

.prizes-section {
    margin-bottom: 2rem;
}

.prizes-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.prizes-grid {
    display: grid;
    gap: 1rem;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
}

.prize-card {
    border-radius: 12px;
    padding: 1.5rem;
    border: 2px solid;
    transition: all 0.3s;
}

.prize-card.first-place {
    background: linear-gradient(135deg, rgba(255, 215, 0, 0.1), rgba(255, 215, 0, 0.05));
    border-color: #ffd700;
    box-shadow: 0 0 20px rgba(255, 215, 0, 0.3);
}

.prize-card.second-place {
    background: linear-gradient(135deg, rgba(192, 192, 192, 0.1), rgba(192, 192, 192, 0.05));
    border-color: #c0c0c0;
}

.prize-card.third-place {
    background: linear-gradient(135deg, rgba(205, 127, 50, 0.1), rgba(205, 127, 50, 0.05));
    border-color: #cd7f32;
}

.prize-rank {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin-bottom: 1rem;
    font-weight: 700;
    font-size: 1.125rem;
}

.prize-rank i {
    font-size: 1.25rem;
}

.prize-rewards {
    display: flex;
    flex-direction: column;
    gap: 0.5rem;
}

.reward-item {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    color: var(--color-text-secondary);
}

.reward-item i {
    color: var(--color-game-neon-cyan);
}

.leaderboard-section {
    margin-bottom: 2rem;
}

.leaderboard-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.leaderboard-table {
    background: rgba(22, 33, 62, 0.6);
    border-radius: 12px;
    border: 1px solid rgba(168, 85, 247, 0.2);
    overflow: hidden;
}

.leaderboard-header {
    display: grid;
    grid-template-columns: auto 1fr auto auto;
    gap: 1rem;
    padding: 1rem;
    background: rgba(168, 85, 247, 0.1);
    font-weight: 600;
    border-bottom: 1px solid rgba(168, 85, 247, 0.2);
}

.leaderboard-body {
    max-height: 300px;
    overflow-y: auto;
}

.leaderboard-row {
    display: grid;
    grid-template-columns: auto 1fr auto auto;
    gap: 1rem;
    padding: 0.75rem 1rem;
    border-bottom: 1px solid rgba(168, 85, 247, 0.1);
    transition: background 0.3s;
}

.leaderboard-row:hover {
    background: rgba(168, 85, 247, 0.05);
}

.leaderboard-row.rank-1 {
    background: rgba(255, 215, 0, 0.1);
}

.leaderboard-row.rank-2 {
    background: rgba(192, 192, 192, 0.1);
}

.leaderboard-row.rank-3 {
    background: rgba(205, 127, 50, 0.1);
}

.leaderboard-row.your-rank {
    background: rgba(0, 255, 255, 0.1);
    border: 1px solid rgba(0, 255, 255, 0.3);
}

.rank {
    font-weight: 700;
}

.player {
    color: var(--color-text-primary);
    font-weight: 600;
}

.points {
    color: var(--color-game-neon-cyan);
    font-weight: 600;
}

.activity {
    color: var(--color-text-secondary);
    font-size: 0.875rem;
}

.rules-section {
    margin-bottom: 2rem;
}

.rules-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.rules-content {
    display: flex;
    flex-direction: column;
    gap: 0.75rem;
}

.rule-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    color: var(--color-text-secondary);
}

.rule-item i {
    color: var(--color-game-neon-green);
}

.rule-item i.fa-exclamation-triangle {
    color: #f59e0b;
}

.participation-section {
    text-align: center;
}

.participate-btn {
    background: linear-gradient(45deg, #ffd700, #ff8c00);
    color: white;
    border: none;
    padding: 1rem 2rem;
    border-radius: 12px;
    font-size: 1.125rem;
    font-weight: 700;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin: 0 auto 1rem;
    box-shadow: 0 4px 20px rgba(255, 215, 0, 0.3);
}

.participate-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 25px rgba(255, 215, 0, 0.4);
}

.participation-note {
    color: var(--color-text-secondary);
    font-size: 0.875rem;
    margin: 0;
}

@keyframes pulse {
    0%, 100% { opacity: 1; }
    50% { opacity: 0.8; }
}

/* Responsive Design */
@media (max-width: 768px) {
    .timer-display {
        flex-wrap: wrap;
        gap: 0.25rem;
    }

    .timer-unit {
        min-width: 3rem;
        padding: 0.5rem;
    }

    .prizes-grid {
        grid-template-columns: 1fr;
    }

    .leaderboard-header,
    .leaderboard-row {
        grid-template-columns: auto 1fr auto;
        font-size: 0.875rem;
    }

    .activity {
        display: none;
    }
}
</style>

<script>
// Weekly Competition Event JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Countdown timer
    function updateCompetitionTimer() {
        // Calculate time remaining (example: 2 days, 14 hours, 32 minutes from now)
        const endTime = new Date();
        endTime.setDate(endTime.getDate() + 2);
        endTime.setHours(endTime.getHours() + 14);
        endTime.setMinutes(endTime.getMinutes() + 32);

        const now = new Date();
        const diff = endTime - now;

        if (diff > 0) {
            const days = Math.floor(diff / (1000 * 60 * 60 * 24));
            const hours = Math.floor((diff % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
            const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
            const seconds = Math.floor((diff % (1000 * 60)) / 1000);

            const timerUnits = document.querySelectorAll('.timer-unit');
            if (timerUnits.length >= 4) {
                timerUnits[0].querySelector('.timer-number').textContent = days;
                timerUnits[1].querySelector('.timer-number').textContent = hours;
                timerUnits[2].querySelector('.timer-number').textContent = minutes;
                timerUnits[3].querySelector('.timer-number').textContent = seconds;
            }
        }
    }

    // Participate button functionality
    const participateBtn = document.querySelector('.participate-btn');
    if (participateBtn) {
        participateBtn.addEventListener('click', function() {
            // Simulate participation process
            const originalContent = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i><span>Joining Competition...</span>';
            this.disabled = true;

            setTimeout(() => {
                this.innerHTML = '<i class="fas fa-check"></i><span>You\'re Participating!</span>';
                this.style.background = 'linear-gradient(45deg, #10b981, #059669)';

                // Show success message
                if (window.showNotification) {
                    window.showNotification('Successfully joined the weekly competition!', 'success');
                }

                // Update participation status after a moment
                setTimeout(() => {
                    this.innerHTML = '<i class="fas fa-trophy"></i><span>View Your Progress</span>';
                }, 2000);
            }, 2000);
        });
    }

    // Update timer immediately and then every second
    updateCompetitionTimer();
    setInterval(updateCompetitionTimer, 1000);

    // Simulate live leaderboard updates
    function updateLeaderboard() {
        const pointsElements = document.querySelectorAll('.leaderboard-row .points');
        pointsElements.forEach(element => {
            if (Math.random() < 0.1) { // 10% chance to update each row
                const currentPoints = parseInt(element.textContent.replace(',', ''));
                const newPoints = currentPoints + Math.floor(Math.random() * 50) + 1;
                element.textContent = newPoints.toLocaleString();
            }
        });
    }

    // Update leaderboard every 30 seconds
    setInterval(updateLeaderboard, 30000);
});
</script>
