{{-- Special Monthly Event Content --}}
<div class="monthly-event">
    {{-- Event Header --}}
    <div class="event-header">
        <div class="event-icon">
            <i class="fas fa-calendar-alt"></i>
        </div>
        <div class="event-info">
            <h3 class="event-title">Monthly Special Event</h3>
            <p class="event-description">Join our exclusive monthly celebration with amazing rewards!</p>
        </div>
        <div class="event-badge">
            <span class="badge monthly">MONTHLY</span>
        </div>
    </div>

    {{-- Event Content --}}
    <div class="event-content">
        <div class="coming-soon">
            <div class="coming-soon-icon">
                <i class="fas fa-rocket"></i>
            </div>
            <h4>Coming Soon!</h4>
            <p>This monthly event is currently being prepared. Stay tuned for more details!</p>
            <div class="notify-section">
                <button class="notify-btn">
                    <i class="fas fa-bell"></i>
                    Notify Me When Ready
                </button>
            </div>
        </div>
    </div>

    {{-- Preview Section --}}
    <div class="preview-section">
        <h4>What to Expect:</h4>
        <div class="preview-items">
            <div class="preview-item">
                <i class="fas fa-gift"></i>
                <span>Exclusive Monthly Rewards</span>
            </div>
            <div class="preview-item">
                <i class="fas fa-users"></i>
                <span>Community Challenges</span>
            </div>
            <div class="preview-item">
                <i class="fas fa-star"></i>
                <span>Special Achievements</span>
            </div>
        </div>
    </div>
</div>

<style>
.monthly-event {
    background: linear-gradient(135deg, rgba(139, 69, 19, 0.1), rgba(255, 140, 0, 0.05));
    border-radius: 16px;
    padding: 2rem;
    border: 1px solid rgba(255, 140, 0, 0.3);
}

.event-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid rgba(255, 140, 0, 0.2);
}

.event-icon {
    width: 4rem;
    height: 4rem;
    background: linear-gradient(135deg, #ff8c00, #ff6347);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    box-shadow: 0 0 20px rgba(255, 140, 0, 0.4);
}

.event-info {
    flex: 1;
}

.event-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    background: linear-gradient(45deg, #ff8c00, #ff6347);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.event-description {
    color: var(--color-text-secondary);
}

.badge.monthly {
    background: linear-gradient(45deg, #ff8c00, #ff6347);
    color: white;
    padding: 0.375rem 0.75rem;
    border-radius: 20px;
    font-weight: 600;
    font-size: 0.875rem;
}

.coming-soon {
    text-align: center;
    padding: 3rem 0;
    background: rgba(22, 33, 62, 0.4);
    border-radius: 12px;
    border: 1px solid rgba(255, 140, 0, 0.2);
}

.coming-soon-icon {
    font-size: 4rem;
    color: #ff8c00;
    margin-bottom: 1rem;
}

.coming-soon h4 {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.coming-soon p {
    color: var(--color-text-secondary);
    margin-bottom: 2rem;
    max-width: 400px;
    margin-left: auto;
    margin-right: auto;
}

.notify-btn {
    background: linear-gradient(45deg, #ff8c00, #ff6347);
    color: white;
    border: none;
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
    display: flex;
    align-items: center;
    gap: 0.5rem;
    margin: 0 auto;
}

.notify-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 15px rgba(255, 140, 0, 0.4);
}

.preview-section {
    margin-top: 2rem;
}

.preview-section h4 {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.preview-items {
    display: grid;
    gap: 1rem;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
}

.preview-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    padding: 1rem;
    background: rgba(22, 33, 62, 0.4);
    border-radius: 8px;
    border: 1px solid rgba(255, 140, 0, 0.2);
}

.preview-item i {
    color: #ff8c00;
    font-size: 1.25rem;
}

.preview-item span {
    color: var(--color-text-secondary);
}
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const notifyBtn = document.querySelector('.notify-btn');
    if (notifyBtn) {
        notifyBtn.addEventListener('click', function() {
            const originalContent = this.innerHTML;
            this.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Subscribing...';
            this.disabled = true;

            setTimeout(() => {
                this.innerHTML = '<i class="fas fa-check"></i> You\'ll Be Notified!';
                this.style.background = 'linear-gradient(45deg, #10b981, #059669)';

                if (window.showNotification) {
                    window.showNotification('You\'ll be notified when the monthly event is ready!', 'success');
                }
            }, 1500);
        });
    }
});
</script>
