{{-- Daily Bonus Event Content --}}
<div class="daily-bonus-event">
    {{-- Event Header --}}
    <div class="event-header">
        <div class="event-icon">
            <i class="fas fa-gift"></i>
        </div>
        <div class="event-info">
            <h3 class="event-title" data-translate="rewardsSystem.events.dailyBonus.title">Daily Special Reward</h3>
            <p class="event-description" data-translate="rewardsSystem.events.dailyBonus.description">Get amazing rewards every day!</p>
        </div>
        <div class="event-timer">
            <i class="fas fa-clock"></i>
            <span class="timer-text">Resets in 18:42:13</span>
        </div>
    </div>

    {{-- Rewards Section --}}
    <div class="rewards-section">
        <h4 class="rewards-title" data-translate="rewardsSystem.events.dailyBonus.todaysRewards">Today's Rewards:</h4>

        <div class="rewards-grid">
            {{-- Daily Login Reward --}}
            <div class="reward-card">
                <div class="reward-icon">
                    <i class="fas fa-coins"></i>
                </div>
                <div class="reward-details">
                    <span class="reward-name">Gold Coins</span>
                    <span class="reward-amount">+5,000 Gold</span>
                </div>
                <div class="reward-status claimed">
                    <i class="fas fa-check"></i>
                </div>
            </div>

            {{-- Experience Bonus --}}
            <div class="reward-card">
                <div class="reward-icon">
                    <i class="fas fa-star"></i>
                </div>
                <div class="reward-details">
                    <span class="reward-name">EXP Bonus</span>
                    <span class="reward-amount">+25% EXP (2h)</span>
                </div>
                <div class="reward-status available">
                    <button class="claim-btn" data-translate="rewardsSystem.events.dailyBonus.claimReward">Claim Reward</button>
                </div>
            </div>

            {{-- Silk Points --}}
            <div class="reward-card">
                <div class="reward-icon">
                    <i class="fas fa-gem"></i>
                </div>
                <div class="reward-details">
                    <span class="reward-name">Silk Points</span>
                    <span class="reward-amount">+100 Silk</span>
                </div>
                <div class="reward-status locked">
                    <i class="fas fa-lock"></i>
                    <span>VIP Required</span>
                </div>
            </div>
        </div>
    </div>

    {{-- Daily Streak --}}
    <div class="streak-section">
        <h4 class="streak-title">Daily Login Streak</h4>
        <div class="streak-progress">
            <div class="streak-day completed">
                <div class="day-number">1</div>
                <div class="day-reward">
                    <i class="fas fa-coins"></i>
                </div>
            </div>
            <div class="streak-day completed">
                <div class="day-number">2</div>
                <div class="day-reward">
                    <i class="fas fa-star"></i>
                </div>
            </div>
            <div class="streak-day current">
                <div class="day-number">3</div>
                <div class="day-reward">
                    <i class="fas fa-gem"></i>
                </div>
            </div>
            <div class="streak-day upcoming">
                <div class="day-number">4</div>
                <div class="day-reward">
                    <i class="fas fa-shield-alt"></i>
                </div>
            </div>
            <div class="streak-day upcoming">
                <div class="day-number">5</div>
                <div class="day-reward">
                    <i class="fas fa-crown"></i>
                </div>
            </div>
        </div>
    </div>

    {{-- Event Tips --}}
    <div class="event-tips">
        <div class="tip-item">
            <i class="fas fa-lightbulb"></i>
            <span>Login daily to maintain your streak and unlock bigger rewards!</span>
        </div>
        <div class="tip-item">
            <i class="fas fa-clock"></i>
            <span>Daily rewards reset at 00:00 server time.</span>
        </div>
    </div>
</div>

<style>
.daily-bonus-event {
    background: linear-gradient(135deg, rgba(168, 85, 247, 0.1), rgba(0, 255, 255, 0.05));
    border-radius: 16px;
    padding: 2rem;
    border: 1px solid rgba(168, 85, 247, 0.2);
}

.event-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 2rem;
    padding-bottom: 1rem;
    border-bottom: 1px solid rgba(168, 85, 247, 0.2);
}

.event-icon {
    width: 4rem;
    height: 4rem;
    background: var(--gradient-game-primary);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.5rem;
    box-shadow: var(--shadow-game-glow);
}

.event-info {
    flex: 1;
}

.event-title {
    font-size: 1.5rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
    background: linear-gradient(45deg, var(--color-game-neon-cyan), var(--color-game-purple-400));
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
}

.event-description {
    color: var(--color-text-secondary);
    font-size: 1rem;
}

.event-timer {
    display: flex;
    align-items: center;
    gap: 0.5rem;
    background: rgba(0, 255, 255, 0.1);
    padding: 0.75rem 1rem;
    border-radius: 8px;
    border: 1px solid rgba(0, 255, 255, 0.3);
    color: var(--color-game-neon-cyan);
}

.rewards-section {
    margin-bottom: 2rem;
}

.rewards-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.rewards-grid {
    display: grid;
    gap: 1rem;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
}

.reward-card {
    background: rgba(22, 33, 62, 0.6);
    border: 1px solid rgba(168, 85, 247, 0.2);
    border-radius: 12px;
    padding: 1rem;
    display: flex;
    align-items: center;
    gap: 1rem;
    transition: all 0.3s;
}

.reward-card:hover {
    border-color: var(--color-game-neon-cyan);
    box-shadow: 0 4px 20px rgba(0, 255, 255, 0.2);
}

.reward-icon {
    width: 3rem;
    height: 3rem;
    background: var(--gradient-game-secondary);
    border-radius: 8px;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 1.25rem;
}

.reward-details {
    flex: 1;
}

.reward-name {
    display: block;
    font-weight: 600;
    color: var(--color-text-primary);
    margin-bottom: 0.25rem;
}

.reward-amount {
    display: block;
    color: var(--color-game-neon-cyan);
    font-size: 0.875rem;
}

.reward-status.claimed {
    color: #10b981;
}

.reward-status.available .claim-btn {
    background: var(--gradient-game-primary);
    color: white;
    border: none;
    padding: 0.5rem 1rem;
    border-radius: 6px;
    font-weight: 600;
    cursor: pointer;
    transition: all 0.3s;
}

.reward-status.available .claim-btn:hover {
    box-shadow: 0 4px 15px rgba(168, 85, 247, 0.4);
}

.reward-status.locked {
    color: #6b7280;
    text-align: center;
    font-size: 0.875rem;
}

.streak-section {
    margin-bottom: 2rem;
}

.streak-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--color-text-primary);
}

.streak-progress {
    display: flex;
    gap: 1rem;
    justify-content: center;
}

.streak-day {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 0.5rem;
    padding: 1rem;
    border-radius: 12px;
    border: 2px solid rgba(168, 85, 247, 0.2);
    background: rgba(22, 33, 62, 0.4);
}

.streak-day.completed {
    border-color: #10b981;
    background: rgba(16, 185, 129, 0.1);
}

.streak-day.current {
    border-color: var(--color-game-neon-cyan);
    background: rgba(0, 255, 255, 0.1);
    box-shadow: 0 0 20px rgba(0, 255, 255, 0.3);
}

.day-number {
    font-weight: 700;
    font-size: 1.125rem;
}

.day-reward {
    font-size: 1.25rem;
}

.event-tips {
    background: rgba(168, 85, 247, 0.05);
    border-radius: 12px;
    padding: 1rem;
    border: 1px solid rgba(168, 85, 247, 0.1);
}

.tip-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
    margin-bottom: 0.75rem;
    color: var(--color-text-secondary);
}

.tip-item:last-child {
    margin-bottom: 0;
}

.tip-item i {
    color: var(--color-game-neon-cyan);
}
</style>

<script>
// Daily Bonus Event JavaScript
document.addEventListener('DOMContentLoaded', function() {
    // Claim reward functionality
    document.querySelectorAll('.claim-btn').forEach(button => {
        button.addEventListener('click', function() {
            const rewardCard = this.closest('.reward-card');
            const rewardName = rewardCard.querySelector('.reward-name').textContent;

            // Simulate claim process
            this.textContent = 'Claiming...';
            this.disabled = true;

            setTimeout(() => {
                rewardCard.querySelector('.reward-status').className = 'reward-status claimed';
                rewardCard.querySelector('.reward-status').innerHTML = '<i class="fas fa-check"></i>';

                // Show success message
                if (window.showNotification) {
                    window.showNotification(`${rewardName} claimed successfully!`, 'success');
                }
            }, 1500);
        });
    });

    // Update timer every second
    function updateTimer() {
        const now = new Date();
        const tomorrow = new Date(now);
        tomorrow.setDate(tomorrow.getDate() + 1);
        tomorrow.setHours(0, 0, 0, 0);

        const diff = tomorrow - now;
        const hours = Math.floor(diff / (1000 * 60 * 60));
        const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((diff % (1000 * 60)) / 1000);

        const timerText = document.querySelector('.timer-text');
        if (timerText) {
            timerText.textContent = `Resets in ${hours.toString().padStart(2, '0')}:${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}`;
        }
    }

    updateTimer();
    setInterval(updateTimer, 1000);
});
</script>
