@props(['charId' => null, 'items' => null])

<?php
// Inventory slot mapping for Silkroad Online
$inventorySlots = [
    0 => ['name' => 'Head', 'icon' => 'fas fa-crown', 'position' => 'top-left'],
    1 => ['name' => 'Chest', 'icon' => 'fas fa-tshirt', 'position' => 'middle-left'],
    2 => ['name' => 'Shoulder', 'icon' => 'fas fa-vest', 'position' => 'top-right'],
    3 => ['name' => 'Hand', 'icon' => 'fas fa-hand-paper', 'position' => 'middle-right'],
    4 => ['name' => 'Legs', 'icon' => 'fas fa-socks', 'position' => 'bottom-left'],
    5 => ['name' => 'Foot', 'icon' => 'fas fa-shoe-prints', 'position' => 'bottom-right'],
    6 => ['name' => 'Weapon', 'icon' => 'fas fa-sword', 'position' => 'weapon'],
    7 => ['name' => 'Shield', 'icon' => 'fas fa-shield-alt', 'position' => 'shield'],
    8 => ['name' => 'Job-item', 'icon' => 'fas fa-briefcase', 'position' => 'job'],
    9 => ['name' => 'Earing', 'icon' => 'fas fa-gem', 'position' => 'accessories-1'],
    10 => ['name' => 'Necklace', 'icon' => 'fas fa-medal', 'position' => 'accessories-2'],
    11 => ['name' => 'Left-Ring', 'icon' => 'fas fa-ring', 'position' => 'accessories-3'],
    12 => ['name' => 'Right-Ring', 'icon' => 'fas fa-ring', 'position' => 'accessories-4'],
];

// Note: Using enhanced equipment data from InventoryHelper::getEnhancedCharacterEquipment()
// which provides proper opt_level values directly from character's equipped items

// Process real items data from database
$processedItems = [];
if ($items && is_array($items)) {
    foreach ($items as $item) {
        $slot = $item['slot'] ?? null;
        $itemName = $item['name'] ?? 'Unknown Item';
        $iconPath = $item['icon_path'] ?? null;
        $rarity = $item['rarity'] ?? 1;

        // Convert icon path from .ddj to .jpg and add assets prefix
        $imagePath = null;
        if ($iconPath) {
            // Use the Helper for proper path processing
            $imagePath = \App\Helpers\InventoryHelper::processIconPath($iconPath);
        } else {
            // Use placeholder if no icon path
            $imagePath = '/assets/images/ui/placeholder-item.svg';
        }

        // Determine item grade based on CodeName128
        $codeName = $item['code_name'] ?? $item['CodeName128'] ?? '';
        $grade = 'normal';

        if (empty($codeName) || !str_contains($codeName, 'RARE')) {
            $grade = 'normal';
        } elseif (str_contains($codeName, 'A_RARE')) {
            $grade = 'rare';  // Seal of Star
        } elseif (str_contains($codeName, 'B_RARE')) {
            $grade = 'epic';  // Seal of Moon
        } elseif (preg_match('/[C-Z]_RARE/', $codeName)) {
            $grade = 'legendary';  // Seal of Sun (C_RARE, D_RARE, E_RARE, F_RARE, G_RARE, etc.)
        } else {
            // Generic RARE without letter prefix
            $grade = 'rare';
        }

        if ($slot !== null) {
            // Use direct data from InventoryHelper (no need for complex logic anymore)
            $actualOptLevel = is_numeric($item['opt_level'] ?? 0) ? (int)$item['opt_level'] : 0;
            $actualMagParamNum = is_numeric($item['mag_param_num'] ?? 0) ? (int)$item['mag_param_num'] : 0;
            $actualVariance = is_numeric($item['variance'] ?? 0) ? (int)$item['variance'] : 0;

            $processedItems[$slot] = [
                'name' => $itemName,
                'image' => $imagePath,
                'grade' => $grade,
                'item_id' => $item['item_id'] ?? null,
                'ref_obj_id' => $item['ref_obj_id'] ?? $item['RefItemID'] ?? null,
                'opt_level' => $actualOptLevel,
                'mag_param_num' => $actualMagParamNum,
                'variance' => $actualVariance,
                'code_name' => $codeName,
                // Debug info
                'debug_original_opt_level' => $item['opt_level'] ?? 'NOT_SET',
                'debug_actual_opt_level' => $actualOptLevel,
                'debug_mag_param' => $actualMagParamNum,
                'debug_variance' => $actualVariance,
                'debug_keys' => array_keys($item)
            ];

            // Debug output for development
            if (config('app.debug') && $slot === 6) { // Show debug for weapon slot
                echo "<!-- DEBUG SLOT $slot: name=" . ($itemName ?? 'NULL') . " | opt_level=" . $actualOptLevel . " | mag_param=" . $actualMagParamNum . " -->";
            }
        }
    }
}
?>

<div class="silkroad-inventory-container"
     data-char-id="{{ $charId }}"
     x-data="inventoryTooltip('{{ $charId }}', @js($processedItems))"
     x-init="console.log('🔍 ProcessedItems for {{ $charId }}:', @js($processedItems))">
    <!-- Inventory Background -->

        <!-- Equipment Grid (2x7 Layout) -->
        <div class="equipment-grid-2x7">
            <!-- Row 1: Weapon (6) and Shield (7) -->
            <div class="inventory-slot weapon-slot {{ isset($processedItems[6]) ? 'has-item grade-' . $processedItems[6]['grade'] : '' }}"
                 data-slot="6"
                 data-slot-name="Weapon"
                 @if(isset($processedItems[6])) data-ref-obj-id="{{ $processedItems[6]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 6, 'Weapon')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[6]))
                    <img src="{{ $processedItems[6]['image'] }}"
                         alt="{{ $processedItems[6]['name'] }}"
                         class="inventory-item {{ $processedItems[6]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[6]['name'] }}{{ $processedItems[6]['opt_level'] > 0 ? ' +' . $processedItems[6]['opt_level'] : '' }}"
                         data-original-path="{{ $processedItems[6]['image'] }}"
                         onerror="console.log('Failed to load:', this.src); this.style.display='none'; this.nextElementSibling.style.display='flex'; this.nextElementSibling.innerHTML += '<small style=&quot;color: #ef4444; font-size: 10px; margin-top: 4px;&quot;>Image: ' + this.dataset.originalPath + '</small>';">
                    @if(isset($processedItems[6]['opt_level']) && $processedItems[6]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[6]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder weapon-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[6]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[6]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder weapon-placeholder">
                        <i class="{{ $inventorySlots[6]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[6]['name'] }}</span>
                    </div>
                @endif
            </div>
            <div class="inventory-slot shield-slot {{ isset($processedItems[7]) ? 'has-item grade-' . $processedItems[7]['grade'] : '' }}"
                 data-slot="7"
                 data-slot-name="Shield"
                 @if(isset($processedItems[7])) data-ref-obj-id="{{ $processedItems[7]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 7, 'Shield')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[7]))
                    <img src="{{ $processedItems[7]['image'] }}"
                         alt="{{ $processedItems[7]['name'] }}"
                         class="inventory-item {{ $processedItems[7]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[7]['name'] }}{{ $processedItems[7]['opt_level'] > 0 ? ' +' . $processedItems[7]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[7]['opt_level']) && $processedItems[7]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[7]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder shield-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[7]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[7]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder shield-placeholder">
                        <i class="{{ $inventorySlots[7]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[7]['name'] }}</span>
                    </div>
                @endif
            </div>

            <!-- Row 2: Head (0) and Shoulder (2) -->
            <div class="inventory-slot equipment-slot {{ isset($processedItems[0]) ? 'has-item grade-' . $processedItems[0]['grade'] : '' }}"
                 data-slot="0"
                 data-slot-name="Head"
                 @if(isset($processedItems[0])) data-ref-obj-id="{{ $processedItems[0]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 0, 'Head')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[0]))
                    <img src="{{ $processedItems[0]['image'] }}"
                         alt="{{ $processedItems[0]['name'] }}"
                         class="inventory-item {{ $processedItems[0]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[0]['name'] }}{{ $processedItems[0]['opt_level'] > 0 ? ' +' . $processedItems[0]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[0]['opt_level']) && $processedItems[0]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[0]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[0]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[0]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[0]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[0]['name'] }}</span>
                    </div>
                @endif
            </div>
            <div class="inventory-slot equipment-slot {{ isset($processedItems[2]) ? 'has-item grade-' . $processedItems[2]['grade'] : '' }}"
                 data-slot="2"
                 data-slot-name="Shoulder"
                 @if(isset($processedItems[2])) data-ref-obj-id="{{ $processedItems[2]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 2, 'Shoulder')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[2]))
                    <img src="{{ $processedItems[2]['image'] }}"
                         alt="{{ $processedItems[2]['name'] }}"
                         class="inventory-item {{ $processedItems[2]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[2]['name'] }}{{ $processedItems[2]['opt_level'] > 0 ? ' +' . $processedItems[2]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[2]['opt_level']) && $processedItems[2]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[2]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[2]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[2]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[2]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[2]['name'] }}</span>
                    </div>
                @endif
            </div>

            <!-- Row 3: Chest (1) and Hand (3) -->
            <div class="inventory-slot equipment-slot {{ isset($processedItems[1]) ? 'has-item grade-' . $processedItems[1]['grade'] : '' }}"
                 data-slot="1"
                 data-slot-name="Chest"
                 @if(isset($processedItems[1])) data-ref-obj-id="{{ $processedItems[1]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 1, 'Chest')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[1]))
                    <img src="{{ $processedItems[1]['image'] }}"
                         alt="{{ $processedItems[1]['name'] }}"
                         class="inventory-item {{ $processedItems[1]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[1]['name'] }}{{ $processedItems[1]['opt_level'] > 0 ? ' +' . $processedItems[1]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[1]['opt_level']) && $processedItems[1]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[1]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[1]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[1]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[1]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[1]['name'] }}</span>
                    </div>
                @endif
            </div>
            <div class="inventory-slot equipment-slot {{ isset($processedItems[3]) ? 'has-item grade-' . $processedItems[3]['grade'] : '' }}"
                 data-slot="3"
                 data-slot-name="Hand"
                 @if(isset($processedItems[3])) data-ref-obj-id="{{ $processedItems[3]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 3, 'Hand')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[3]))
                    <img src="{{ $processedItems[3]['image'] }}"
                         alt="{{ $processedItems[3]['name'] }}"
                         class="inventory-item {{ $processedItems[3]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[3]['name'] }}{{ $processedItems[3]['opt_level'] > 0 ? ' +' . $processedItems[3]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[3]['opt_level']) && $processedItems[3]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[3]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[3]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[3]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[3]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[3]['name'] }}</span>
                    </div>
                @endif
            </div>

            <!-- Row 4: Legs (4) and Foot (5) -->
            <div class="inventory-slot equipment-slot {{ isset($processedItems[4]) ? 'has-item grade-' . $processedItems[4]['grade'] : '' }}"
                 data-slot="4"
                 data-slot-name="Legs"
                 @if(isset($processedItems[4])) data-ref-obj-id="{{ $processedItems[4]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 4, 'Legs')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[4]))
                    <img src="{{ $processedItems[4]['image'] }}"
                         alt="{{ $processedItems[4]['name'] }}"
                         class="inventory-item {{ $processedItems[4]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[4]['name'] }}{{ $processedItems[4]['opt_level'] > 0 ? ' +' . $processedItems[4]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[4]['opt_level']) && $processedItems[4]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[4]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[4]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[4]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[4]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[4]['name'] }}</span>
                    </div>
                @endif
            </div>
            <div class="inventory-slot equipment-slot {{ isset($processedItems[5]) ? 'has-item grade-' . $processedItems[5]['grade'] : '' }}"
                 data-slot="5"
                 data-slot-name="Foot"
                 @if(isset($processedItems[5])) data-ref-obj-id="{{ $processedItems[5]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 5, 'Foot')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[5]))
                    <img src="{{ $processedItems[5]['image'] }}"
                         alt="{{ $processedItems[5]['name'] }}"
                         class="inventory-item {{ $processedItems[5]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[5]['name'] }}{{ $processedItems[5]['opt_level'] > 0 ? ' +' . $processedItems[5]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[5]['opt_level']) && $processedItems[5]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[5]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[5]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[5]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[5]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[5]['name'] }}</span>
                    </div>
                @endif
            </div>

            <!-- Row 5: Earring (9) and Necklace (10) -->
            <div class="inventory-slot accessory-slot {{ isset($processedItems[9]) ? 'has-item grade-' . $processedItems[9]['grade'] : '' }}"
                 data-slot="9"
                 data-slot-name="Earing"
                 @if(isset($processedItems[9])) data-ref-obj-id="{{ $processedItems[9]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 9, 'Earing')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[9]))
                    <img src="{{ $processedItems[9]['image'] }}"
                         alt="{{ $processedItems[9]['name'] }}"
                         class="inventory-item {{ $processedItems[9]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[9]['name'] }}{{ $processedItems[9]['opt_level'] > 0 ? ' +' . $processedItems[9]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[9]['opt_level']) && $processedItems[9]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[9]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[9]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[9]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[9]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[9]['name'] }}</span>
                    </div>
                @endif
            </div>
            <div class="inventory-slot accessory-slot {{ isset($processedItems[10]) ? 'has-item grade-' . $processedItems[10]['grade'] : '' }}"
                 data-slot="10"
                 data-slot-name="Necklace"
                 @if(isset($processedItems[10])) data-ref-obj-id="{{ $processedItems[10]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 10, 'Necklace')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[10]))
                    <img src="{{ $processedItems[10]['image'] }}"
                         alt="{{ $processedItems[10]['name'] }}"
                         class="inventory-item {{ $processedItems[10]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[10]['name'] }}{{ $processedItems[10]['opt_level'] > 0 ? ' +' . $processedItems[10]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[10]['opt_level']) && $processedItems[10]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[10]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[10]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[10]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[10]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[10]['name'] }}</span>
                    </div>
                @endif
            </div>

            <!-- Row 6: Left Ring (11) and Right Ring (12) -->
            <div class="inventory-slot ring-slot {{ isset($processedItems[11]) ? 'has-item grade-' . $processedItems[11]['grade'] : '' }}"
                 data-slot="11"
                 data-slot-name="Left-Ring"
                 @if(isset($processedItems[11])) data-ref-obj-id="{{ $processedItems[11]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 11, 'Left-Ring')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[11]))
                    <img src="{{ $processedItems[11]['image'] }}"
                         alt="{{ $processedItems[11]['name'] }}"
                         class="inventory-item {{ $processedItems[11]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[11]['name'] }}{{ $processedItems[11]['opt_level'] > 0 ? ' +' . $processedItems[11]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[11]['opt_level']) && $processedItems[11]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[11]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[11]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[11]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[11]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[11]['name'] }}</span>
                    </div>
                @endif
            </div>
            <div class="inventory-slot ring-slot {{ isset($processedItems[12]) ? 'has-item grade-' . $processedItems[12]['grade'] : '' }}"
                 data-slot="12"
                 data-slot-name="Right-Ring"
                 @if(isset($processedItems[12])) data-ref-obj-id="{{ $processedItems[12]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 12, 'Right-Ring')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[12]))
                    <img src="{{ $processedItems[12]['image'] }}"
                         alt="{{ $processedItems[12]['name'] }}"
                         class="inventory-item {{ $processedItems[12]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[12]['name'] }}{{ $processedItems[12]['opt_level'] > 0 ? ' +' . $processedItems[12]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[12]['opt_level']) && $processedItems[12]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[12]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[12]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[12]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder">
                        <i class="{{ $inventorySlots[12]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[12]['name'] }}</span>
                    </div>
                @endif
            </div>

            <!-- Row 7: No Icons (Empty) and Job Item (8) -->
            <div class="inventory-slot empty-slot" data-slot-name="No Icons">
                <div class="slot-placeholder empty-placeholder">
                    <span class="slot-label text-slate-500">No Icons</span>
                </div>
            </div>
            <div class="inventory-slot job-slot {{ isset($processedItems[8]) ? 'has-item grade-' . $processedItems[8]['grade'] : '' }}"
                 data-slot="8"
                 data-slot-name="Job-item"
                 @if(isset($processedItems[8])) data-ref-obj-id="{{ $processedItems[8]['ref_obj_id'] }}" @endif
                 @mouseenter="showTooltip($event, 8, 'Job-item')"
                 @mouseleave="onSlotMouseLeave()"
                 @mousemove="updateTooltipPosition($event)">
                @if(isset($processedItems[8]))
                    <img src="{{ $processedItems[8]['image'] }}"
                         alt="{{ $processedItems[8]['name'] }}"
                         class="inventory-item {{ $processedItems[8]['grade'] ?? 'normal' }}"
                         title="{{ $processedItems[8]['name'] }}{{ $processedItems[8]['opt_level'] > 0 ? ' +' . $processedItems[8]['opt_level'] : '' }}"
                         onerror="this.style.display='none'; this.nextElementSibling.style.display='flex';">
                    @if(isset($processedItems[8]['opt_level']) && $processedItems[8]['opt_level'] > 0)
                        <div class="opt-level-overlay">+{{ $processedItems[8]['opt_level'] }}</div>
                    @endif
                    <div class="slot-placeholder job-placeholder" style="display: none;">
                        <i class="{{ $inventorySlots[8]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[8]['name'] }}</span>
                    </div>
                @else
                    <div class="slot-placeholder job-placeholder">
                        <i class="{{ $inventorySlots[8]['icon'] }}"></i>
                        <span class="slot-label">{{ $inventorySlots[8]['name'] }}</span>
                    </div>
                @endif
            </div>
        </div>


    <!-- Inventory Info -->
    <div class="inventory-info">
        <div class="inventory-title">
            <i class="fas fa-boxes text-purple-400 mr-2"></i>
            <span data-translate="inventory.equipmentTitle">Equipment & Items</span>
        </div>
        @if($charId)
            <div class="character-id">
                <span class="text-slate-400">Character ID:</span>
                <span class="text-white font-mono">{{ $charId }}</span>
            </div>
        @endif
    </div>

    <!-- Coming Soon Notice -->
    <div class="coming-soon-notice">
        <i class="fas fa-hammer text-slate-400 mr-2"></i>
        <span class="text-slate-400 text-sm" data-translate="inventory.comingSoon">
            Full inventory system coming soon...
        </span>
    </div>

    <!-- Alpine.js Tooltip -->
    <div x-show="tooltipVisible"
         x-html="tooltipContent"
         :style="`left: ${tooltipX}px; top: ${tooltipY}px; position: fixed; z-index: 1000; pointer-events: auto;`"
         class="inventory-tooltip-container"
         x-transition:enter="transition ease-out duration-200"
         x-transition:enter-start="opacity-0 transform scale-95"
         x-transition:enter-end="opacity-100 transform scale-100"
         x-transition:leave="transition ease-in duration-150"
         x-transition:leave-start="opacity-100 transform scale-100"
         x-transition:leave-end="opacity-0 transform scale-95"
         @mouseenter="onTooltipMouseEnter()"
         @mouseleave="onTooltipMouseLeave()"
         @click.away="hideTooltip()">
    </div>

