{{-- Navigation Item Component --}}
@props([
    'href' => '#',
    'route' => null,
    'urlPattern' => null,
    'icon' => null,
    'text' => '',
    'class' => 'nav-item',
    'activeClass' => 'active',
    'isDropdown' => false
])

@php
    $isActive = false;

    if ($route) {
        $isActive = is_active_route($route);
    } elseif ($urlPattern) {
        $isActive = is_active_url($urlPattern);
    }

    $finalClass = $class . ($isActive ? ' ' . $activeClass : '');
@endphp

<a href="{{ $route ? route($route) : $href }}"
   class="{{ $finalClass }}"
   @if($isDropdown) data-dropdown-trigger @endif>

    @if($icon)
        <i class="{{ $icon }}"></i>
    @endif

    <span data-translate="{{ $attributes->get('data-translate') }}">
        {{ $text }}
    </span>

    @if($isDropdown)
        <i class="fas fa-chevron-down dropdown-arrow"></i>
    @endif

    {{ $slot }}
</a>
