@props([
    'position' => 'absolute',
    'action' => null,
    'class' => ''
])

<button
    @if($action) wire:click="{{ $action }}" @endif
    {{ $attributes->merge([
        'class' => $position . ' top-3 right-3 sm:top-4 sm:right-4 rtl:right-auto rtl:left-3 rtl:sm:left-4
                   player-modal-close-btn z-20 group
                   hover:bg-red-500/20 hover:border-red-400/50 hover:shadow-lg hover:shadow-red-500/25
                   focus:outline-none focus:ring-2 focus:ring-red-400/50 focus:ring-offset-2 focus:ring-offset-slate-800 ' . $class,
        'type' => 'button',
        'aria-label' => 'Close modal'
    ]) }}>

    <x-icons.close-x class="transition-all duration-300 ease-out group-hover:scale-110 group-hover:rotate-90
                            group-active:scale-95 drop-shadow-sm" />
    <span class="sr-only">Close modal</span>
</button>
