
    <body class="team-body" x-data="teamLayout()" x-init="init()" :class="{ 'sidebar-collapsed': sidebarCollapsed }">

<!-- Team Loading Screen -->
<div x-show="loading" x-transition:leave="transition-opacity duration-500" class="team-loading-screen">
    <div class="team-loading-content">
        <div class="team-loading-spinner"></div>
        <p data-translate="team.loading.message">Loading Team Dashboard...</p>
    </div>
</div>

<!-- Team Layout Container -->
<div class="team-layout-container" x-show="!loading" x-transition:enter="transition-opacity duration-500">

    <!-- Team Header -->
    <header class="team-header" x-show="headerVisible" x-transition:enter="team-slide-down" x-transition:enter-start="team-slide-up">
        <div class="team-header-left">
            <!-- Sidebar Toggle -->
            <button @click="toggleSidebar()" class="team-sidebar-toggle">
                <svg x-show="!sidebarCollapsed" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="3" y1="6" x2="21" y2="6"/>
                    <line x1="3" y1="12" x2="21" y2="12"/>
                    <line x1="3" y1="18" x2="21" y2="18"/>
                </svg>
                <svg x-show="sidebarCollapsed" width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                    <line x1="3" y1="6" x2="21" y2="6"/>
                    <line x1="3" y1="12" x2="21" y2="12"/>
                    <line x1="3" y1="18" x2="21" y2="18"/>
                </svg>
            </button>

            <!-- Logo & Title -->
            <div class="team-header-brand">
                <div class="team-logo">
                    <svg width="32" height="32" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polygon points="12 2 2 7 12 12 22 7 12 2"/>
                        <polyline points="2,17 12,22 22,17"/>
                        <polyline points="2,12 12,17 22,12"/>
                    </svg>
                </div>
                <div class="team-brand-text">
                    <h1 data-translate="team.header.title">Team Dashboard</h1>
                    <span data-translate="team.header.subtitle">Management Panel</span>
                </div>
            </div>
        </div>


        <div class="team-header-right">
<div class="language-switcher"></div>

            <!-- User Menu -->
            <div class="team-user-menu" x-data="{ open: false }">
                <button @click="open = !open" class="team-user-button">
                    <div class="team-user-avatar">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"/>
                            <circle cx="12" cy="7" r="4"/>
                        </svg>
                    </div>
                    <span class="team-user-name">{{ Auth::user()->username ?? 'Team Member' }}</span>
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="team-chevron" :class="{ 'rotate-180': open }">
                        <polyline points="6 9 12 15 18 9"/>
                    </svg>
                </button>

                <div x-show="open" @click.away="open = false" x-transition class="team-user-dropdown">
                    {{-- back to home --}}
                    <a href="{{ route('home') }}" class="team-dropdown-item team-dashboard-link">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2h-4a2 2 0 0 1-2-2v-4H9v4a2 2 0 0 1-2 2H3a2 2 0 0 1-2-2z"/>
                        </svg>
                        <span data-translate="home">Home</span>
                    </a>
                    <div class="team-dropdown-divider"></div>
                    <a href="{{ route('logout') }}" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="team-dropdown-item team-logout">
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M9 21H5a2 2 0 0 1-2-2V5a2 2 0 0 1 2-2h4"/>
                            <polyline points="16 17 21 12 16 7"/>
                            <line x1="21" y1="12" x2="9" y2="12"/>
                        </svg>
                        <span data-translate="team.user.logout">Logout</span>
                    </a>
                    <form id="logout-form" action="{{ route('logout') }}" method="POST" style="display: none;">
                        @csrf
                    </form>
                </div>
            </div>
        </div>
    </header>

    <!-- Team Sidebar -->
    <aside class="team-sidebar" :class="{ 'collapsed': sidebarCollapsed }" x-show="sidebarVisible" x-transition:enter="team-slide-right" x-transition:enter-start="team-slide-left">
        <div class="team-sidebar-content">
            <!-- Navigation Menu -->
            <nav class="team-sidebar-nav">
                <div class="team-nav-section">
                    <h3 data-translate="team.nav.main">Main</h3>
                    <ul class="team-nav-list">
                        <li class="team-nav-item">
                            <a href="{{ route('team-dashboard') }}" class="team-nav-link active">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="3" width="7" height="7"/>
                                    <rect x="14" y="3" width="7" height="7"/>
                                    <rect x="14" y="14" width="7" height="7"/>
                                    <rect x="3" y="14" width="7" height="7"/>
                                </svg>
                                <span data-translate="team.nav.dashboard">Dashboard</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="#" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                                    <circle cx="9" cy="7" r="4"/>
                                    <path d="M23 21v-2a4 4 0 0 0-3-3.87"/>
                                    <path d="M16 3.13a4 4 0 0 1 0 7.75"/>
                                </svg>
                                <span data-translate="team.nav.users">Users</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="#" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M22 12h-4l-3 9L9 3l-3 9H2"/>
                                </svg>
                                <span data-translate="team.nav.analytics">Analytics</span>
                            </a>
                        </li>
                    </ul>
                </div>

                <div class="team-nav-section">
                    <h3 data-translate="team.nav.management">Management</h3>
                    <ul class="team-nav-list">
                        <li class="team-nav-item">
                            <a href="{{ route('team-fast-event-welcome') }}" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M16 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"/>
                                    <circle cx="8.5" cy="7" r="4"/>
                                    <line x1="20" y1="8" x2="20" y2="14"/>
                                    <line x1="23" y1="11" x2="17" y2="11"/>
                                </svg>
                                <span>Fast Event Welcome</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="{{ route('team-fast-event-treasure') }}" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M12 2l3.09 6.26L22 9.27l-5 4.87 1.18 6.88L12 17.77l-6.18 3.25L7 14.14 2 9.27l6.91-1.01L12 2z"/>
                                </svg>
                                <span data-translate="team.fast_event_treasure.title">Treasure Hunt</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="{{ route('team-fast-event-duo') }}" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M16 4c0-1.11.89-2 2-2s2 .89 2 2c0 1.11-.89 2-2 2s-2-.89-2-2zM4 18v-6h3v7c0 1.1.9 2 2 2h1v-13c0-1.1-.9-2-2-2H4c-1.1 0-2 .9-2 2v8c0 1.1.9 2 2 2zM12.5 11.5c.83 0 1.5-.67 1.5-1.5s-.67-1.5-1.5-1.5S11 9.17 11 10s.67 1.5 1.5 1.5zM15 20c1.1 0 2-.9 2-2v-7h3v6c1.1 0 2-.9 2-2V7c0-1.1-.9-2-2-2h-4c-1.1 0-2 .9-2 2v11c0 1.1.9 2 2 2z"/>
                                </svg>
                                <span data-translate="team.fast_event_duo.title">Duo Power</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="#" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <rect x="3" y="4" width="18" height="18" rx="2" ry="2"/>
                                    <line x1="16" y1="2" x2="16" y2="6"/>
                                    <line x1="8" y1="2" x2="8" y2="6"/>
                                    <line x1="3" y1="10" x2="21" y2="10"/>
                                </svg>
                                <span data-translate="team.nav.events">Events</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="#" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"/>
                                    <polyline points="14,2 14,8 20,8"/>
                                    <line x1="16" y1="13" x2="8" y2="13"/>
                                    <line x1="16" y1="17" x2="8" y2="17"/>
                                </svg>
                                <span data-translate="team.nav.reports">Reports</span>
                            </a>
                        </li>
                        <li class="team-nav-item">
                            <a href="#" class="team-nav-link">
                                <svg width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                    <circle cx="12" cy="12" r="3"/>
                                    <path d="M19.4 15a1.65 1.65 0 0 0 .33 1.82l.06.06a2 2 0 0 1 0 2.83 2 2 0 0 1-2.83 0l-.06-.06a1.65 1.65 0 0 0-1.82-.33 1.65 1.65 0 0 0-1 1.51V21a2 2 0 0 1-2 2 2 2 0 0 1-2-2v-.09A1.65 1.65 0 0 0 9 19.4a1.65 1.65 0 0 0-1.82.33l-.06.06a2 2 0 0 1-2.83 0 2 2 0 0 1 0-2.83l.06-.06a1.65 1.65 0 0 0 .33-1.82 1.65 1.65 0 0 0-1.51-1H3a2 2 0 0 1-2-2 2 2 0 0 1 2-2h.09A1.65 1.65 0 0 0 4.6 9a1.65 1.65 0 0 0-.33-1.82l-.06-.06a2 2 0 0 1 0-2.83 2 2 0 0 1 2.83 0l.06.06a1.65 1.65 0 0 0 1.82.33H9a1.65 1.65 0 0 0 1 1.51V3a2 2 0 0 1 2-2 2 2 0 0 1 2 2v.09a1.65 1.65 0 0 0 1 1.51 1.65 1.65 0 0 0 1.82-.33l.06-.06a2 2 0 0 1 2.83 0 2 2 0 0 1 0 2.83l-.06.06a1.65 1.65 0 0 0-.33 1.82V9a1.65 1.65 0 0 0 1.51 1H21a2 2 0 0 1 2 2 2 2 0 0 1-2 2h-.09a1.65 1.65 0 0 0-1.51 1z"/>
                                </svg>
                                <span data-translate="team.nav.settings">Settings</span>
                            </a>
                        </li>
                    </ul>
                </div>
            </nav>

            <!-- Sidebar Footer -->
            <div class="team-sidebar-footer">
                <div class="team-sidebar-status">
                    <div class="team-status-indicator online"></div>
                    <span data-translate="team.status.online">System Online</span>
                </div>
            </div>
        </div>
    </aside>

    <!-- Team Main Content -->
    <main class="team-main-content" :class="{ 'sidebar-collapsed': sidebarCollapsed }">
        <div class="team-content-wrapper">
            {{ $slot }}
        </div>
    </main>

    <!-- Team Footer -->
    <footer class="team-footer" x-show="footerVisible" x-transition:enter="team-slide-up" x-transition:enter-start="team-slide-down">
        <div class="team-footer-content">
            <div class="team-footer-left">
                <p data-translate="team.footer.copyright">&copy; 2024 4TresSro Team Dashboard. All rights reserved.</p>
            </div>
            <div class="team-footer-right">
                <span data-translate="team.footer.version">Version 2.0.0</span>
                <span class="team-footer-separator">•</span>
                <span data-translate="team.footer.build">Build {{ date('Y.m.d') }}</span>
            </div>
        </div>
    </footer>
</div>

<!-- Alpine.js Team Layout Component -->
<script>
function teamLayout() {
    return {
        loading: true,
        sidebarCollapsed: localStorage.getItem('team-sidebar-collapsed') === 'true',
        headerVisible: true,
        sidebarVisible: true,
        footerVisible: true,

        init() {
            // Hide loading screen after initialization
            setTimeout(() => {
                this.loading = false;
            }, 1000);

            // Setup responsive behavior
            this.setupResponsive();

            // Setup keyboard shortcuts
            this.setupKeyboardShortcuts();
        },

        toggleSidebar() {
            this.sidebarCollapsed = !this.sidebarCollapsed;
            localStorage.setItem('team-sidebar-collapsed', this.sidebarCollapsed);
        },

        setupResponsive() {
            const checkViewport = () => {
                if (window.innerWidth < 768) {
                    this.sidebarCollapsed = true;
                } else {
                    this.sidebarCollapsed = localStorage.getItem('team-sidebar-collapsed') === 'true';
                }
            };

            window.addEventListener('resize', checkViewport);
            checkViewport();
        },

        setupKeyboardShortcuts() {
            document.addEventListener('keydown', (e) => {
                // Ctrl/Cmd + B to toggle sidebar
                if ((e.ctrlKey || e.metaKey) && e.key === 'b') {
                    e.preventDefault();
                    this.toggleSidebar();
                }

                // Escape to close any open dropdowns
                if (e.key === 'Escape') {
                    this.$dispatch('close-dropdowns');
                }
            });
        }
    }
}
</script>

<!-- Livewire Scripts -->
@livewireScripts

</body>

