<!-- Mini Hero Section for Non-Home Pages -->
<section class="mini-hero-section" id="miniHeroSection">
    <!-- Simplified Background -->
    <div class="mini-hero-bg"></div>

    <!-- Mini Hero Content -->
    <div class="mini-hero-content">
        <!-- Logo and Title (Center) -->
        <div class="mini-hero-logo-section">
            <div class="mini-hero-logo-container">
                <div class="mini-hero-logo">
                    <img src="/assets/logo.png" alt="4TresSro Logo" class="mini-hero-logo-img"
                        onerror="this.style.display='none';" />
                </div>
            </div>

            <!-- Player Counter -->
            @livewire('mini-player-counter-volt')



            <!-- Page Path -->
            <div class="mini-hero-path">
                <div class="breadcrumb">
                    <a href="{{ route('home') }}" class="breadcrumb-item">Home</a>
                    @php
                        $pathSegments = explode('/', request()->path());
                        $currentPath = '';
                        foreach ($pathSegments as $index => $segment) {
                            if (!empty($segment)) {
                                $currentPath .= '/' . $segment;
                                $isLast = ($index === count($pathSegments) - 1);
                    @endphp
                    <span class="breadcrumb-separator">/</span>
                    @if($isLast)
                        <span class="breadcrumb-item current">{{ $segment }}</span>
                    @else
                        <a href="{{ url($currentPath) }}" class="breadcrumb-item">{{ $segment }}</a>
                    @endif
                    @php
                            }
                        }
                    @endphp
                </div>
            </div>

        </div>
    </div>
</section>
