<!-- Tablet Header Content -->
<!-- Navigation data is loaded from resources/data/navigation.json via get_navigation_data() function -->

@php
    $navigation = get_navigation_data();
@endphp
<div class="header-tablet">
    <!-- Row 1: Logo and Navigation -->
    <div class="header-row-1-tablet">
        <!-- Logo Section -->
        <div class="logo-section-tablet">
            <div class="logo-container-tablet">
                <div class="logo-wrapper-tablet">
                    <div class="logo-inner-tablet">
                        @if ($navigation['logo']['type'] === 'image')
                            @php
                                $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                                $logoImage = $isRTL
                                    ? $navigation['logo']['image_rtl'] ?? $navigation['logo']['image_ltr']
                                    : $navigation['logo']['image_ltr'];
                            @endphp
                            <a
                                href="{{ $navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link'] }}">
                                <img src="{{ $logoImage }}" alt="{{ $navigation['logo']['alt'] }}" />
                            </a>
                        @else
                            @php
                                $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                                $logoText = $isRTL
                                    ? $navigation['logo']['text_rtl'] ?? $navigation['logo']['text_ltr']
                                    : $navigation['logo']['text_ltr'];
                            @endphp
                            <a href="{{ $navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link'] }}"
                                class="logo-text-link">
                                <span class="logo-title-tablet" data-translate="hero.title">{{ $logoText }}</span>
                            </a>
                        @endif
                    </div>
                </div>
            </div>
            @if ($navigation['logo']['type'] === 'image')
                <div class="logo-text-tablet">
                    <span class="logo-title-tablet" data-translate="hero.title">4TresSro</span>
                    <span class="logo-subtitle-tablet" data-translate="hero.subtitle">Epic RPG Adventure</span>
                </div>
            @endif
        </div>

        <!-- Tablet Navigation Menu -->
        <div class="nav-section-tablet">
            <div class="nav-links-container-tablet">
                <!-- Primary Navigation Items -->
                @foreach ($navigation['navigation']['primary'] as $item)
                    @if (
                        $item['visibility'] === 'all' ||
                            ($item['visibility'] === 'guest' && !Auth::check()) ||
                            ($item['visibility'] === 'auth' && Auth::check())
                    )
                        <a href="{{ $item['is_route'] ?? false ? route($item['route']) : $item['route'] }}"
                            class="nav-item-tablet primary {{ active_class($item['active'] ?: '') }}">
                            <i class="{{ $item['icon'] }}"></i>
                            <span data-translate="{{ $item['label'] }}">{{ $item['title'] }}</span>
                        </a>
                    @endif
                @endforeach

                <!-- Dropdown Menu for Other Items -->
                <div class="dropdown-tablet">
                    <a href="#"
                        class="nav-item-tablet dropdown-trigger-tablet {{ collect($navigation['navigation']['dropdown'])->contains(function ($item) {return active_class($item['active'] ?: '');})? 'active': '' }}">
                        <i class="{{ $navigation['dropdown_trigger']['icon'] }}"></i>
                        <span
                            data-translate="{{ $navigation['dropdown_trigger']['label'] }}">{{ $navigation['dropdown_trigger']['title'] }}</span>
                        <i class="fas fa-chevron-down dropdown-arrow-tablet"></i>
                    </a>
                    <div class="dropdown-content-tablet">
                        @foreach ($navigation['navigation']['dropdown'] as $item)
                            @if (
                                $item['visibility'] === 'all' ||
                                    ($item['visibility'] === 'guest' && !Auth::check()) ||
                                    ($item['visibility'] === 'auth' && Auth::check())
                            )
                                <a href="{{ $item['is_route'] ?? false ? route($item['route']) : $item['route'] }}"
                                    class="dropdown-item-tablet {{ active_class($item['active'] ?: '') }}">
                                    <i class="{{ $item['icon'] }}"></i>
                                    <span data-translate="{{ $item['label'] }}">{{ $item['title'] }}</span>
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Row 2: Action Items -->
    <div class="header-row-2-tablet">
        <!-- Tablet Action Section -->
        <div class="action-section-tablet">
            <!-- Language Switcher - Will be populated by MultiLanguageManager -->
            <div class="language-switcher"></div>
            <!-- Balance Display for Tablet -->

            @if (Auth::check())
                <div class="balance-display-tablet">
                    <livewire:balance-head :type="'tablet'" />
                </div>
                            <!-- Elegant Divider -->
            <div class="action-divider-tablet"></div>
            @endif


            <!-- Auth Buttons Group -->
            <div class="auth-buttons-group-tablet">
                @if (Auth::check())
                    <!-- Notification Icons -->
                   <livewire:notifications :type="'tablet'" />



                    <!-- User Dropdown Menu -->
                    <div class="user-dropdown-container-tablet">
                        <button class="user-dropdown-trigger-tablet">
                            <div class="user-avatar-tablet">
                                <i class="fas fa-user-circle"></i>
                            </div>
                            <div class="user-info-tablet">
                                <span class="user-greeting-tablet" data-translate="user.welcome">Welcome</span>
                                <span class="user-name-tablet">{{ Auth::user()->username }}</span>
                            </div>
                            <i class="fas fa-chevron-down dropdown-arrow-tablet"></i>
                        </button>

                        <div class="user-dropdown-menu-tablet">
                            <!-- User Header -->
                            <div class="user-dropdown-header-tablet">
                                <div class="user-avatar-large-tablet">
                                    <i class="fas fa-user-circle"></i>
                                </div>
                                <div class="user-details-tablet">
                                    <h4 class="user-fullname-tablet">{{ Auth::user()->username }}</h4>
                                    <p class="user-status-tablet">Premium Player</p>
                                </div>
                            </div>

                            <!-- Balance Section -->
                            <livewire:balance-head :type="'menu'" />

                            <!-- Menu Items -->
                            <div class="dropdown-menu-items-tablet">
                                @foreach ($navigation['navigation']['user_menu'] as $item)
                                    @if (
                                        $item['visibility'] === 'all' ||
                                            ($item['visibility'] === 'guest' && !Auth::check()) ||
                                            ($item['visibility'] === 'auth' && Auth::check())
                                    )
                                        <a href="{{ $item['is_route'] ?? false ? route($item['route']) : $item['route'] }}"
                                            class="dropdown-menu-item-tablet {{ active_class($item['active'] ?: '') }}">
                                            <i class="{{ $item['icon'] }}"></i>
                                            <span data-translate="{{ $item['label'] }}">{{ $item['title'] }}</span>
                                        </a>
                                    @endif
                                @endforeach

                                @if(Auth::user()->hasRoleLevel(3))
                                    <a href="{{ route('team-dashboard') }}" class="dropdown-menu-item-tablet team-dashboard-link">
                                        <i class="fas fa-users-cog"></i>
                                        <span data-translate="team.dashboard.title">Team Dashboard</span>
                                    </a>
                                @endif
                            </div>

                            <!-- Logout Section -->
                            <div class="dropdown-divider-tablet"></div>
                            <form method="POST" action="{{ route('logout') }}" class="dropdown-logout-form-tablet">
                                @csrf
                                <button type="submit" class="dropdown-menu-item-tablet logout-btn-tablet">
                                    <i class="fas fa-sign-out-alt"></i>
                                    <span data-translate="user.logout">Logout</span>
                                </button>
                            </form>
                        </div>
                    </div>
                @else
                    <livewire:auth.register />
                    <livewire:auth.login />
                @endif
            </div>
        </div>
    </div>
</div>
