<!-- Desktop Header Content -->
<!-- Navigation data is loaded from resources/data/navigation.json via get_navigation_data() function -->

@php
$navigation = get_navigation_data();
@endphp

<div class="header-desktop header-desktop-custom">
    <!-- Logo Section -->
    <div class="logo-section-desktop">
        <div class="logo-container-desktop">
            <div class="logo-wrapper-desktop">
                <div class="logo-inner-desktop">
                    @if($navigation['logo']['type'] === 'image')
                        @php
                            $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']); // Add more RTL languages as needed
                            $logoImage = $isRTL ? ($navigation['logo']['image_rtl'] ?? $navigation['logo']['image_ltr']) : $navigation['logo']['image_ltr'];
                        @endphp
                        <a href="{{ $navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link'] }}">
                            <img src="{{ $logoImage }}" alt="{{ $navigation['logo']['alt'] }}" />
                        </a>
                    @else
                        @php
                            $isRTL = in_array(app()->getLocale(), ['ar', 'he', 'fa', 'ur']);
                            $logoText = $isRTL ? ($navigation['logo']['text_rtl'] ?? $navigation['logo']['text_ltr']) : $navigation['logo']['text_ltr'];
                        @endphp
                        <a href="{{ $navigation['logo']['is_route'] ? route($navigation['logo']['link']) : $navigation['logo']['link'] }}" class="logo-text-link">
                            <span class="logo-title-desktop" data-translate="hero.title">{{ $logoText }}</span>
                        </a>
                    @endif
                </div>
            </div>
        </div>
        @if($navigation['logo']['type'] === 'image')
        <div class="logo-text-desktop">
            <span class="logo-title-desktop" data-translate="hero.title">4TresSro</span>
            <span class="logo-subtitle-desktop" data-translate="hero.subtitle">Epic RPG Adventure</span>
        </div>
        @endif
    </div>

    <!-- Desktop Navigation Menu -->
    <div class="nav-section-desktop">
        <div class="nav-links-container-desktop">
            <!-- Primary Navigation Items -->
            @foreach($navigation['navigation']['primary'] as $item)
            @if($item['visibility'] === 'all' || ($item['visibility'] === 'guest' && !Auth::check()) || ($item['visibility'] === 'auth' && Auth::check()))
            <a href="{{ ($item['is_route'] ?? false) ? route($item['route']) : $item['route'] }}" class="nav-item-desktop primary {{ active_class($item['active'] ?: '') }}">
                <i class="{{ $item['icon'] }}"></i>
                <span data-translate="{{ $item['label'] }}">{{ $item['title'] }}</span>
            </a>
            @endif
            @endforeach

            <!-- Dropdown Menu for Other Items -->
            <div class="dropdown-desktop">
                <a href="#" class="nav-item-desktop dropdown-trigger-desktop {{ collect($navigation['navigation']['dropdown'])->contains(function ($item) { return active_class($item['active'] ?: ''); }) ? 'active' : '' }}">
                    <i class="fas fa-th-large"></i>
                    <span data-translate="nav.more">More</span>
                    <i class="fas fa-chevron-down dropdown-arrow-desktop"></i>
                </a>
                <div class="dropdown-content-desktop">
                    @foreach($navigation['navigation']['dropdown'] as $item)
                    @if($item['visibility'] === 'all' || ($item['visibility'] === 'guest' && !Auth::check()) || ($item['visibility'] === 'auth' && Auth::check()))
                    <a href="{{ ($item['is_route'] ?? false) ? route($item['route']) : $item['route'] }}" class="dropdown-item-desktop {{ active_class($item['active'] ?: '') }}">
                        <i class="{{ $item['icon'] }}"></i>
                        <span data-translate="{{ $item['label'] }}">{{ $item['title'] }}</span>
                    </a>
                    @endif
                    @endforeach
                </div>
            </div>
        </div>
    </div>

    <!-- Desktop Action Section -->
    <div class="action-section-desktop">
        <!-- Language Switcher - Will be populated by MultiLanguageManager -->
       <div class="language-switcher"></div>

        <!-- Elegant Divider -->
        <div class="action-divider-desktop"></div>

        <!-- Auth Buttons Group -->
        <div class="auth-buttons-group-desktop">
            @if(Auth::check())
                <!-- Notification Icons -->
                <livewire:notifications :type="'desktop'" />

                <!-- User Dropdown Menu -->
                <div class="user-dropdown-container-desktop">
                    <button class="user-dropdown-trigger-desktop" aria-expanded="false" aria-haspopup="true" aria-label="User menu">
                        <div class="user-avatar-desktop">
                            <i class="fas fa-user-circle"></i>
                        </div>
                        <div class="user-info-desktop">
                            <span class="user-greeting-desktop" data-translate="user.welcome">Welcome</span>
                            <span class="user-name-desktop">{{ Auth::user()->username }}</span>
                        </div>
                        <i class="fas fa-chevron-down dropdown-arrow-desktop"></i>
                    </button>

                    <div class="user-dropdown-menu-desktop" role="menu" aria-hidden="true">
                        <!-- User Header -->
                        <div class="user-dropdown-header-desktop">
                            <div class="user-avatar-large-desktop">
                                <i class="fas fa-user-circle"></i>
                            </div>
                            <div class="user-details-desktop">
                                <h4 class="user-fullname-desktop">{{ Auth::user()->username }}</h4>
                                <p class="user-status-desktop">Premium Player</p>
                            </div>
                        </div>

                        <!-- Balance Section -->

                            <livewire:balance-head :type="'menu'" />
                        <!-- Menu Items -->
                        <div class="dropdown-menu-items-desktop">
                            <a href="{{ route('dashboard') }}" class="dropdown-menu-item-desktop" role="menuitem" tabindex="0">
                                <i class="fas fa-tachometer-alt"></i>
                                <span data-translate="user.dashboard">Dashboard</span>
                            </a>

                            @if(Auth::user()->hasRoleLevel(3))
                                <a href="{{ route('team-dashboard') }}" class="dropdown-menu-item-desktop team-dashboard-link" role="menuitem" tabindex="0">
                                    <i class="fas fa-users-cog"></i>
                                    <span data-translate="team.dashboard.title">Team Dashboard</span>
                                </a>
                            @endif
                        </div>

                        <!-- Logout Section -->
                        <div class="dropdown-divider-desktop"></div>
                        <div class="dropdown-logout-form-desktop">
                            <button type="button" class="dropdown-menu-item-desktop logout-btn-desktop" role="menuitem" tabindex="0" onclick="document.getElementById('logout-form').submit();">
                                <i class="fas fa-sign-out-alt"></i>
                                <span data-translate="user.logout">Logout</span>
                            </button>
                            <form id="logout-form" method="POST" action="{{ route('logout') }}" style="display: none;">
                                @csrf
                            </form>
                        </div>
                    </div>
                </div>
            @else
                <livewire:auth.register />
                <livewire:auth.login />
            @endif
        </div>
    </div>
</div>

@if(Auth::check())
<!-- Balance Display Section Below Header -->
<div class="balance-display-below-header">
    <livewire:balance-head :type="'desktop'" />
</div>
@endif

