<!DOCTYPE html>
<html lang="en" dir="ltr">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- Edge compatibility meta tags -->
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="msapplication-config" content="none" />
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title data-translate="hero.title">4TresSro - Epic RPG Adventure</title>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @livewireStyles

    <!-- CSRF Token Setup for AJAX requests -->
    <script>
        // Set up CSRF token for all AJAX requests
        window.Laravel = {
            csrfToken: "{{ csrf_token() }}"
        };

        // Set up axios defaults if axios is available
        if (typeof axios !== 'undefined') {
            axios.defaults.headers.common['X-CSRF-TOKEN'] = "{{ csrf_token() }}";
            axios.defaults.headers.common['X-Requested-With'] = 'XMLHttpRequest';
        }

        // Set up fetch defaults
        const originalFetch = window.fetch;
        window.fetch = function(url, options = {}) {
            options.headers = options.headers || {};
            options.headers['X-CSRF-TOKEN'] = "{{ csrf_token() }}";
            options.headers['X-Requested-With'] = 'XMLHttpRequest';
            return originalFetch.call(this, url, options);
        };
    </script>

    <!-- Language Support -->
    @php
        use App\Helpers\LanguageHelper;
        $languageData = LanguageHelper::getLanguageDataForJS();
    @endphp

    <script>
        // Pass language data from Laravel to JavaScript
        window.languageConfig = @json($languageData);

        // Initialize language on page load for faster rendering
        document.addEventListener('DOMContentLoaded', function() {
            // Priority: localStorage > server config > default 'en'
            const savedLang = localStorage.getItem('preferred-language');
            const serverLang = window.languageConfig.currentLanguage;
            const finalLang = savedLang || serverLang || 'en';



            document.documentElement.lang = finalLang;

            // Set RTL for Arabic
            if (finalLang === 'ar') {
                document.documentElement.dir = 'rtl';
            } else {
                document.documentElement.dir = 'ltr';
            }

            // Force preserve language immediately
            window.currentLanguagePreserved = finalLang;

            // Ensure localStorage is synced
            if (savedLang !== finalLang) {
                localStorage.setItem('preferred-language', finalLang);
            }
        });

        // Emergency language preservation system
        window.emergencyLanguagePreservation = function() {
            const savedLang = localStorage.getItem('preferred-language');
            if (savedLang && window.languageManager) {
                setTimeout(() => {
                    if (window.languageManager.currentLanguage !== savedLang) {
                        console.log('Emergency: Restoring saved language:', savedLang);
                        window.languageManager.setLanguage(savedLang);
                    }
                    window.languageManager.forceApplyCurrentLanguage();
                }, 100);
            }
        };

        // Run emergency preservation after full load
        window.addEventListener('load', function() {
            setTimeout(window.emergencyLanguagePreservation, 2000);
        });
    </script>    <!-- Edge CSS Variables Polyfill for older versions -->
    <script>
        // Simple CSS Variables polyfill for Edge legacy
        if (!window.CSS || !CSS.supports || !CSS.supports('color', 'var(--test)')) {
            // Fallback for very old Edge versions
            document.documentElement.style.setProperty('--color-game-purple-600', '#9333ea');
            document.documentElement.style.setProperty('--color-game-neon-cyan', '#00ffff');
        }
    </script>

    <style>
        /* Critical CSS for Edge compatibility - prevents FOUC */
        body {
            background: linear-gradient(135deg, #0a0a0f, #1a1a2e);
            color: #f0e7ff;
            font-family: 'Inter', system-ui, sans-serif;
        }

        /* Ensure cursor elements work in Edge */
        .cursor, .cursor-trail {
            pointer-events: none !important;
            position: fixed !important;
            z-index: 9999 !important;
        }
    </style>
</head>
