/**
 * Register Form Placeholder Updates
 * Updates placeholders dynamically based on language selection
 */

document.addEventListener('DOMContentLoaded', function() {
    // Update placeholders based on language
    function updateRegisterPlaceholders() {
        if (window.languageManager) {
            const usernameInput = document.querySelector('input[wire\\:model="StrUserID"]');
            const emailInput = document.querySelector('input[wire\\:model="email"]');
            const passwordInput = document.querySelector('input[wire\\:model="sro_password"]');
            const confirmPasswordInput = document.querySelector('input[wire\\:model="sro_password_confirmation"]');

            if (usernameInput) {
                usernameInput.placeholder = window.languageManager.getTranslation('authentication.enterGameUsername');
            }
            if (emailInput) {
                emailInput.placeholder = window.languageManager.getTranslation('authentication.enterEmailAddress');
            }
            if (passwordInput) {
                passwordInput.placeholder = window.languageManager.getTranslation('authentication.enterGamePassword');
            }
            if (confirmPasswordInput) {
                confirmPasswordInput.placeholder = window.languageManager.getTranslation('authentication.confirmYourPassword');
            }
        }
    }

    // Function to reapply translations after Livewire updates
    function reapplyRegisterTranslations() {
        if (window.languageManager) {
            // Re-apply all translations in the register modal
            setTimeout(() => {
                window.languageManager.applyTranslations();
                updateRegisterPlaceholders();
            }, 50);
        }
    }

    // Update placeholders initially
    setTimeout(updateRegisterPlaceholders, 100);

    // Listen for language changes
    document.addEventListener('languageChanged', updateRegisterPlaceholders);

    // Listen for Livewire updates (when form is submitted)
    document.addEventListener('livewire:navigated', reapplyRegisterTranslations);
    document.addEventListener('livewire:update', reapplyRegisterTranslations);

    // Also listen for custom Livewire events
    if (window.Livewire) {
        Livewire.on('*', () => {
            reapplyRegisterTranslations();
        });

        // Listen for preserve language event
        Livewire.on('preserve-language-state', () => {
            reapplyRegisterTranslations();
        });
    }

    // Also update when register modal opens or changes
    const observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            if (mutation.type === 'childList') {
                const registerModal = document.querySelector('.register-modal');
                if (registerModal) {
                    reapplyRegisterTranslations();
                }

                // Also check for any new elements with data-translate
                const newTranslatableElements = document.querySelectorAll('[data-translate]');
                if (newTranslatableElements.length > 0) {
                    reapplyRegisterTranslations();
                }
            }
        });
    });

    observer.observe(document.body, {
        childList: true,
        subtree: true
    });
});
