// Mobile Header JavaScript Functionality

document.addEventListener('DOMContentLoaded', function() {
    // Mobile Menu Toggle
    const mobileMenuBtn = document.getElementById('mobileMenuBtn');
    const mobileMenu = document.getElementById('mobileMenu');
    const mobileMenuOverlay = document.getElementById('mobileMenuOverlay');
    const mobileMenuClose = document.getElementById('mobileMenuClose');
    const mobileMenuCloseBottom = document.getElementById('mobileMenuCloseBottom');

    function toggleMobileMenu() {
        if (mobileMenu && mobileMenu.classList) {
            mobileMenu.classList.toggle('active');
        }
        if (mobileMenuOverlay && mobileMenuOverlay.classList) {
            mobileMenuOverlay.classList.toggle('active');
        }
        if (mobileMenuBtn && mobileMenuBtn.classList) {
            mobileMenuBtn.classList.toggle('active');
        }
        const mobileHeaderFixed = document.querySelector('.mobile-header-fixed');
        if (mobileHeaderFixed && mobileHeaderFixed.classList) {
            mobileHeaderFixed.classList.toggle('menu-open');
        }
        document.body.style.overflow = (mobileMenu && mobileMenu.classList.contains('active')) ? 'hidden' : '';
    }

    if (mobileMenuBtn) {
        mobileMenuBtn.addEventListener('click', toggleMobileMenu);
    }

    if (mobileMenuClose) {
        mobileMenuClose.addEventListener('click', toggleMobileMenu);
    }

    if (mobileMenuCloseBottom) {
        mobileMenuCloseBottom.addEventListener('click', toggleMobileMenu);
    }

    if (mobileMenuOverlay) {
        mobileMenuOverlay.addEventListener('click', toggleMobileMenu);
    }

    // Notification Dropdowns
    const notificationButtons = document.querySelectorAll('.mobile-header-notification-btn');
    const notificationDropdowns = document.querySelectorAll('.mobile-header-notification-dropdown');

    notificationButtons.forEach((btn, index) => {
        if (btn) {
            btn.addEventListener('click', function(e) {
                e.stopPropagation();

                // Close other dropdowns
                notificationDropdowns.forEach((dropdown, dropdownIndex) => {
                    if (dropdown && dropdownIndex !== index && dropdown.classList) {
                        dropdown.classList.remove('active');
                    }
                });

                // Toggle current dropdown
                const dropdown = notificationDropdowns[index];
                if (dropdown && dropdown.classList) {
                    dropdown.classList.toggle('active');
                    if (btn.classList) {
                        btn.classList.toggle('active');
                    }
                }
            });
        }
    });

    // Close dropdowns when clicking outside
    document.addEventListener('click', function() {
        notificationDropdowns.forEach(dropdown => {
            if (dropdown && dropdown.classList) {
                dropdown.classList.remove('active');
            }
        });
        notificationButtons.forEach(btn => {
            if (btn && btn.classList) {
                btn.classList.remove('active');
            }
        });
    });

    // User Accordion
    const userAccordionTrigger = document.getElementById('mobileUserTrigger');
    const userAccordionContent = document.getElementById('mobileUserAccordion');

    if (userAccordionTrigger && userAccordionContent) {
        userAccordionTrigger.addEventListener('click', function() {
            if (userAccordionContent.classList) {
                userAccordionContent.classList.toggle('active');
            }
            if (userAccordionTrigger.classList) {
                userAccordionTrigger.classList.toggle('active');
            }
        });
    }

    // Close mobile menu on navigation
    const mobileMenuItems = document.querySelectorAll('.mobile-menu-item');
    mobileMenuItems.forEach(item => {
        if (item) {
            item.addEventListener('click', function() {
                if (mobileMenu && mobileMenu.classList.contains('active')) {
                    toggleMobileMenu();
                }
            });
        }
    });

    // Handle window resize
    window.addEventListener('resize', function() {
        if (window.innerWidth > 768 && mobileMenu.classList.contains('active')) {
            toggleMobileMenu();
        }
    });

    // Prevent body scroll when menu is open on mobile
    function preventBodyScroll() {
        if (mobileMenu && mobileMenu.classList) {
            if (mobileMenu.classList.contains('active')) {
                document.body.style.overflow = 'hidden';
            } else {
                document.body.style.overflow = '';
            }
        }
    }

    // Listen for Livewire notification updates
    if (window.Livewire) {
        Livewire.on('notification-updated', (data) => {
            if (data.type === 'mobile') {
                updateMobileNotificationBadge('mobileHeaderNotificationsBadge', data.unreadCount);
            }
        });
    }

    // Update notification badges (example function)
    function updateNotificationBadges() {
        // Removed simulated data - notifications are now handled by Livewire
    }

    function updateMobileNotificationBadge(badgeId, count) {
        const badge = document.getElementById(badgeId);
        if (badge) {
            if (count > 0) {
                badge.textContent = count > 99 ? '99+' : count;
                badge.style.display = 'flex';
            } else {
                badge.style.display = 'none';
            }
        }
    }

    // Initialize
    updateNotificationBadges();

    // Update badges every 30 seconds (example)
    // setInterval(updateNotificationBadges, 30000); // Removed

    // Smooth scrolling for anchor links
    const anchorLinks = document.querySelectorAll('a[href^="#"]');
    anchorLinks.forEach(link => {
        if (link) {
            link.addEventListener('click', function(e) {
                const targetId = this.getAttribute('href');

                // Skip if href is just '#' or empty
                if (!targetId || targetId === '#' || targetId.length <= 1) {
                    return;
                }

                const targetElement = document.querySelector(targetId);

                if (targetElement) {
                    e.preventDefault();
                    const headerHeight = document.querySelector('.mobile-header-fixed');
                    const targetPosition = targetElement.offsetTop - (headerHeight ? headerHeight.offsetHeight : 0);

                    window.scrollTo({
                        top: targetPosition,
                        behavior: 'smooth'
                    });
                }
            });
        }
    });

    // Add loading states for buttons
    function addLoadingState(button) {
        button.disabled = true;
        button.innerHTML = '<i class="fas fa-spinner fa-spin"></i>';
        setTimeout(() => {
            button.disabled = false;
            button.innerHTML = button.dataset.originalHtml || button.innerHTML;
        }, 2000);
    }

    // Store original button content
    notificationButtons.forEach(btn => {
        btn.dataset.originalHtml = btn.innerHTML;
    });

    // Add touch support for mobile
    if ('ontouchstart' in window) {
        document.addEventListener('touchstart', function() {}, { passive: true });
    }

    // Accessibility improvements
    notificationButtons.forEach(btn => {
        if (btn) {
            btn.setAttribute('aria-expanded', 'false');
            btn.addEventListener('click', function() {
                const isExpanded = this.getAttribute('aria-expanded') === 'true';
                this.setAttribute('aria-expanded', !isExpanded);
            });
        }
    });

    if (userAccordionTrigger) {
        userAccordionTrigger.setAttribute('aria-expanded', 'false');
        userAccordionTrigger.addEventListener('click', function() {
            const isExpanded = this.getAttribute('aria-expanded') === 'true';
            this.setAttribute('aria-expanded', !isExpanded);
        });
    }
});
