/**
 * Welcome Event JavaScript Functions
 */

function scrollToApplication() {
    const applicationSection = document.getElementById('application-section');
    if (applicationSection) {
        applicationSection.style.display = 'block';
        applicationSection.scrollIntoView({
            behavior: 'smooth',
            block: 'start'
        });
    }
}

// Initialize welcome event functionality when DOM is ready
document.addEventListener('DOMContentLoaded', function() {
    // Add click event listener to welcome start button
    const welcomeStartBtn = document.querySelector('.welcome-start-btn');
    if (welcomeStartBtn) {
        welcomeStartBtn.addEventListener('click', scrollToApplication);
    }
});
