<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Z_Website\Download;

class UpdateDownloadsWithIconsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // أيقونات الشركات والمواقع
        $icons = [
            'google' => '<svg class="w-10 h-10" viewBox="0 0 24 24">
                <path fill="#4285F4" d="M22.56 12.25c0-.78-.07-1.53-.2-2.25H12v4.26h5.92c-.26 1.37-1.04 2.53-2.21 3.31v2.77h3.57c2.08-1.92 3.28-4.74 3.28-8.09z"/>
                <path fill="#34A853" d="M12 23c2.97 0 5.46-.98 7.28-2.66l-3.57-2.77c-.98.66-2.23 1.06-3.71 1.06-2.86 0-5.29-1.93-6.16-4.53H2.18v2.84C3.99 20.53 7.7 23 12 23z"/>
                <path fill="#FBBC05" d="M5.84 14.09c-.22-.66-.35-1.36-.35-2.09s.13-1.43.35-2.09V7.07H2.18C1.43 8.55 1 10.22 1 12s.43 3.45 1.18 4.93l2.85-2.22.81-.62z"/>
                <path fill="#EA4335" d="M12 5.38c1.62 0 3.06.56 4.21 1.64l3.15-3.15C17.45 2.09 14.97 1 12 1 7.7 1 3.99 3.47 2.18 7.07l3.66 2.84c.87-2.6 3.3-4.53 6.16-4.53z"/>
            </svg>',

            'mediafire' => '<svg class="w-10 h-10 text-white" fill="currentColor" viewBox="0 0 24 24">
                <path fill="#1299F3" d="M12 0L0 7v10l12 7 12-7V7L12 0zM11 16.5L4 12.5v-3l7 4v3zm0-6L4 6.5l7-4 7 4L11 10.5zm9 6.5l-7 4v-3l7-4v3z"/>
            </svg>',

            'mega' => '<svg class="w-10 h-10 text-white" fill="currentColor" viewBox="0 0 24 24">
                <path fill="#D9272E" d="M12 2L1.5 7.5v9L12 22l10.5-5.5v-9L12 2zm8.5 14L12 20.5 3.5 16V8.5L12 4l8.5 4.5V16z"/>
                <path fill="#D9272E" d="M12 6L6 9v6l6 3.5 6-3.5V9l-6-3z"/>
            </svg>',

            'pixeldrain' => '<svg class="w-10 h-10 text-white" fill="currentColor" viewBox="0 0 24 24">
                <path fill="#00D084" d="M12 2C6.48 2 2 6.48 2 12s4.48 10 10 10 10-4.48 10-10S17.52 2 12 2zm-1 15l-5-5 1.41-1.41L11 14.17l7.59-7.59L20 8l-9 9z"/>
            </svg>',

            // أيقونات الأدوات والبرامج
            'game_programs' => '<svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19.428 15.428a2 2 0 00-1.022-.547l-2.387-.477a6 6 0 00-3.86.517l-.318.158a6 6 0 01-3.86.517L6.05 15.21a2 2 0 00-1.806.547M8 4h8l-1 1v5.172a2 2 0 00.586 1.414l5 5c1.26 1.26.367 3.414-1.415 3.414H4.828c-1.782 0-2.674-2.154-1.414-3.414l5-5A2 2 0 009 10.172V5L8 4z"></path>
            </svg>',

            'exe_dll' => '<svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>',

            'dotnet' => '<svg class="w-10 h-10 text-white" fill="currentColor" viewBox="0 0 24 24">
                <path fill="#512BD4" d="M3.5 7.5L12 3l8.5 4.5V16L12 21l-8.5-5.5V7.5zM12 5.5L6.5 8.5v7L12 18.5l5.5-3v-7L12 5.5z"/>
                <circle cx="12" cy="12" r="3" fill="#512BD4"/>
            </svg>',

            'visual_cpp' => '<svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
            </svg>',

            'directx' => '<svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 4V2a1 1 0 011-1h8a1 1 0 011 1v2m3 0H4a1 1 0 00-1 1v1a1 1 0 001 1h1v13a2 2 0 002 2h10a2 2 0 002-2V7h1a1 1 0 001-1V5a1 1 0 00-1-1z"></path>
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10 11V9m4 2V9m-4 6V15m4 2V15"></path>
            </svg>'
        ];

        // إنشاء تحميلات جديدة مع الأيقونات
        $downloads = [
            // تحميلات العميل
            [
                'name' => '4TresSRO Online - Google Drive',
                'description' => 'تحميل العميل الكامل من Google Drive - سرعة عالية ومضمونة',
                'link' => 'https://drive.google.com/file/d/example',
                'file_size' => 4500000000, // 4.5 GB
                'version' => '1.500',
                'category' => 'client',
                'download_count' => 12543,
                'is_active' => true,
                'icon' => $icons['google'],
                'sort_order' => 1
            ],
            [
                'name' => '4TresSRO Online - MediaFire',
                'description' => 'تحميل العميل الكامل من MediaFire - بديل ممتاز وسريع',
                'link' => 'https://mediafire.com/file/example',
                'file_size' => 4500000000, // 4.5 GB
                'version' => '1.500',
                'category' => 'client',
                'download_count' => 8932,
                'is_active' => true,
                'icon' => $icons['mediafire'],
                'sort_order' => 2
            ],
            [
                'name' => '4TresSRO Online - MEGA',
                'description' => 'تحميل العميل الكامل من MEGA - آمن وموثوق',
                'link' => 'https://mega.nz/file/example',
                'file_size' => 4500000000, // 4.5 GB
                'version' => '1.500',
                'category' => 'client',
                'download_count' => 6754,
                'is_active' => true,
                'icon' => $icons['mega'],
                'sort_order' => 3
            ],
            [
                'name' => '4TresSRO Online - PixelDrain',
                'description' => 'تحميل العميل الكامل من PixelDrain - سريع ومجاني',
                'link' => 'https://pixeldrain.com/u/example',
                'file_size' => 4500000000, // 4.5 GB
                'version' => '1.500',
                'category' => 'client',
                'download_count' => 4287,
                'is_active' => true,
                'icon' => $icons['pixeldrain'],
                'sort_order' => 4
            ],

            // أدوات ومتطلبات النظام
            [
                'name' => '.NET Framework 4.8',
                'description' => 'مطلوب لتشغيل اللعبة - ضروري للتثبيت',
                'link' => 'https://dotnet.microsoft.com/download/dotnet-framework/net48',
                'file_size' => 120000000, // 120 MB
                'version' => '4.8.0',
                'category' => 'tool',
                'download_count' => 15432,
                'is_active' => true,
                'icon' => $icons['dotnet'],
                'sort_order' => 1
            ],
            [
                'name' => 'Visual C++ Redistributable 2019-2022',
                'description' => 'مكتبات Microsoft Visual C++ المطلوبة لتشغيل اللعبة',
                'link' => 'https://aka.ms/vs/17/release/vc_redist.x64.exe',
                'file_size' => 25000000, // 25 MB
                'version' => '14.34',
                'category' => 'tool',
                'download_count' => 11876,
                'is_active' => true,
                'icon' => $icons['visual_cpp'],
                'sort_order' => 2
            ],
            [
                'name' => 'DirectX End-User Runtime',
                'description' => 'مكتبات DirectX للرسوميات المحسنة',
                'link' => 'https://www.microsoft.com/download/details.aspx?id=35',
                'file_size' => 95000000, // 95 MB
                'version' => '9.29',
                'category' => 'tool',
                'download_count' => 9543,
                'is_active' => true,
                'icon' => $icons['directx'],
                'sort_order' => 3
            ],
            [
                'name' => '4TresSRO Game Programs Pack',
                'description' => 'حزمة البرامج الإضافية للعبة - تحسينات وإضافات مفيدة',
                'link' => 'https://example.com/game-programs',
                'file_size' => 50000000, // 50 MB
                'version' => '2.1',
                'category' => 'tool',
                'download_count' => 7234,
                'is_active' => true,
                'icon' => $icons['game_programs'],
                'sort_order' => 4
            ],
            [
                'name' => 'EXE & DLL Files Pack',
                'description' => 'ملفات إضافية مطلوبة لحل مشاكل التشغيل',
                'link' => 'https://example.com/exe-dll-pack',
                'file_size' => 15000000, // 15 MB
                'version' => '1.0',
                'category' => 'tool',
                'download_count' => 5698,
                'is_active' => true,
                'icon' => $icons['exe_dll'],
                'sort_order' => 5
            ]
        ];

        // حذف البيانات القديمة أولاً
        Download::truncate();

        // إدراج البيانات الجديدة
        foreach ($downloads as $download) {
            Download::create($download);
        }

        $this->command->info('تم تحديث جدول التحميلات بنجاح مع الأيقونات الجديدة!');
        $this->command->info('تم إنشاء ' . count($downloads) . ' سجل تحميل.');
    }
}
