<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\RechargeSettings;

class RechargeSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        RechargeSettings::truncate();

        $settings = [
            [
                'payment_method' => 'paypal',
                'is_active' => true,
                'fee_percentage' => 3.5,
                'minimum_amount' => 5.00,
                'maximum_amount' => 1000.00,
                'currency' => 'USD',
                'diamond_rate' => 100.0000, // 1 USD = 100 diamonds
                'phone_number' => null,
                'paypal_username' => '4TresSro',
                'additional_settings' => [
                    'paypal_me_url' => 'https://www.paypal.com/paypalme/4TresSro/',
                    'description' => 'International payment gateway with buyer protection'
                ]
            ],
            [
                'payment_method' => 'vodafone',
                'is_active' => true,
                'fee_percentage' => 2.0,
                'minimum_amount' => 50.00,
                'maximum_amount' => 5000.00,
                'currency' => 'EGP',
                'diamond_rate' => 3.2000, // 1 EGP = 3.2 diamonds
                'phone_number' => '01095161434',
                'paypal_username' => null,
                'additional_settings' => [
                    'ussd_code' => '*9*7*01095161434*{amount}#',
                    'description' => 'Fast local payment for Egyptian players',
                    'instructions' => 'Dial the USSD code or use Vodafone Cash app'
                ]
            ],
            [
                'payment_method' => 'instapay',
                'is_active' => true,
                'fee_percentage' => 1.5,
                'minimum_amount' => 20.00,
                'maximum_amount' => 10000.00,
                'currency' => 'EGP',
                'diamond_rate' => 3.2000, // 1 EGP = 3.2 diamonds
                'phone_number' => '01095161434',
                'paypal_username' => null,
                'additional_settings' => [
                    'bank_account' => '01095161434',
                    'description' => 'Instant bank transfer for Egyptian users',
                    'instructions' => 'Use InstaPay feature in your banking app'
                ]
            ]
        ];

        foreach ($settings as $setting) {
            RechargeSettings::create($setting);
        }
    }
}
