<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\RechargeRewardsSetting;

class RechargeRewardsSeeder extends Seeder
{
    public function run()
    {
        $tiers = [
            [
                'tier_name' => 'Bronze Explorer',
                'minimum_amount' => 0,
                'tier_color' => '#CD7F32',
                'tier_icon' => '🥉',
                'description' => 'Welcome to the adventure! Start your journey with basic rewards.',
                'rewards' => [
                    ['type' => 'bonus_percentage', 'value' => 5, 'name' => 'Welcome Bonus']
                ],
                'sort_order' => 1
            ],
            [
                'tier_name' => 'Silver Warrior',
                'minimum_amount' => 100,
                'tier_color' => '#C0C0C0',
                'tier_icon' => '🥈',
                'description' => 'You\'re getting stronger! Unlock better rewards and bonuses.',
                'rewards' => [
                    ['type' => 'diamonds', 'value' => 1000, 'name' => 'Loyalty Diamonds'],
                    ['type' => 'bonus_percentage', 'value' => 10, 'name' => 'Silver Bonus']
                ],
                'sort_order' => 2
            ],
            [
                'tier_name' => 'Gold Champion',
                'minimum_amount' => 300,
                'tier_color' => '#FFD700',
                'tier_icon' => '🥇',
                'description' => 'A true champion! Enjoy premium rewards and exclusive benefits.',
                'rewards' => [
                    ['type' => 'diamonds', 'value' => 3000, 'name' => 'Champion Diamonds'],
                    ['type' => 'vip_days', 'value' => 7, 'name' => 'VIP Access'],
                    ['type' => 'bonus_percentage', 'value' => 15, 'name' => 'Gold Bonus']
                ],
                'sort_order' => 3
            ],
            [
                'tier_name' => 'Diamond Elite',
                'minimum_amount' => 750,
                'tier_color' => '#B9F2FF',
                'tier_icon' => '💎',
                'description' => 'Elite status achieved! The best rewards await you.',
                'rewards' => [
                    ['type' => 'diamonds', 'value' => 7500, 'name' => 'Diamond Treasure'],
                    ['type' => 'vip_days', 'value' => 15, 'name' => 'Premium VIP'],
                    ['type' => 'bonus_percentage', 'value' => 20, 'name' => 'Diamond Bonus']
                ],
                'sort_order' => 4
            ],
            [
                'tier_name' => 'Legendary Master',
                'minimum_amount' => 1500,
                'tier_color' => '#FF6B6B',
                'tier_icon' => '👑',
                'description' => 'Legendary status! You are among the elite few.',
                'rewards' => [
                    ['type' => 'diamonds', 'value' => 15000, 'name' => 'Legendary Treasure'],
                    ['type' => 'vip_days', 'value' => 30, 'name' => 'Royal VIP'],
                    ['type' => 'bonus_percentage', 'value' => 25, 'name' => 'Master Bonus'],
                    ['type' => 'item', 'value' => 1, 'name' => 'Exclusive Mount']
                ],
                'sort_order' => 5
            ],
            [
                'tier_name' => 'Eternal Legend',
                'minimum_amount' => 3000,
                'tier_color' => '#9D4EDD',
                'tier_icon' => '⚡',
                'description' => 'You have transcended all limits! Ultimate rewards are yours.',
                'rewards' => [
                    ['type' => 'diamonds', 'value' => 30000, 'name' => 'Eternal Treasure'],
                    ['type' => 'vip_days', 'value' => 60, 'name' => 'Eternal VIP'],
                    ['type' => 'bonus_percentage', 'value' => 30, 'name' => 'Eternal Bonus'],
                    ['type' => 'item', 'value' => 1, 'name' => 'Legendary Weapon Set'],
                    ['type' => 'item', 'value' => 1, 'name' => 'Eternal Wings']
                ],
                'sort_order' => 6
            ]
        ];

        foreach ($tiers as $tier) {
            RechargeRewardsSetting::create($tier);
        }
    }
}
