<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Z_Website\GameInfo;

class GameInfoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $gameGuides = [
            [
                'category_name' => 'Character Classes',
                'sort' => 1,
                'title' => 'Warrior Class Guide',
                'body' => 'Warriors are the backbone of any adventure party. They excel in melee combat and can withstand massive damage. This comprehensive guide covers everything you need to know about building the perfect warrior character.

Key Features:
- High HP and Defense
- Excellent melee damage
- Tank capabilities
- Strong crowd control abilities

Recommended Build:
1. Focus on Strength and Constitution
2. Choose heavy armor for maximum protection
3. Master sword and shield combat
4. Learn defensive stances early

Advanced Tips:
- Use taunts to control enemy aggro
- Time your defensive cooldowns properly
- Coordinate with healers for maximum survivability
- Learn when to engage and disengage in combat

Equipment Guide:
The best weapons for warriors include two-handed swords, axes, and maces. For armor, prioritize pieces with high defense values and useful stat bonuses.',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'Character Classes',
                'sort' => 2,
                'title' => 'Archer Class Guide',
                'body' => 'Archers are masters of ranged combat, dealing devastating damage from a safe distance. This guide will teach you how to maximize your archery potential.

Class Overview:
Archers rely on dexterity and precision to eliminate enemies before they can close the distance. They are essential for both PvP and PvE content.

Core Skills:
- Multi-shot for crowd control
- Piercing shot for high single-target damage
- Evasion skills for survivability
- Trap abilities for area control

Stat Priority:
1. Dexterity (primary stat)
2. Intelligence (for skill damage)
3. Stamina (for survivability)

Combat Strategies:
- Maintain optimal range from enemies
- Use terrain to your advantage
- Coordinate with tanks for positioning
- Master kiting techniques

Best Equipment:
Look for bows with high attack speed and critical hit rates. Arrows with elemental damage can be game-changing in certain situations.',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'PvP Strategies',
                'sort' => 1,
                'title' => 'Guild War Tactics',
                'body' => 'Guild wars are the ultimate test of teamwork and strategy. Success requires careful planning, coordination, and execution.

Preparation Phase:
Before any guild war, ensure your guild is properly prepared with the right mix of classes, equipment, and strategies.

Formation Strategies:
1. Tank Wall Formation - Tanks in front, DPS behind
2. Pincer Movement - Attack from multiple angles
3. Hit and Run - Quick strikes followed by retreats
4. Siege Formation - Focused assault on objectives

Communication is Key:
- Use voice chat for real-time coordination
- Assign roles and responsibilities
- Have backup plans ready
- Practice formations before the war

Essential Roles:
- Commander: Overall strategy and coordination
- Scouts: Information gathering and early warning
- Healers: Keep the team alive
- DPS: Eliminate priority targets
- Tanks: Protect valuable team members

Post-War Analysis:
Always review what worked and what didn\'t. Learn from both victories and defeats to improve future performance.',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'PvP Strategies',
                'sort' => 2,
                'title' => '1v1 Combat Mastery',
                'body' => 'One-on-one combat is where individual skill shines brightest. Master these techniques to dominate in duels.

Fundamental Principles:
- Know your opponent\'s class strengths and weaknesses
- Manage your resources carefully
- Timing is everything
- Positioning can decide the outcome

Class Matchups:
Understanding how your class performs against others is crucial for success in 1v1 scenarios.

Warrior vs Archer:
- Close the distance quickly
- Use gap-closing abilities
- Force close-range combat

Archer vs Mage:
- Maintain medium range
- Use mobility to avoid spells
- Interrupt casting when possible

Combat Psychology:
- Stay calm under pressure
- Learn to read opponent patterns
- Use feints and misdirection
- Adapt your strategy mid-fight

Advanced Techniques:
- Animation canceling
- Combo execution
- Resource management
- Cooldown tracking

Training Methods:
Practice regularly with different opponents to improve your skills and learn various playstyles.',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'Items & Equipment',
                'sort' => 1,
                'title' => 'Weapon Enhancement Guide',
                'body' => 'Enhancing your weapons is crucial for staying competitive. This guide covers everything about the enhancement system.

Enhancement Basics:
Every weapon can be enhanced to increase its power. Higher enhancement levels provide significant stat boosts but come with increased risk of failure.

Enhancement Levels:
- +1 to +5: Safe enhancement with 100% success rate
- +6 to +10: Moderate risk with decreasing success rates
- +11 to +15: High risk but massive power gains

Required Materials:
- Enhancement stones (various grades)
- Weapon upgrade scrolls
- Protective items to prevent destruction

Success Tips:
1. Use lucky stones for better chances
2. Enhance during server events for bonuses
3. Consider the cost vs benefit ratio
4. Always use protective scrolls for high-level enhancements

Risk Management:
- Never enhance without protection past +10
- Have backup weapons ready
- Consider market prices before enhancing
- Set enhancement budgets and stick to them

Alternative Methods:
Some events offer guaranteed enhancement opportunities. Always participate in these special events to safely upgrade your gear.',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'Items & Equipment',
                'sort' => 2,
                'title' => 'Armor Set Combinations',
                'body' => 'The right armor combination can make or break your character build. Learn about the most effective armor sets and their synergies.

Set Bonuses:
Most armor pieces belong to sets that provide additional bonuses when worn together. These bonuses can significantly impact your character\'s performance.

Popular Armor Sets:

Guardian Set:
- 3-piece bonus: +15% defense
- 5-piece bonus: Damage reflection
- Best for: Tank builds

Assassin Set:
- 3-piece bonus: +20% critical hit rate
- 5-piece bonus: Shadow step ability
- Best for: High DPS builds

Mage Robes:
- 3-piece bonus: +25% mana
- 5-piece bonus: Spell cooldown reduction
- Best for: Caster builds

Mix and Match Strategy:
Sometimes combining pieces from different sets can be more effective than using complete sets, especially when targeting specific stat thresholds.

Optimization Tips:
- Calculate stat breakpoints
- Consider your playstyle
- Account for available gems and enchantments
- Test different combinations in practice

Maintenance:
Remember to repair your armor regularly and consider upgrade paths for long-term character development.',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'Leveling Guides',
                'sort' => 1,
                'title' => 'Fast Leveling 1-60',
                'body' => 'Reach level 60 efficiently with this comprehensive leveling guide that covers the fastest routes and methods.

Level Ranges and Strategies:

Levels 1-20: Tutorial and Basic Quests
- Complete all main story quests
- Focus on learning your class abilities
- Join a beginner-friendly guild
- Collect basic equipment

Levels 21-40: Dungeon Grinding
- Form consistent dungeon groups
- Target dungeons with best XP/time ratio
- Complete daily dungeon quests
- Start participating in events

Levels 41-60: Advanced Content
- Mix of dungeon runs and field grinding
- Participate in guild activities
- Complete epic quest chains
- Prepare for endgame content

XP Optimization Tips:
- Use XP boost items during prime time
- Complete daily quests consistently
- Participate in server events
- Group with similar level players

Efficient Grinding Spots:
Each level range has optimal grinding locations with good monster density and respawn rates. Research these spots and plan your grinding sessions.

Resource Management:
- Keep HP/MP potions stocked
- Maintain your equipment
- Manage your inventory space
- Save money for important upgrades',
                'image' => null,
                'active' => true,
            ],
            [
                'category_name' => 'Leveling Guides',
                'sort' => 2,
                'title' => 'Endgame Progression',
                'body' => 'Once you reach max level, the real game begins. This guide covers endgame progression and how to stay competitive.

Endgame Goals:
- Obtain the best gear possible
- Master all game mechanics
- Participate in high-level content
- Build your reputation in the community

Gear Progression Path:
1. Blue gear from dungeons
2. Purple gear from raids
3. Orange gear from special events
4. Legendary gear from ultimate challenges

Daily Activities:
- Complete daily quests for guaranteed rewards
- Run high-level dungeons for gear
- Participate in PvP for ranking points
- Farm rare materials for crafting

Long-term Objectives:
- Max out all important skills
- Collect rare mounts and pets
- Build strong guild relationships
- Prepare for new content releases

Staying Current:
The meta can change with updates and patches. Stay informed about:
- Balance changes
- New content releases
- Community strategies
- Market fluctuations

Investment Strategy:
Consider your time and gold investment carefully. Focus on upgrades that provide the biggest impact for your preferred activities.',
                'image' => null,
                'active' => true,
            ]
        ];

        foreach ($gameGuides as $guide) {
            GameInfo::create($guide);
        }
    }
}
