<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class FastEventSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        \App\Models\FastEvent::create([
            'event_name' => 'مكافأة يومية خاصة',
            'is_active' => true,
            'expired_at' => now()->addDays(30),
            'blade_name' => 'daily-bonus'
        ]);

        \App\Models\FastEvent::create([
            'event_name' => 'مسابقة أسبوعية',
            'is_active' => true,
            'expired_at' => now()->addWeek(),
            'blade_name' => 'weekly-competition'
        ]);

        \App\Models\FastEvent::create([
            'event_name' => 'حدث منتهي الصلاحية',
            'is_active' => false,
            'expired_at' => now()->subDays(5),
            'blade_name' => 'expired-event'
        ]);

        \App\Models\FastEvent::create([
            'event_name' => 'حدث غير نشط',
            'is_active' => false,
            'expired_at' => now()->addDays(10),
            'blade_name' => 'inactive-event'
        ]);
    }
}
