<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Z_Website\Download;

class DownloadSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $downloads = [
            // Game Clients
            [
                'name' => 'Silkroad Online Client v1.500',
                'file_size' => '4.2 GB',
                'link' => 'https://example.com/downloads/sro-client-v1500.zip',
                'description' => 'Latest Silkroad Online game client with all updates and features included. Complete installation package.',
                'version' => '1.500',
                'category' => 'client',
                'download_count' => 15420,
                'is_active' => true,
                'sort_order' => 1,
                'image' => '/assets/sro-client-preview.jpg'
            ],
            [
                'name' => 'Silkroad Online Lite Client',
                'file_size' => '2.8 GB',
                'link' => 'https://example.com/downloads/sro-lite-client.zip',
                'description' => 'Lightweight version of the client for older systems. Includes basic features only.',
                'version' => '1.488',
                'category' => 'client',
                'download_count' => 8750,
                'is_active' => true,
                'sort_order' => 2,
                'image' => '/assets/sro-lite-preview.jpg'
            ],

            // Tools
            [
                'name' => '.NET Framework 4.8',
                'file_size' => '118 MB',
                'link' => 'https://dotnet.microsoft.com/download/dotnet-framework/net48',
                'description' => 'Required Microsoft .NET Framework runtime for the game to function properly.',
                'version' => '4.8',
                'category' => 'tool',
                'download_count' => 25680,
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'name' => 'Visual C++ Redistributable 2019',
                'file_size' => '14.5 MB',
                'link' => 'https://support.microsoft.com/help/2977003/the-latest-supported-visual-c-downloads',
                'description' => 'Microsoft Visual C++ runtime libraries required for game components.',
                'version' => '14.28',
                'category' => 'tool',
                'download_count' => 12340,
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'DirectX End-User Runtime',
                'file_size' => '95.6 MB',
                'link' => 'https://www.microsoft.com/download/details.aspx?id=35',
                'description' => 'DirectX runtime libraries for enhanced graphics and audio performance.',
                'version' => '9.29.1974',
                'category' => 'tool',
                'download_count' => 18920,
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'name' => 'Character Build Calculator',
                'file_size' => '2.3 MB',
                'link' => 'https://example.com/downloads/char-calculator.zip',
                'description' => 'Plan your character build and calculate skill points allocation.',
                'version' => '2.1',
                'category' => 'tool',
                'download_count' => 5670,
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'name' => 'Trade Route Calculator',
                'file_size' => '1.8 MB',
                'link' => 'https://example.com/downloads/trade-calculator.zip',
                'description' => 'Calculate optimal trade routes and profit margins for merchants.',
                'version' => '3.4',
                'category' => 'tool',
                'download_count' => 4230,
                'is_active' => true,
                'sort_order' => 5
            ],
            [
                'name' => 'Game Guide PDF',
                'file_size' => '12.7 MB',
                'link' => 'https://example.com/downloads/sro-complete-guide.pdf',
                'description' => 'Complete beginner and advanced guide for Silkroad Online gameplay.',
                'version' => '5.2',
                'category' => 'tool',
                'download_count' => 9840,
                'is_active' => true,
                'sort_order' => 6
            ],

            // Launcher (Coming Soon)
            [
                'name' => 'Advanced Game Launcher',
                'file_size' => '25.4 MB',
                'link' => 'https://example.com/downloads/sro-launcher.exe',
                'description' => 'Advanced launcher with auto-update features and enhanced security.',
                'version' => '2.0.0',
                'category' => 'launcher',
                'download_count' => 0,
                'is_active' => false,
                'sort_order' => 1
            ],

            // Updates
            [
                'name' => 'Security Update v1.501',
                'file_size' => '145 MB',
                'link' => 'https://example.com/downloads/security-update-v1501.zip',
                'description' => 'Important security patches and bug fixes for enhanced gameplay experience.',
                'version' => '1.501',
                'category' => 'update',
                'download_count' => 3420,
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'name' => 'Content Update - New Dungeons',
                'file_size' => '287 MB',
                'link' => 'https://example.com/downloads/content-update-dungeons.zip',
                'description' => 'New dungeon content with exclusive rewards and challenging bosses.',
                'version' => '1.502',
                'category' => 'update',
                'download_count' => 2840,
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'Balance Update v1.503',
                'file_size' => '67 MB',
                'link' => 'https://example.com/downloads/balance-update-v1503.zip',
                'description' => 'Character class balance improvements and skill adjustments.',
                'version' => '1.503',
                'category' => 'update',
                'download_count' => 1920,
                'is_active' => true,
                'sort_order' => 3
            ]
        ];

        foreach ($downloads as $download) {
            Download::create($download);
        }
    }
}
