<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fast_events_welcomes', function (Blueprint $table) {
            $table->id();
            $table->string('JID'); // User JID (not unique, user can only have one application but multiple characters)
            $table->string('HWID')->nullable(); // Hardware ID
            $table->enum('player_type', ['new', 'old', 'donate']); // Player Type
            $table->integer('CharID'); // Selected Character ID

            // Old Player Fields
            $table->string('old_character_name')->nullable(); // Old character name
            $table->json('old_character_proofs')->nullable(); // JSON array of proof images

            // donate Player Fields
            $table->decimal('donation_amount', 10, 2)->nullable(); // Donation amount
            $table->enum('currency', ['USD', 'EGP'])->nullable(); // Currency type
            $table->integer('reward_amount')->default(0); // Calculated reward amount
            $table->json('donation_proofs')->nullable(); // JSON array of donation proof images

            // Optional images for all types
            $table->json('old_character_images')->nullable(); // JSON array of old character images

            // Status and Review
            $table->enum('status', ['pending', 'approved', 'rejected', 'claimed'])->default('pending');
            $table->text('rejection_reason')->nullable(); // Reason for rejection
            $table->timestamp('submitted_at')->nullable(); // When it was submitted
            $table->timestamp('reviewed_at')->nullable(); // When it was reviewed
            $table->integer('reviewer_id')->nullable(); // Admin who reviewed
            $table->timestamp('claimed_at')->nullable(); // When reward was claimed

            $table->timestamps();

            // Indexes
            $table->index(['JID', 'status']);
            $table->index(['HWID', 'status']);
            $table->index('player_type');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fast_events_welcomes');
    }
};
