<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fast_events_duo', function (Blueprint $table) {
            // إضافة العمود الجديد
            $table->string('partner_referrer_id', 50)->nullable()->after('role');

            // إضافة فهرس للبحث السريع
            $table->index('partner_referrer_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fast_events_duo', function (Blueprint $table) {
            $table->dropIndex(['partner_referrer_id']);
            $table->dropColumn('partner_referrer_id');
        });
    }
};
