<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fast_events_treasure', function (Blueprint $table) {
            $table->boolean('accepted')->default(false)->after('collected_at');
            $table->unsignedBigInteger('accepted_by')->nullable()->after('accepted');
            $table->timestamp('accepted_at')->nullable()->after('accepted_by');

            // إضافة فهرس للبحث السريع
            $table->index(['accepted', 'accepted_by']);

            // إضافة مفتاح خارجي إذا كان لديك جدول المستخدمين
            // $table->foreign('accepted_by')->references('id')->on('users')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fast_events_treasure', function (Blueprint $table) {
            $table->dropIndex(['accepted', 'accepted_by']);
            $table->dropColumn(['accepted', 'accepted_by', 'accepted_at']);
        });
    }
};
