<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('fast_events_treasure', function (Blueprint $table) {
            $table->boolean('collected')->default(false)->after('total_points'); // هل تم جمع المكافأة
            $table->timestamp('collected_at')->nullable()->after('collected'); // تاريخ الجمع

            // إضافة فهرس للبحث
            $table->index(['user_id', 'collected']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('fast_events_treasure', function (Blueprint $table) {
            $table->dropIndex(['user_id', 'collected']);
            $table->dropColumn(['collected', 'collected_at']);
        });
    }
};
