<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fast_events_treasure', function (Blueprint $table) {
            $table->id();
            $table->integer('user_id')->index(); // JID من جدول المستخدمين
            $table->string('link')->unique(); // رابط المشاركة (unique)
            $table->boolean('like')->default(false); // Like true or false
            $table->boolean('comment')->default(false); // Comment true or false
            $table->boolean('share')->default(false); // Share true or false
            $table->integer('total_points')->default(0); // مجموع النقاط
            $table->timestamp('created_at')->useCurrent(); // تاريخ الإنشاء
            $table->timestamp('updated_at')->useCurrent()->useCurrentOnUpdate(); // تاريخ التحديث

            // إضافة فهارس للبحث السريع
            $table->index(['user_id', 'created_at']);
            $table->index('total_points');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fast_events_treasure');
    }
};
