<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fast_events', function (Blueprint $table) {
            $table->id();
            $table->string('event_name');
            $table->boolean('is_active')->default(true);
            $table->datetime('expired_at')->nullable();
            $table->string('blade_name')->nullable()->comment('اسم ملف blade.php في مجلد fastEvents');
            $table->timestamps();

            $table->index(['is_active', 'expired_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fast_events');
    }
};
