<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('market_transactions', function (Blueprint $table) {
            $table->id();
            $table->string('transaction_id')->unique(); // معرف المعاملة الفريد
            $table->integer('user_jid'); // معرف المستخدم
            $table->string('username')->nullable(); // اسم المستخدم
            $table->enum('transaction_type', ['package', 'item']); // نوع المعاملة
            $table->integer('item_id')->nullable(); // معرف العنصر أو الباكيج
            $table->string('item_name'); // اسم العنصر أو الباكيج
            $table->integer('quantity')->default(1); // الكمية
            $table->decimal('unit_price', 10, 2); // سعر الوحدة
            $table->decimal('total_price', 10, 2); // السعر الإجمالي
            $table->string('currency_type'); // نوع العملة (balance, gift_balance, silk, donate)
            $table->decimal('balance_before', 10, 2); // الرصيد قبل المعاملة
            $table->decimal('balance_after', 10, 2); // الرصيد بعد المعاملة
            $table->enum('status', ['success', 'failed', 'pending'])->default('pending'); // حالة المعاملة
            $table->text('error_message')->nullable(); // رسالة الخطأ إن وجدت
            $table->json('transaction_details')->nullable(); // تفاصيل إضافية
            $table->string('ip_address')->nullable(); // عنوان IP
            $table->string('user_agent')->nullable(); // معلومات المتصفح
            $table->timestamps();

            // Indexes for better performance
            $table->index(['user_jid', 'created_at']);
            $table->index(['transaction_type', 'created_at']);
            $table->index(['status', 'created_at']);
            $table->index('transaction_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('market_transactions');
    }
};
