<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('game_info', function (Blueprint $table) {
            $table->id();
            $table->string('category_name');
            $table->integer('sort')->default(0);
            $table->string('title');
            $table->text('body');
            $table->string('image')->nullable();
            $table->boolean('active')->default(true);
            $table->timestamps();

            // Indexes for better performance
            $table->index(['category_name', 'sort']);
            $table->index('active');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('game_info');
    }
};
