<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('user_votes', function (Blueprint $table) {
            $table->boolean('postback_received')->default(false)->after('next_vote_time');
            $table->json('postback_data')->nullable()->after('postback_received');
            $table->timestamp('postback_received_at')->nullable()->after('postback_data');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('user_votes', function (Blueprint $table) {
            $table->dropColumn(['postback_received', 'postback_data', 'postback_received_at']);
        });
    }
};
