<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('downloads', function (Blueprint $table) {
            // Add new columns if they don't exist
            if (!Schema::hasColumn('downloads', 'description')) {
                $table->text('description')->nullable()->after('name');
            }
            if (!Schema::hasColumn('downloads', 'version')) {
                $table->string('version')->nullable()->after('file_size');
            }
            if (!Schema::hasColumn('downloads', 'category')) {
                $table->string('category')->default('client')->after('version');
            }
            if (!Schema::hasColumn('downloads', 'download_count')) {
                $table->integer('download_count')->default(0)->after('category');
            }
            if (!Schema::hasColumn('downloads', 'is_active')) {
                $table->boolean('is_active')->default(true)->after('download_count');
            }
            if (!Schema::hasColumn('downloads', 'sort_order')) {
                $table->integer('sort_order')->default(0)->after('is_active');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('downloads', function (Blueprint $table) {
            // Drop the added columns
            $columns = ['description', 'version', 'category', 'download_count', 'is_active', 'sort_order'];

            foreach ($columns as $column) {
                if (Schema::hasColumn('downloads', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};
