<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('fast_events_duo', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('user_id'); // المستخدم الذي أنشأ الطلب
            $table->enum('role', ['sender', 'receiver']); // نوع الدور (داعي أو مدعو)
            $table->string('partner_username')->nullable(); // اسم الشريك المطلوب
            $table->unsignedBigInteger('partner_user_id')->nullable(); // معرف الشريك إذا تم العثور عليه

            // روابط الفيسبوك (5 روابط)
            $table->text('facebook_link_1')->nullable();
            $table->text('facebook_link_2')->nullable();
            $table->text('facebook_link_3')->nullable();
            $table->text('facebook_link_4')->nullable();
            $table->text('facebook_link_5')->nullable();

            // حالة الأنشطة لكل رابط (like, comment, share)
            $table->boolean('link1_like')->default(false);
            $table->boolean('link1_comment')->default(false);
            $table->boolean('link1_share')->default(false);

            $table->boolean('link2_like')->default(false);
            $table->boolean('link2_comment')->default(false);
            $table->boolean('link2_share')->default(false);

            $table->boolean('link3_like')->default(false);
            $table->boolean('link3_comment')->default(false);
            $table->boolean('link3_share')->default(false);

            $table->boolean('link4_like')->default(false);
            $table->boolean('link4_comment')->default(false);
            $table->boolean('link4_share')->default(false);

            $table->boolean('link5_like')->default(false);
            $table->boolean('link5_comment')->default(false);
            $table->boolean('link5_share')->default(false);

            // حالة القبول والرفض
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->unsignedBigInteger('reviewed_by')->nullable(); // من راجع الطلب
            $table->timestamp('reviewed_at')->nullable(); // وقت المراجعة

            // حالة التجميع
            $table->boolean('collected')->default(false);
            $table->timestamp('collected_at')->nullable();

            // حساب النقاط
            $table->integer('total_points')->default(0);
            $table->integer('reward_amount')->default(0); // مقدار المكافأة (50 للداعي، 20 للمدعو)

            $table->timestamps();

            // إضافة الفهارس
            $table->index('user_id');
            $table->index('partner_user_id');
            $table->index('partner_username');
            $table->index('status');
            $table->index('role');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('fast_events_duo');
    }
};
